/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.util;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Scope;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class NativeUtil {
    public static List<Tree.Statement> mergeStatements(Tree.Body body, Tree.Declaration header, Backend backend) {
        List<Tree.Statement> hdrstmts = header instanceof Tree.ClassDefinition ? ((Tree.ClassDefinition)header).getClassBody().getStatements() : (header instanceof Tree.InterfaceDefinition ? ((Tree.InterfaceDefinition)header).getInterfaceBody().getStatements() : (header instanceof Tree.ObjectDefinition ? ((Tree.ObjectDefinition)header).getClassBody().getStatements() : null));
        List<Tree.Statement> stmts = body.getStatements();
        if (hdrstmts != null && !hdrstmts.isEmpty()) {
            String key;
            Declaration m;
            Tree.Declaration decl;
            LinkedHashMap<String, Tree.Statement> stmtsmap = new LinkedHashMap<String, Tree.Statement>();
            int idx = 0;
            for (Tree.Statement stmt : stmts) {
                if (stmt instanceof Tree.Declaration) {
                    decl = (Tree.Declaration)stmt;
                    m = decl.getDeclarationModel();
                    if (m.isNativeImplementation() && !NativeUtil.isForBackend(m, backend)) continue;
                    key = m.getClass().getSimpleName() + "#" + m.getName();
                    stmtsmap.put(key, decl);
                    continue;
                }
                stmtsmap.put("#" + idx++, stmt);
            }
            for (Tree.Statement stmt : hdrstmts) {
                if (!(stmt instanceof Tree.Declaration) || !ModelUtil.isImplemented(m = (decl = (Tree.Declaration)stmt).getDeclarationModel()) || stmtsmap.containsKey(key = m.getClass().getSimpleName() + "#" + m.getName())) continue;
                stmtsmap.put(key, decl);
            }
            stmts = new ArrayList(stmtsmap.values());
        }
        return stmts;
    }

    public static boolean isImplemented(Tree.Declaration decl) {
        return ModelUtil.isImplemented(decl.getDeclarationModel());
    }

    public static boolean isNative(Tree.Declaration decl) {
        return NativeUtil.isNative(decl.getDeclarationModel());
    }

    public static boolean isNative(Declaration decl) {
        return decl.isNative();
    }

    public static boolean isNativeHeader(Tree.Declaration decl) {
        return NativeUtil.isNativeHeader(decl.getDeclarationModel());
    }

    public static boolean isNativeHeader(Declaration decl) {
        return decl.isNativeHeader();
    }

    public static Backends getNative(Tree.Declaration decl) {
        return decl.getDeclarationModel().getNativeBackends();
    }

    public static boolean isForBackend(Tree.Declaration decl, Backend backend) {
        return NativeUtil.isForBackend(decl.getDeclarationModel(), backend);
    }

    public static boolean isForBackend(Declaration decl, Backend backend) {
        Backends bs = decl.getNativeBackends();
        return bs.none() || bs.supports(backend);
    }

    public static boolean isHeaderWithoutBackend(Tree.Declaration decl, Backend backend) {
        return NativeUtil.isHeaderWithoutBackend(decl.getDeclarationModel(), backend);
    }

    public static boolean isHeaderWithoutBackend(Declaration decl, Backend backend) {
        return decl.isNativeHeader() && ModelUtil.getNativeDeclaration(decl, backend) == null;
    }

    public static boolean hasNativeMembers(ClassOrInterface coi) {
        for (Declaration d : coi.getMembers()) {
            if (!d.isNative()) continue;
            return true;
        }
        return false;
    }

    public static void checkNotJvm(Node that, String message) {
        Backends backends;
        Backends scopedBackends = that.getScope().getScopedBackends();
        Backends backends2 = backends = scopedBackends.none() ? that.getUnit().getSupportedBackends() : scopedBackends;
        if (backends.supports(Backend.Java)) {
            that.addUnsupportedError(message, Backend.Java);
        }
    }

    public static Declaration declarationScope(Scope that) {
        if (that == null) {
            return null;
        }
        if (that instanceof Declaration) {
            return (Declaration)((Object)that);
        }
        return NativeUtil.declarationScope(that.getScope());
    }
}

