/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.util;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.compiler.typechecker.util.ReferenceCounter;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;

public class UsageVisitor
extends Visitor {
    private final ReferenceCounter rc;

    public UsageVisitor(ReferenceCounter rc) {
        this.rc = rc;
    }

    @Override
    public void visit(Tree.CompilationUnit that) {
        super.visit(that);
    }

    @Override
    public void visit(Tree.ImportMemberOrType that) {
        super.visit(that);
        if (!this.referenced(that)) {
            that.addUsageWarning(Warning.unusedImport, "import is never used: '" + that.getDeclarationModel().getName() + "'");
        }
    }

    private boolean referenced(Tree.ImportMemberOrType that) {
        Declaration d = that.getDeclarationModel();
        boolean referenced = true;
        if (d != null) {
            Tree.ImportMemberOrTypeList imtl;
            referenced = this.rc.isReferenced(d);
            if (ModelUtil.isAbstraction(d)) {
                for (Declaration od : d.getOverloads()) {
                    referenced = referenced || this.rc.isReferenced(od);
                }
            }
            if ((imtl = that.getImportMemberOrTypeList()) != null) {
                for (Tree.ImportMemberOrType m : imtl.getImportMemberOrTypes()) {
                    referenced = referenced || this.referenced(m);
                }
                if (imtl.getImportWildcard() != null) {
                    referenced = true;
                }
            }
        }
        return referenced;
    }

    @Override
    public void visit(Tree.Declaration that) {
        super.visit(that);
        Declaration declaration = that.getDeclarationModel();
        Backends bs = declaration.getNativeBackends();
        if (!(declaration == null || declaration.getName() == null || declaration.isShared() || declaration.isToplevel() || this.rc.isReferenced(declaration) || declaration.isParameter() || that instanceof Tree.Variable || declaration instanceof TypeParameter && ((TypeParameter)declaration).getDeclaration() instanceof TypeParameter || !bs.none() && !ModelUtil.isForBackend(bs, that.getUnit()))) {
            that.addUsageWarning(Warning.unusedDeclaration, "declaration is never used: '" + declaration.getName() + "'");
        }
    }

    @Override
    public void visit(Tree.Term that) {
        Backends inBackends;
        Type type;
        super.visit(that);
        if (!TreeUtil.hasErrorOrWarning(that) && !ModelUtil.isTypeUnknown(type = that.getTypeModel()) && type.isNothing() && ((inBackends = that.getScope().getScopedBackends()).none() || ModelUtil.isForBackend(inBackends, that.getUnit()))) {
            that.addUsageWarning(Warning.expressionTypeNothing, "expression has type 'Nothing'");
        }
    }
}

