/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.util;

import com.redhat.ceylon.compiler.typechecker.analyzer.UsageWarning;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class WarningSuppressionVisitor<E extends Enum<E>>
extends Visitor {
    private Class<E> enumType;
    private EnumMap<E, Boolean> suppressed;
    private EnumMap<E, Integer> counts;

    public WarningSuppressionVisitor(Class<E> enumType, EnumSet<E> initial) {
        this.enumType = enumType;
        this.suppressed = new EnumMap(enumType);
        for (Enum e : initial) {
            this.suppressed.put(e, false);
        }
        this.counts = new EnumMap(enumType);
        for (Enum e : EnumSet.allOf(enumType)) {
            this.counts.put(e, 0);
        }
    }

    private E parseName(String name) {
        try {
            return Enum.valueOf(this.enumType, name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void visitAny(Node that) {
        for (Message error : that.getErrors()) {
            UsageWarning warning;
            E warningName;
            if (!(error instanceof UsageWarning) || (warningName = this.parseName((warning = (UsageWarning)error).getWarningName())) == null) continue;
            Integer numSuppressed = this.counts.get(warningName);
            if (this.suppressed.get(warningName) == null) continue;
            warning.setSuppressed(true);
            this.counts.put(warningName, numSuppressed + 1);
        }
        super.visitAny(that);
    }

    @Override
    public void visit(Tree.Declaration that) {
        if (!TreeUtil.isForUnsupportedBackend(that.getAnnotationList(), that.getUnit())) {
            Object priorCounts = this.counts.clone();
            EnumMap<E, Boolean> added = this.pre(that.getAnnotationList());
            super.visit(that);
            this.post((EnumMap<E, Integer>)priorCounts, added, that.getAnnotationList());
        }
    }

    @Override
    public void visit(Tree.ModuleDescriptor that) {
        if (!TreeUtil.isForUnsupportedBackend(that.getAnnotationList(), that.getUnit())) {
            Object priorCounts = this.counts.clone();
            EnumMap<E, Boolean> added = this.pre(that.getAnnotationList());
            super.visit(that);
            this.post((EnumMap<E, Integer>)priorCounts, added, that.getAnnotationList());
        }
    }

    @Override
    public void visit(Tree.PackageDescriptor that) {
        Object priorCounts = this.counts.clone();
        EnumMap<E, Boolean> added = this.pre(that.getAnnotationList());
        super.visit(that);
        this.post((EnumMap<E, Integer>)priorCounts, added, that.getAnnotationList());
    }

    @Override
    public void visit(Tree.ImportModule that) {
        if (!TreeUtil.isForUnsupportedBackend(that.getAnnotationList(), that.getUnit())) {
            Object priorCounts = this.counts.clone();
            EnumMap<E, Boolean> added = this.pre(that.getAnnotationList());
            super.visit(that);
            this.post((EnumMap<E, Integer>)priorCounts, added, that.getAnnotationList());
        }
    }

    @Override
    public void visit(Tree.Assertion that) {
        Object priorCounts = this.counts.clone();
        EnumMap<E, Boolean> added = this.pre(that.getAnnotationList());
        super.visit(that);
        this.post((EnumMap<E, Integer>)priorCounts, added, that.getAnnotationList());
    }

    private EnumMap<E, Boolean> pre(Tree.AnnotationList al) {
        EnumMap<E, Boolean> added = new EnumMap<E, Boolean>(this.enumType);
        for (Map.Entry<E, Tree.StringLiteral> entry : this.getWarningNames(this.findSuppressWarnings(al), true).entrySet()) {
            Enum warning = (Enum)entry.getKey();
            Boolean suppressedByAnnotation = this.suppressed.get(warning);
            if (suppressedByAnnotation == null) {
                this.suppressed.put(warning, true);
                added.put(warning, null);
                continue;
            }
            if (suppressedByAnnotation.booleanValue()) {
                entry.getValue().addUsageWarning(Warning.suppressedAlready, "warnings already suppressed by annotation");
                added.put(warning, true);
                continue;
            }
            this.suppressed.put(warning, true);
            added.put(warning, false);
        }
        return added;
    }

    private void post(EnumMap<E, Integer> priorCounts, EnumMap<E, Boolean> added, Tree.AnnotationList al) {
        for (Map.Entry<E, Tree.StringLiteral> warningName : this.getWarningNames(this.findSuppressWarnings(al), false).entrySet()) {
            Integer after;
            Integer before = priorCounts.get(warningName.getKey());
            if (before == null) {
                before = 0;
            }
            if ((after = this.counts.get(warningName.getKey())) == null) {
                after = 0;
            }
            if (after - before != 0 || this.suppressed.get((Object)Warning.suppressesNothing) != null) continue;
            warningName.getValue().addUsageWarning(Warning.suppressesNothing, "suppresses no warnings");
        }
        this.suppressed.putAll(added);
    }

    public Tree.Annotation findSuppressWarnings(Tree.AnnotationList that) {
        if (that != null && that.getAnnotations() != null) {
            for (Tree.Annotation anno : that.getAnnotations()) {
                Tree.Annotation suppressWarnings = WarningSuppressionVisitor.getSuppressWarnings(anno);
                if (suppressWarnings == null) continue;
                return suppressWarnings;
            }
        }
        return null;
    }

    private static Tree.Annotation getSuppressWarnings(Tree.Annotation anno) {
        Tree.MemberOrTypeExpression mte;
        Declaration declaration;
        Tree.Primary primary = anno.getPrimary();
        if (primary instanceof Tree.MemberOrTypeExpression && (declaration = (mte = (Tree.MemberOrTypeExpression)primary).getDeclaration()) != null && declaration.equals(anno.getUnit().getLanguageModuleDeclaration("suppressWarnings"))) {
            return anno;
        }
        return null;
    }

    private Map<E, Tree.StringLiteral> getWarningNames(Tree.Annotation anno, final boolean warnAboutUnknownWarnings) {
        if (anno == null) {
            return Collections.emptyMap();
        }
        final HashMap suppressed = new HashMap(2);
        anno.visit(new Visitor(){

            @Override
            public void visit(Tree.StringLiteral that) {
                String warningName = that.getText();
                Enum warning = WarningSuppressionVisitor.this.parseName(warningName);
                if (warning == null) {
                    if (warnAboutUnknownWarnings && suppressed.get((Object)Warning.unknownWarning) == null) {
                        that.addUsageWarning(Warning.unknownWarning, "unknown warning: " + warningName);
                    }
                } else {
                    suppressed.put(warning, that);
                }
            }
        });
        return suppressed;
    }
}

