/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.classfile;

import com.redhat.ceylon.langtools.classfile.AccessFlags;
import com.redhat.ceylon.langtools.classfile.Attribute;
import com.redhat.ceylon.langtools.classfile.ClassReader;
import com.redhat.ceylon.langtools.classfile.ConstantPool;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import java.io.IOException;

public class InnerClasses_attribute
extends Attribute {
    public final int number_of_classes;
    public final Info[] classes;

    InnerClasses_attribute(ClassReader cr, int name_index, int length) throws IOException {
        super(name_index, length);
        this.number_of_classes = cr.readUnsignedShort();
        this.classes = new Info[this.number_of_classes];
        for (int i = 0; i < this.number_of_classes; ++i) {
            this.classes[i] = new Info(cr);
        }
    }

    public InnerClasses_attribute(ConstantPool constant_pool, Info[] classes) throws ConstantPoolException {
        this(constant_pool.getUTF8Index("InnerClasses"), classes);
    }

    public InnerClasses_attribute(int name_index, Info[] classes) {
        super(name_index, 2 + Info.length() * classes.length);
        this.number_of_classes = classes.length;
        this.classes = classes;
    }

    @Override
    public <R, D> R accept(Attribute.Visitor<R, D> visitor, D data) {
        return visitor.visitInnerClasses(this, data);
    }

    public static class Info {
        public final int inner_class_info_index;
        public final int outer_class_info_index;
        public final int inner_name_index;
        public final AccessFlags inner_class_access_flags;

        Info(ClassReader cr) throws IOException {
            this.inner_class_info_index = cr.readUnsignedShort();
            this.outer_class_info_index = cr.readUnsignedShort();
            this.inner_name_index = cr.readUnsignedShort();
            this.inner_class_access_flags = new AccessFlags(cr.readUnsignedShort());
        }

        public ConstantPool.CONSTANT_Class_info getInnerClassInfo(ConstantPool constant_pool) throws ConstantPoolException {
            if (this.inner_class_info_index == 0) {
                return null;
            }
            return constant_pool.getClassInfo(this.inner_class_info_index);
        }

        public ConstantPool.CONSTANT_Class_info getOuterClassInfo(ConstantPool constant_pool) throws ConstantPoolException {
            if (this.outer_class_info_index == 0) {
                return null;
            }
            return constant_pool.getClassInfo(this.outer_class_info_index);
        }

        public String getInnerName(ConstantPool constant_pool) throws ConstantPoolException {
            if (this.inner_name_index == 0) {
                return null;
            }
            return constant_pool.getUTF8Value(this.inner_name_index);
        }

        public static int length() {
            return 8;
        }
    }
}

