/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.classfile;

import com.redhat.ceylon.langtools.classfile.Opcode;

public class Instruction {
    private byte[] bytes;
    private int pc;

    public Instruction(byte[] bytes, int pc) {
        this.bytes = bytes;
        this.pc = pc;
    }

    public int getPC() {
        return this.pc;
    }

    public int getByte(int offset) {
        return this.bytes[this.pc + offset];
    }

    public int getUnsignedByte(int offset) {
        return this.getByte(offset) & 0xFF;
    }

    public int getShort(int offset) {
        return this.getByte(offset) << 8 | this.getUnsignedByte(offset + 1);
    }

    public int getUnsignedShort(int offset) {
        return this.getShort(offset) & 0xFFFF;
    }

    public int getInt(int offset) {
        return this.getShort(offset) << 16 | this.getUnsignedShort(offset + 2);
    }

    public Opcode getOpcode() {
        int b = this.getUnsignedByte(0);
        switch (b) {
            case 196: 
            case 254: 
            case 255: {
                return Opcode.get(b, this.getUnsignedByte(1));
            }
        }
        return Opcode.get(b);
    }

    public String getMnemonic() {
        Opcode opcode = this.getOpcode();
        if (opcode == null) {
            return "bytecode " + this.getUnsignedByte(0);
        }
        return opcode.toString().toLowerCase();
    }

    public int length() {
        Opcode opcode = this.getOpcode();
        if (opcode == null) {
            return 1;
        }
        switch (opcode) {
            case TABLESWITCH: {
                int pad = Instruction.align(this.pc + 1) - this.pc;
                int low = this.getInt(pad + 4);
                int high = this.getInt(pad + 8);
                return pad + 12 + 4 * (high - low + 1);
            }
            case LOOKUPSWITCH: {
                int pad = Instruction.align(this.pc + 1) - this.pc;
                int npairs = this.getInt(pad + 4);
                return pad + 8 + 8 * npairs;
            }
        }
        return opcode.kind.length;
    }

    public Kind getKind() {
        Opcode opcode = this.getOpcode();
        return opcode != null ? opcode.kind : Kind.UNKNOWN;
    }

    public <R, P> R accept(KindVisitor<R, P> visitor, P p) {
        switch (this.getKind()) {
            case NO_OPERANDS: {
                return visitor.visitNoOperands(this, p);
            }
            case ATYPE: {
                return visitor.visitArrayType(this, TypeKind.get(this.getUnsignedByte(1)), p);
            }
            case BRANCH: {
                return visitor.visitBranch(this, this.getShort(1), p);
            }
            case BRANCH_W: {
                return visitor.visitBranch(this, this.getInt(1), p);
            }
            case BYTE: {
                return visitor.visitValue(this, this.getByte(1), p);
            }
            case CPREF: {
                return visitor.visitConstantPoolRef(this, this.getUnsignedByte(1), p);
            }
            case CPREF_W: {
                return visitor.visitConstantPoolRef(this, this.getUnsignedShort(1), p);
            }
            case CPREF_W_UBYTE: 
            case CPREF_W_UBYTE_ZERO: {
                return visitor.visitConstantPoolRefAndValue(this, this.getUnsignedShort(1), this.getUnsignedByte(3), p);
            }
            case DYNAMIC: {
                switch (this.getOpcode()) {
                    case TABLESWITCH: {
                        int pad = Instruction.align(this.pc + 1) - this.pc;
                        int default_2 = this.getInt(pad);
                        int low = this.getInt(pad + 4);
                        int high = this.getInt(pad + 8);
                        int[] values = new int[high - low + 1];
                        for (int i = 0; i < values.length; ++i) {
                            values[i] = this.getInt(pad + 12 + 4 * i);
                        }
                        return visitor.visitTableSwitch(this, default_2, low, high, values, p);
                    }
                    case LOOKUPSWITCH: {
                        int pad = Instruction.align(this.pc + 1) - this.pc;
                        int default_3 = this.getInt(pad);
                        int npairs = this.getInt(pad + 4);
                        int[] matches = new int[npairs];
                        int[] offsets = new int[npairs];
                        for (int i = 0; i < npairs; ++i) {
                            matches[i] = this.getInt(pad + 8 + i * 8);
                            offsets[i] = this.getInt(pad + 12 + i * 8);
                        }
                        return visitor.visitLookupSwitch(this, default_3, npairs, matches, offsets, p);
                    }
                }
                throw new IllegalStateException();
            }
            case LOCAL: {
                return visitor.visitLocal(this, this.getUnsignedByte(1), p);
            }
            case LOCAL_BYTE: {
                return visitor.visitLocalAndValue(this, this.getUnsignedByte(1), this.getByte(2), p);
            }
            case SHORT: {
                return visitor.visitValue(this, this.getShort(1), p);
            }
            case WIDE_NO_OPERANDS: {
                return visitor.visitNoOperands(this, p);
            }
            case WIDE_LOCAL: {
                return visitor.visitLocal(this, this.getUnsignedShort(2), p);
            }
            case WIDE_LOCAL_SHORT: {
                return visitor.visitLocalAndValue(this, this.getUnsignedShort(2), this.getUnsignedByte(4), p);
            }
            case UNKNOWN: {
                return visitor.visitUnknown(this, p);
            }
        }
        throw new IllegalStateException();
    }

    private static int align(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    public static enum TypeKind {
        T_BOOLEAN(4, "boolean"),
        T_CHAR(5, "char"),
        T_FLOAT(6, "float"),
        T_DOUBLE(7, "double"),
        T_BYTE(8, "byte"),
        T_SHORT(9, "short"),
        T_INT(10, "int"),
        T_LONG(11, "long");

        public final int value;
        public final String name;

        private TypeKind(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public static TypeKind get(int value) {
            switch (value) {
                case 4: {
                    return T_BOOLEAN;
                }
                case 5: {
                    return T_CHAR;
                }
                case 6: {
                    return T_FLOAT;
                }
                case 7: {
                    return T_DOUBLE;
                }
                case 8: {
                    return T_BYTE;
                }
                case 9: {
                    return T_SHORT;
                }
                case 10: {
                    return T_INT;
                }
                case 11: {
                    return T_LONG;
                }
            }
            return null;
        }
    }

    public static interface KindVisitor<R, P> {
        public R visitNoOperands(Instruction var1, P var2);

        public R visitArrayType(Instruction var1, TypeKind var2, P var3);

        public R visitBranch(Instruction var1, int var2, P var3);

        public R visitConstantPoolRef(Instruction var1, int var2, P var3);

        public R visitConstantPoolRefAndValue(Instruction var1, int var2, int var3, P var4);

        public R visitLocal(Instruction var1, int var2, P var3);

        public R visitLocalAndValue(Instruction var1, int var2, int var3, P var4);

        public R visitLookupSwitch(Instruction var1, int var2, int var3, int[] var4, int[] var5, P var6);

        public R visitTableSwitch(Instruction var1, int var2, int var3, int var4, int[] var5, P var6);

        public R visitValue(Instruction var1, int var2, P var3);

        public R visitUnknown(Instruction var1, P var2);
    }

    public static enum Kind {
        NO_OPERANDS(1),
        ATYPE(2),
        BRANCH(3),
        BRANCH_W(5),
        BYTE(2),
        CPREF(2),
        CPREF_W(3),
        CPREF_W_UBYTE(4),
        CPREF_W_UBYTE_ZERO(5),
        DYNAMIC(-1),
        LOCAL(2),
        LOCAL_BYTE(3),
        SHORT(3),
        WIDE_NO_OPERANDS(2),
        WIDE_LOCAL(4),
        WIDE_LOCAL_SHORT(6),
        UNKNOWN(1);

        public final int length;

        private Kind(int length) {
            this.length = length;
        }
    }
}

