/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.classfile;

import com.redhat.ceylon.langtools.classfile.Attribute;
import com.redhat.ceylon.langtools.classfile.ClassReader;
import com.redhat.ceylon.langtools.classfile.ConstantPool;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import java.io.IOException;

public class Module_attribute
extends Attribute {
    public static final int ACC_PUBLIC = 32;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_MANDATED = 32768;
    public final int requires_count;
    public final RequiresEntry[] requires;
    public final int exports_count;
    public final ExportsEntry[] exports;
    public final int uses_count;
    public final int[] uses_index;
    public final int provides_count;
    public final ProvidesEntry[] provides;

    Module_attribute(ClassReader cr, int name_index, int length) throws IOException {
        super(name_index, length);
        int i;
        this.requires_count = cr.readUnsignedShort();
        this.requires = new RequiresEntry[this.requires_count];
        for (i = 0; i < this.requires_count; ++i) {
            this.requires[i] = new RequiresEntry(cr);
        }
        this.exports_count = cr.readUnsignedShort();
        this.exports = new ExportsEntry[this.exports_count];
        for (i = 0; i < this.exports_count; ++i) {
            this.exports[i] = new ExportsEntry(cr);
        }
        this.uses_count = cr.readUnsignedShort();
        this.uses_index = new int[this.uses_count];
        for (i = 0; i < this.uses_count; ++i) {
            this.uses_index[i] = cr.readUnsignedShort();
        }
        this.provides_count = cr.readUnsignedShort();
        this.provides = new ProvidesEntry[this.provides_count];
        for (i = 0; i < this.provides_count; ++i) {
            this.provides[i] = new ProvidesEntry(cr);
        }
    }

    public Module_attribute(int name_index, RequiresEntry[] requires, ExportsEntry[] exports, int[] uses, ProvidesEntry[] provides) {
        super(name_index, 2);
        this.requires_count = requires.length;
        this.requires = requires;
        this.exports_count = exports.length;
        this.exports = exports;
        this.uses_count = uses.length;
        this.uses_index = uses;
        this.provides_count = provides.length;
        this.provides = provides;
    }

    public String getUses(int index, ConstantPool constant_pool) throws ConstantPoolException {
        int i = this.uses_index[index];
        return constant_pool.getClassInfo(i).getName();
    }

    @Override
    public <R, D> R accept(Attribute.Visitor<R, D> visitor, D data) {
        return visitor.visitModule(this, data);
    }

    public static class ProvidesEntry {
        public static final int length = 4;
        public final int provides_index;
        public final int with_index;

        ProvidesEntry(ClassReader cr) throws IOException {
            this.provides_index = cr.readUnsignedShort();
            this.with_index = cr.readUnsignedShort();
        }

        public ProvidesEntry(int provides, int with) {
            this.provides_index = provides;
            this.with_index = with;
        }
    }

    public static class ExportsEntry {
        public final int exports_index;
        public final int exports_to_count;
        public final int[] exports_to_index;

        ExportsEntry(ClassReader cr) throws IOException {
            this.exports_index = cr.readUnsignedShort();
            this.exports_to_count = cr.readUnsignedShort();
            this.exports_to_index = new int[this.exports_to_count];
            for (int i = 0; i < this.exports_to_count; ++i) {
                this.exports_to_index[i] = cr.readUnsignedShort();
            }
        }

        public ExportsEntry(int index, int[] to) {
            this.exports_index = index;
            this.exports_to_count = to.length;
            this.exports_to_index = to;
        }

        public int length() {
            return 4 + 2 * this.exports_to_index.length;
        }
    }

    public static class RequiresEntry {
        public static final int length = 4;
        public final int requires_index;
        public final int requires_flags;

        RequiresEntry(ClassReader cr) throws IOException {
            this.requires_index = cr.readUnsignedShort();
            this.requires_flags = cr.readUnsignedShort();
        }

        public RequiresEntry(int index, int flags) {
            this.requires_index = index;
            this.requires_flags = flags;
        }

        public String getRequires(int index, ConstantPool constant_pool) throws ConstantPoolException {
            return constant_pool.getUTF8Value(this.requires_index);
        }
    }
}

