/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.api;

import com.redhat.ceylon.javax.lang.model.element.Modifier;
import com.redhat.ceylon.javax.lang.model.element.NestingKind;
import com.redhat.ceylon.javax.tools.Diagnostic;
import com.redhat.ceylon.javax.tools.DiagnosticListener;
import com.redhat.ceylon.javax.tools.FileObject;
import com.redhat.ceylon.javax.tools.JavaFileManager;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.source.util.TaskEvent;
import com.redhat.ceylon.langtools.source.util.TaskListener;
import com.redhat.ceylon.langtools.tools.javac.util.ClientCodeException;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ClientCodeWrapper {
    Map<Class<?>, Boolean> trustedClasses = new HashMap();

    public static ClientCodeWrapper instance(Context context) {
        ClientCodeWrapper instance = context.get(ClientCodeWrapper.class);
        if (instance == null) {
            instance = new ClientCodeWrapper(context);
        }
        return instance;
    }

    protected ClientCodeWrapper(Context context) {
    }

    public JavaFileManager wrap(JavaFileManager fm) {
        if (this.isTrusted(fm)) {
            return fm;
        }
        return new WrappedJavaFileManager(fm);
    }

    public FileObject wrap(FileObject fo) {
        if (this.isTrusted(fo)) {
            return fo;
        }
        return new WrappedFileObject(fo);
    }

    FileObject unwrap(FileObject fo) {
        if (fo instanceof WrappedFileObject) {
            return ((WrappedFileObject)fo).clientFileObject;
        }
        return fo;
    }

    public JavaFileObject wrap(JavaFileObject fo) {
        if (this.isTrusted(fo)) {
            return fo;
        }
        return new WrappedJavaFileObject(fo);
    }

    public Iterable<JavaFileObject> wrapJavaFileObjects(Iterable<? extends JavaFileObject> list) {
        ArrayList<JavaFileObject> wrapped = new ArrayList<JavaFileObject>();
        for (JavaFileObject javaFileObject : list) {
            wrapped.add(this.wrap(javaFileObject));
        }
        return Collections.unmodifiableList(wrapped);
    }

    JavaFileObject unwrap(JavaFileObject fo) {
        if (fo instanceof WrappedJavaFileObject) {
            return (JavaFileObject)((WrappedJavaFileObject)fo).clientFileObject;
        }
        return fo;
    }

    <T> DiagnosticListener<T> wrap(DiagnosticListener<T> dl) {
        if (this.isTrusted(dl)) {
            return dl;
        }
        return new WrappedDiagnosticListener<T>(dl);
    }

    TaskListener wrap(TaskListener tl) {
        if (this.isTrusted(tl)) {
            return tl;
        }
        return new WrappedTaskListener(tl);
    }

    protected boolean isTrusted(Object o) {
        Class<?> c = o.getClass();
        Boolean trusted = this.trustedClasses.get(c);
        if (trusted == null) {
            trusted = c.getName().startsWith("com.redhat.ceylon.langtools.tools.javac.") || c.isAnnotationPresent(Trusted.class);
            this.trustedClasses.put(c, trusted);
        }
        return trusted;
    }

    protected class WrappedTaskListener
    implements TaskListener {
        protected TaskListener clientTaskListener;

        WrappedTaskListener(TaskListener clientTaskListener) {
            clientTaskListener.getClass();
            this.clientTaskListener = clientTaskListener;
        }

        @Override
        public void started(TaskEvent ev) {
            try {
                this.clientTaskListener.started(ev);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public void finished(TaskEvent ev) {
            try {
                this.clientTaskListener.finished(ev);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }
    }

    protected class WrappedDiagnosticListener<T>
    implements DiagnosticListener<T> {
        protected DiagnosticListener<T> clientDiagnosticListener;

        WrappedDiagnosticListener(DiagnosticListener<T> clientDiagnosticListener) {
            clientDiagnosticListener.getClass();
            this.clientDiagnosticListener = clientDiagnosticListener;
        }

        @Override
        public void report(Diagnostic<? extends T> diagnostic) {
            try {
                this.clientDiagnosticListener.report(diagnostic);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }
    }

    protected class WrappedJavaFileObject
    extends WrappedFileObject
    implements JavaFileObject {
        WrappedJavaFileObject(JavaFileObject clientJavaFileObject) {
            super(clientJavaFileObject);
        }

        @Override
        public JavaFileObject.Kind getKind() {
            try {
                return ((JavaFileObject)this.clientFileObject).getKind();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            try {
                return ((JavaFileObject)this.clientFileObject).isNameCompatible(simpleName, kind);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public NestingKind getNestingKind() {
            try {
                return ((JavaFileObject)this.clientFileObject).getNestingKind();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public Modifier getAccessLevel() {
            try {
                return ((JavaFileObject)this.clientFileObject).getAccessLevel();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }
    }

    protected class WrappedFileObject
    implements FileObject {
        protected FileObject clientFileObject;

        WrappedFileObject(FileObject clientFileObject) {
            clientFileObject.getClass();
            this.clientFileObject = clientFileObject;
        }

        @Override
        public URI toUri() {
            try {
                return this.clientFileObject.toUri();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public String getName() {
            try {
                return this.clientFileObject.getName();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public InputStream openInputStream() throws IOException {
            try {
                return this.clientFileObject.openInputStream();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            try {
                return this.clientFileObject.openOutputStream();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            try {
                return this.clientFileObject.openReader(ignoreEncodingErrors);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            try {
                return this.clientFileObject.getCharContent(ignoreEncodingErrors);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public Writer openWriter() throws IOException {
            try {
                return this.clientFileObject.openWriter();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public long getLastModified() {
            try {
                return this.clientFileObject.getLastModified();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public boolean delete() {
            try {
                return this.clientFileObject.delete();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }
    }

    protected class WrappedJavaFileManager
    implements JavaFileManager {
        protected JavaFileManager clientJavaFileManager;

        WrappedJavaFileManager(JavaFileManager clientJavaFileManager) {
            clientJavaFileManager.getClass();
            this.clientJavaFileManager = clientJavaFileManager;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            try {
                return this.clientJavaFileManager.getClassLoader(location);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            try {
                return ClientCodeWrapper.this.wrapJavaFileObjects(this.clientJavaFileManager.list(location, packageName, kinds, recurse));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            try {
                return this.clientJavaFileManager.inferBinaryName(location, ClientCodeWrapper.this.unwrap(file));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public boolean isSameFile(FileObject a, FileObject b) {
            try {
                return this.clientJavaFileManager.isSameFile(ClientCodeWrapper.this.unwrap(a), ClientCodeWrapper.this.unwrap(b));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public boolean handleOption(String current, Iterator<String> remaining) {
            try {
                return this.clientJavaFileManager.handleOption(current, remaining);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public boolean hasLocation(JavaFileManager.Location location) {
            try {
                return this.clientJavaFileManager.hasLocation(location);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
            try {
                return ClientCodeWrapper.this.wrap(this.clientJavaFileManager.getJavaFileForInput(location, className, kind));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            try {
                return ClientCodeWrapper.this.wrap(this.clientJavaFileManager.getJavaFileForOutput(location, className, kind, ClientCodeWrapper.this.unwrap(sibling)));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
            try {
                return ClientCodeWrapper.this.wrap(this.clientJavaFileManager.getFileForInput(location, packageName, relativeName));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
            try {
                return ClientCodeWrapper.this.wrap(this.clientJavaFileManager.getFileForOutput(location, packageName, relativeName, ClientCodeWrapper.this.unwrap(sibling)));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                this.clientJavaFileManager.flush();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.clientJavaFileManager.close();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public int isSupportedOption(String option) {
            try {
                return this.clientJavaFileManager.isSupportedOption(option);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Trusted {
    }
}

