/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.api;

import com.redhat.ceylon.javax.annotation.processing.ProcessingEnvironment;
import com.redhat.ceylon.javax.lang.model.element.AnnotationMirror;
import com.redhat.ceylon.javax.lang.model.element.AnnotationValue;
import com.redhat.ceylon.javax.lang.model.element.Element;
import com.redhat.ceylon.javax.lang.model.element.ExecutableElement;
import com.redhat.ceylon.javax.lang.model.element.TypeElement;
import com.redhat.ceylon.javax.lang.model.type.DeclaredType;
import com.redhat.ceylon.javax.lang.model.type.ErrorType;
import com.redhat.ceylon.javax.lang.model.type.TypeKind;
import com.redhat.ceylon.javax.lang.model.type.TypeMirror;
import com.redhat.ceylon.javax.tools.Diagnostic;
import com.redhat.ceylon.javax.tools.JavaCompiler;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.source.tree.CatchTree;
import com.redhat.ceylon.langtools.source.tree.CompilationUnitTree;
import com.redhat.ceylon.langtools.source.tree.Scope;
import com.redhat.ceylon.langtools.source.tree.Tree;
import com.redhat.ceylon.langtools.source.util.SourcePositions;
import com.redhat.ceylon.langtools.source.util.TreePath;
import com.redhat.ceylon.langtools.source.util.Trees;
import com.redhat.ceylon.langtools.tools.javac.api.JavacScope;
import com.redhat.ceylon.langtools.tools.javac.api.JavacTaskImpl;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.comp.Attr;
import com.redhat.ceylon.langtools.tools.javac.comp.AttrContext;
import com.redhat.ceylon.langtools.tools.javac.comp.Enter;
import com.redhat.ceylon.langtools.tools.javac.comp.Env;
import com.redhat.ceylon.langtools.tools.javac.comp.MemberEnter;
import com.redhat.ceylon.langtools.tools.javac.comp.Resolve;
import com.redhat.ceylon.langtools.tools.javac.model.JavacElements;
import com.redhat.ceylon.langtools.tools.javac.processing.JavacProcessingEnvironment;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.tree.TreeCopier;
import com.redhat.ceylon.langtools.tools.javac.tree.TreeInfo;
import com.redhat.ceylon.langtools.tools.javac.tree.TreeMaker;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.JCDiagnostic;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Pair;
import java.io.IOException;
import java.util.Map;

public class JavacTrees
extends Trees {
    private Resolve resolve;
    private Enter enter;
    private Log log;
    private MemberEnter memberEnter;
    private Attr attr;
    private TreeMaker treeMaker;
    private JavacElements elements;
    private JavacTaskImpl javacTaskImpl;

    public static JavacTrees instance(JavaCompiler.CompilationTask task) {
        if (!(task instanceof JavacTaskImpl)) {
            throw new IllegalArgumentException();
        }
        return JavacTrees.instance(((JavacTaskImpl)task).getContext());
    }

    public static JavacTrees instance(ProcessingEnvironment env) {
        if (!(env instanceof JavacProcessingEnvironment)) {
            throw new IllegalArgumentException();
        }
        return JavacTrees.instance(((JavacProcessingEnvironment)env).getContext());
    }

    public static JavacTrees instance(Context context) {
        JavacTrees instance = context.get(JavacTrees.class);
        if (instance == null) {
            instance = new JavacTrees(context);
        }
        return instance;
    }

    private JavacTrees(Context context) {
        context.put(JavacTrees.class, this);
        this.init(context);
    }

    public void updateContext(Context context) {
        this.init(context);
    }

    private void init(Context context) {
        this.attr = Attr.instance(context);
        this.enter = Enter.instance(context);
        this.elements = JavacElements.instance(context);
        this.log = Log.instance(context);
        this.resolve = Resolve.instance(context);
        this.treeMaker = TreeMaker.instance(context);
        this.memberEnter = MemberEnter.instance(context);
        this.javacTaskImpl = context.get(JavacTaskImpl.class);
    }

    @Override
    public SourcePositions getSourcePositions() {
        return new SourcePositions(){

            @Override
            public long getStartPosition(CompilationUnitTree file, Tree tree) {
                return TreeInfo.getStartPos((JCTree)tree);
            }

            @Override
            public long getEndPosition(CompilationUnitTree file, Tree tree) {
                Map<JCTree, Integer> endPositions = ((JCTree.JCCompilationUnit)file).endPositions;
                return TreeInfo.getEndPos((JCTree)tree, endPositions);
            }
        };
    }

    @Override
    public JCTree.JCClassDecl getTree(TypeElement element) {
        return (JCTree.JCClassDecl)this.getTree((Element)element);
    }

    @Override
    public JCTree.JCMethodDecl getTree(ExecutableElement method) {
        return (JCTree.JCMethodDecl)this.getTree((Element)method);
    }

    @Override
    public JCTree getTree(Element element) {
        Symbol symbol = (Symbol)element;
        Symbol.ClassSymbol enclosing = symbol.enclClass();
        Env<AttrContext> env = this.enter.getEnv(enclosing);
        if (env == null) {
            return null;
        }
        JCTree.JCClassDecl classNode = env.enclClass;
        if (classNode != null) {
            if (TreeInfo.symbolFor(classNode) == element) {
                return classNode;
            }
            for (JCTree node : classNode.getMembers()) {
                if (TreeInfo.symbolFor(node) != element) continue;
                return node;
            }
        }
        return null;
    }

    @Override
    public JCTree getTree(Element e, AnnotationMirror a) {
        return this.getTree(e, a, null);
    }

    @Override
    public JCTree getTree(Element e, AnnotationMirror a, AnnotationValue v) {
        Pair<JCTree, JCTree.JCCompilationUnit> treeTopLevel = this.elements.getTreeAndTopLevel(e, a, v);
        if (treeTopLevel == null) {
            return null;
        }
        return (JCTree)treeTopLevel.fst;
    }

    @Override
    public TreePath getPath(CompilationUnitTree unit, Tree node) {
        return TreePath.getPath(unit, node);
    }

    @Override
    public TreePath getPath(Element e) {
        return this.getPath(e, null, null);
    }

    @Override
    public TreePath getPath(Element e, AnnotationMirror a) {
        return this.getPath(e, a, null);
    }

    @Override
    public TreePath getPath(Element e, AnnotationMirror a, AnnotationValue v) {
        Pair<JCTree, JCTree.JCCompilationUnit> treeTopLevel = this.elements.getTreeAndTopLevel(e, a, v);
        if (treeTopLevel == null) {
            return null;
        }
        return TreePath.getPath((CompilationUnitTree)treeTopLevel.snd, (Tree)treeTopLevel.fst);
    }

    @Override
    public Element getElement(TreePath path) {
        JCTree tree = (JCTree)path.getLeaf();
        Symbol sym = TreeInfo.symbolFor(tree);
        if (sym == null && TreeInfo.isDeclaration(tree)) {
            for (TreePath p = path; p != null; p = p.getParentPath()) {
                JCTree t = (JCTree)p.getLeaf();
                if (t.getTag() != 3) continue;
                JCTree.JCClassDecl ct = (JCTree.JCClassDecl)t;
                if (ct.sym == null) continue;
                if ((ct.sym.flags_field & 0x10000000L) == 0L) break;
                this.attr.attribClass(ct.pos(), ct.sym);
                sym = TreeInfo.symbolFor(tree);
                break;
            }
        }
        return sym;
    }

    @Override
    public TypeMirror getTypeMirror(TreePath path) {
        Tree t = path.getLeaf();
        return ((JCTree)t).type;
    }

    @Override
    public JavacScope getScope(TreePath path) {
        return new JavacScope(this.getAttrContext(path));
    }

    @Override
    public String getDocComment(TreePath path) {
        CompilationUnitTree t = path.getCompilationUnit();
        if (t instanceof JCTree.JCCompilationUnit) {
            JCTree.JCCompilationUnit cu = (JCTree.JCCompilationUnit)t;
            if (cu.docComments != null) {
                return cu.docComments.get(path.getLeaf());
            }
        }
        return null;
    }

    @Override
    public boolean isAccessible(Scope scope, TypeElement type) {
        if (scope instanceof JavacScope && type instanceof Symbol.ClassSymbol) {
            Env<AttrContext> env = ((JavacScope)scope).env;
            return this.resolve.isAccessible(env, (Symbol.ClassSymbol)type, true);
        }
        return false;
    }

    @Override
    public boolean isAccessible(Scope scope, Element member, DeclaredType type) {
        if (scope instanceof JavacScope && member instanceof Symbol && type instanceof Type) {
            Env<AttrContext> env = ((JavacScope)scope).env;
            return this.resolve.isAccessible(env, (Type)((Object)type), (Symbol)member, true);
        }
        return false;
    }

    private Env<AttrContext> getAttrContext(TreePath path) {
        if (!(path.getLeaf() instanceof JCTree)) {
            throw new IllegalArgumentException();
        }
        if (this.javacTaskImpl != null) {
            try {
                this.javacTaskImpl.enter(null);
            }
            catch (IOException e) {
                throw new Error("unexpected error while entering symbols: " + e);
            }
        }
        JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)path.getCompilationUnit();
        Copier copier = new Copier(this.treeMaker.forToplevel(unit));
        Env<AttrContext> env = null;
        JCTree.JCMethodDecl method = null;
        JCTree.JCVariableDecl field = null;
        List<Tree> l = List.nil();
        for (TreePath p = path; p != null; p = p.getParentPath()) {
            l = l.prepend(p.getLeaf());
        }
        while (l.nonEmpty()) {
            Tree tree = (Tree)l.head;
            switch (tree.getKind()) {
                case COMPILATION_UNIT: {
                    env = this.enter.getTopLevelEnv((JCTree.JCCompilationUnit)tree);
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    env = this.enter.getClassEnv(((JCTree.JCClassDecl)tree).sym);
                    break;
                }
                case METHOD: {
                    method = (JCTree.JCMethodDecl)tree;
                    break;
                }
                case VARIABLE: {
                    field = (JCTree.JCVariableDecl)tree;
                    break;
                }
                case BLOCK: {
                    if (method != null) {
                        env = this.memberEnter.getMethodEnv(method, env);
                    }
                    JCTree body = copier.copy((JCTree)tree, (JCTree)path.getLeaf());
                    env = this.attribStatToTree(body, env, copier.leafCopy);
                    return env;
                }
                default: {
                    if (field == null || field.getInitializer() != tree) break;
                    env = this.memberEnter.getInitEnv(field, env);
                    JCTree.JCExpression expr = copier.copy((JCTree.JCExpression)tree, (JCTree)path.getLeaf());
                    env = this.attribExprToTree(expr, env, copier.leafCopy);
                    return env;
                }
            }
            l = l.tail;
        }
        return field != null ? this.memberEnter.getInitEnv(field, env) : env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Env<AttrContext> attribStatToTree(JCTree stat, Env<AttrContext> env, JCTree tree) {
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        try {
            Env<AttrContext> env2 = this.attr.attribStatToTree(stat, env, tree);
            return env2;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Env<AttrContext> attribExprToTree(JCTree.JCExpression expr, Env<AttrContext> env, JCTree tree) {
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        try {
            Env<AttrContext> env2 = this.attr.attribExprToTree(expr, env, tree);
            return env2;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    @Override
    public TypeMirror getOriginalType(ErrorType errorType) {
        if (errorType instanceof Type.ErrorType) {
            return ((Type.ErrorType)errorType).getOriginalType();
        }
        return Type.noType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Tree t, CompilationUnitTree root) {
        JavaFileObject oldSource = null;
        JavaFileObject newSource = null;
        JCDiagnostic.DiagnosticPosition pos = null;
        newSource = root.getSourceFile();
        if (newSource != null) {
            oldSource = this.log.useSource(newSource);
            pos = ((JCTree)t).pos();
        }
        try {
            switch (kind) {
                case ERROR: {
                    boolean prev = this.log.multipleErrors;
                    try {
                        this.log.error(pos, "proc.messager", msg.toString());
                        return;
                    }
                    finally {
                        this.log.multipleErrors = prev;
                    }
                }
                case WARNING: {
                    this.log.warning(pos, "proc.messager", msg.toString());
                    return;
                }
                case MANDATORY_WARNING: {
                    this.log.mandatoryWarning(pos, "proc.messager", msg.toString());
                    return;
                }
                default: {
                    this.log.note(pos, "proc.messager", msg.toString());
                    return;
                }
            }
        }
        finally {
            if (oldSource != null) {
                this.log.useSource(oldSource);
            }
        }
    }

    @Override
    public TypeMirror getLub(CatchTree tree) {
        JCTree.JCCatch ct = (JCTree.JCCatch)tree;
        JCTree.JCVariableDecl v = ct.param;
        if (v.type != null && v.type.getKind() == TypeKind.UNION) {
            Type.UnionClassType ut = (Type.UnionClassType)v.type;
            return ut.getLub();
        }
        return v.type;
    }

    static class Copier
    extends TreeCopier<JCTree> {
        JCTree leafCopy = null;

        Copier(TreeMaker M) {
            super(M);
        }

        @Override
        public <T extends JCTree> T copy(T t, JCTree leaf) {
            T t2 = super.copy(t, leaf);
            if (t == leaf) {
                this.leafCopy = t2;
            }
            return t2;
        }
    }
}

