/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.code;

import com.redhat.ceylon.langtools.tools.javac.api.Formattable;
import com.redhat.ceylon.langtools.tools.javac.api.Messages;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import java.util.EnumSet;
import java.util.Locale;

public class Kinds {
    public static final int NIL = 0;
    public static final int PCK = 1;
    public static final int TYP = 2;
    public static final int VAR = 4;
    public static final int VAL = 12;
    public static final int MTH = 16;
    public static final int ERR = 31;
    public static final int AllKinds = 31;
    public static final int ERRONEOUS = 64;
    public static final int AMBIGUOUS = 65;
    public static final int HIDDEN = 66;
    public static final int STATICERR = 67;
    public static final int ABSENT_VAR = 68;
    public static final int WRONG_MTHS = 69;
    public static final int WRONG_MTH = 70;
    public static final int ABSENT_MTH = 71;
    public static final int ABSENT_TYP = 72;

    private Kinds() {
    }

    public static KindName kindName(int kind) {
        switch (kind) {
            case 1: {
                return KindName.PACKAGE;
            }
            case 2: {
                return KindName.CLASS;
            }
            case 4: {
                return KindName.VAR;
            }
            case 12: {
                return KindName.VAL;
            }
            case 16: {
                return KindName.METHOD;
            }
        }
        throw new AssertionError((Object)("Unexpected kind: " + kind));
    }

    public static KindName kindName(Symbol sym) {
        switch (sym.getKind()) {
            case PACKAGE: {
                return KindName.PACKAGE;
            }
            case ENUM: {
                return KindName.ENUM;
            }
            case ANNOTATION_TYPE: 
            case CLASS: {
                return KindName.CLASS;
            }
            case INTERFACE: {
                return KindName.INTERFACE;
            }
            case TYPE_PARAMETER: {
                return KindName.TYPEVAR;
            }
            case ENUM_CONSTANT: 
            case FIELD: 
            case PARAMETER: 
            case LOCAL_VARIABLE: 
            case EXCEPTION_PARAMETER: 
            case RESOURCE_VARIABLE: {
                return KindName.VAR;
            }
            case CONSTRUCTOR: {
                return KindName.CONSTRUCTOR;
            }
            case METHOD: 
            case STATIC_INIT: 
            case INSTANCE_INIT: {
                return KindName.METHOD;
            }
        }
        if (sym.kind == 12) {
            return KindName.VAL;
        }
        throw new AssertionError((Object)("Unexpected kind: " + (Object)((Object)sym.getKind())));
    }

    public static EnumSet<KindName> kindNames(int kind) {
        EnumSet<KindName> kinds = EnumSet.noneOf(KindName.class);
        if ((kind & 0xC) != 0) {
            kinds.add((kind & 0xC) == 4 ? KindName.VAR : KindName.VAL);
        }
        if ((kind & 0x10) != 0) {
            kinds.add(KindName.METHOD);
        }
        if ((kind & 2) != 0) {
            kinds.add(KindName.CLASS);
        }
        if ((kind & 1) != 0) {
            kinds.add(KindName.PACKAGE);
        }
        return kinds;
    }

    public static KindName typeKindName(Type t) {
        if (t.tag == 14 || t.tag == 10 && (t.tsym.flags() & 0x1000000L) != 0L) {
            return KindName.BOUND;
        }
        if (t.tag == 13) {
            return KindName.PACKAGE;
        }
        if ((t.tsym.flags_field & 0x2000L) != 0L) {
            return KindName.ANNOTATION;
        }
        if ((t.tsym.flags_field & 0x200L) != 0L) {
            return KindName.INTERFACE;
        }
        return KindName.CLASS;
    }

    public static KindName absentKind(int kind) {
        switch (kind) {
            case 68: {
                return KindName.VAR;
            }
            case 69: 
            case 70: 
            case 71: {
                return KindName.METHOD;
            }
            case 72: {
                return KindName.CLASS;
            }
        }
        throw new AssertionError((Object)("Unexpected kind: " + kind));
    }

    public static enum KindName implements Formattable
    {
        ANNOTATION("kindname.annotation"),
        CONSTRUCTOR("kindname.constructor"),
        INTERFACE("kindname.interface"),
        ENUM("kindname.enum"),
        STATIC("kindname.static"),
        TYPEVAR("kindname.type.variable"),
        BOUND("kindname.type.variable.bound"),
        VAR("kindname.variable"),
        VAL("kindname.value"),
        METHOD("kindname.method"),
        CLASS("kindname.class"),
        PACKAGE("kindname.package");

        private String name;

        private KindName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getKind() {
            return "Kindname";
        }

        @Override
        public String toString(Locale locale, Messages messages) {
            String s = this.toString();
            return messages.getLocalizedString(locale, "compiler.misc." + s, new Object[0]);
        }
    }
}

