/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.comp;

import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.tools.javac.comp.AttrContext;
import com.redhat.ceylon.langtools.tools.javac.comp.Env;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import java.util.AbstractQueue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class Todo
extends AbstractQueue<Env<AttrContext>> {
    protected static final Context.Key<Todo> todoKey = new Context.Key();
    LinkedList<Env<AttrContext>> contents = new LinkedList();
    LinkedList<Queue<Env<AttrContext>>> contentsByFile;
    Map<JavaFileObject, FileQueue> fileMap;

    public static Todo instance(Context context) {
        Todo instance = context.get(todoKey);
        if (instance == null) {
            instance = new Todo(context);
        }
        return instance;
    }

    protected Todo(Context context) {
        context.put(todoKey, this);
    }

    public void append(Env<AttrContext> env) {
        this.add(env);
    }

    @Override
    public Iterator<Env<AttrContext>> iterator() {
        return this.contents.iterator();
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public boolean offer(Env<AttrContext> e) {
        if (this.contents.add(e)) {
            if (this.contentsByFile != null) {
                this.addByFile(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public Env<AttrContext> poll() {
        if (this.size() == 0) {
            return null;
        }
        Env<AttrContext> env = this.contents.remove(0);
        if (this.contentsByFile != null) {
            this.removeByFile(env);
        }
        return env;
    }

    @Override
    public Env<AttrContext> peek() {
        return this.size() == 0 ? null : this.contents.get(0);
    }

    public Queue<Queue<Env<AttrContext>>> groupByFile() {
        if (this.contentsByFile == null) {
            this.contentsByFile = new LinkedList();
            for (Env env : this.contents) {
                this.addByFile(env);
            }
        }
        return this.contentsByFile;
    }

    private void addByFile(Env<AttrContext> env) {
        FileQueue fq;
        JavaFileObject file = env.toplevel.sourcefile;
        if (this.fileMap == null) {
            this.fileMap = new HashMap<JavaFileObject, FileQueue>();
        }
        if ((fq = this.fileMap.get(file)) == null) {
            fq = new FileQueue();
            this.fileMap.put(file, fq);
            this.contentsByFile.add(fq);
        }
        fq.fileContents.add(env);
    }

    private void removeByFile(Env<AttrContext> env) {
        JavaFileObject file = env.toplevel.sourcefile;
        FileQueue fq = this.fileMap.get(file);
        if (fq == null) {
            return;
        }
        if (fq.fileContents.remove(env) && fq.isEmpty()) {
            this.fileMap.remove(file);
            this.contentsByFile.remove(fq);
        }
    }

    public void reset() {
        this.contents.clear();
        this.contentsByFile = null;
        this.fileMap = null;
    }

    class FileQueue
    extends AbstractQueue<Env<AttrContext>> {
        LinkedList<Env<AttrContext>> fileContents = new LinkedList();

        FileQueue() {
        }

        @Override
        public Iterator<Env<AttrContext>> iterator() {
            return this.fileContents.iterator();
        }

        @Override
        public int size() {
            return this.fileContents.size();
        }

        @Override
        public boolean offer(Env<AttrContext> e) {
            if (this.fileContents.offer(e)) {
                Todo.this.contents.add(e);
                return true;
            }
            return false;
        }

        @Override
        public Env<AttrContext> poll() {
            if (this.fileContents.size() == 0) {
                return null;
            }
            Env<AttrContext> env = this.fileContents.remove(0);
            Todo.this.contents.remove(env);
            return env;
        }

        @Override
        public Env<AttrContext> peek() {
            return this.fileContents.size() == 0 ? null : this.fileContents.get(0);
        }
    }
}

