/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.file;

import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.tools.javac.file.BaseFileObject;
import com.redhat.ceylon.langtools.tools.javac.file.JavacFileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;

public class RegularFileObject
extends BaseFileObject {
    private boolean hasParents = false;
    private String name;
    final File file;
    private Reference<File> absFileRef;

    public RegularFileObject(JavacFileManager fileManager, File f) {
        this(fileManager, f.getName(), f);
    }

    public RegularFileObject(JavacFileManager fileManager, String name, File f) {
        super(fileManager);
        if (f.isDirectory()) {
            throw new IllegalArgumentException("directories not supported");
        }
        this.name = name;
        this.file = f;
    }

    @Override
    public URI toUri() {
        return this.file.toURI().normalize();
    }

    @Override
    public String getName() {
        return this.file.getPath();
    }

    @Override
    public String getShortName() {
        return this.name;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return this.getKind(this.name);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.ensureParentDirectoriesExist();
        return new FileOutputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
        CharBuffer cb = this.fileManager.getCachedContent(this);
        if (cb == null) {
            try (FileInputStream in = new FileInputStream(this.file);){
                ByteBuffer bb = this.fileManager.makeByteBuffer(in);
                JavaFileObject prev = this.fileManager.log.useSource(this);
                try {
                    cb = this.fileManager.decode(bb, ignoreEncodingErrors);
                }
                finally {
                    this.fileManager.log.useSource(prev);
                }
                this.fileManager.recycleByteBuffer(bb);
                if (!ignoreEncodingErrors) {
                    this.fileManager.cache(this, cb);
                }
            }
        }
        return cb;
    }

    @Override
    public Writer openWriter() throws IOException {
        this.ensureParentDirectoriesExist();
        return new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), this.fileManager.getEncodingName());
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    protected CharsetDecoder getDecoder(boolean ignoreEncodingErrors) {
        return this.fileManager.getDecoder(this.fileManager.getEncodingName(), ignoreEncodingErrors);
    }

    @Override
    protected String inferBinaryName(Iterable<? extends File> path) {
        String fPath = this.file.getPath();
        for (File file : path) {
            String dPath = file.getPath();
            if (dPath.length() == 0) {
                dPath = System.getProperty("user.dir");
            }
            if (!dPath.endsWith(File.separator)) {
                dPath = dPath + File.separator;
            }
            if (!fPath.regionMatches(true, 0, dPath, 0, dPath.length()) || !new File(fPath.substring(0, dPath.length())).equals(new File(dPath))) continue;
            String relativeName = fPath.substring(dPath.length());
            return RegularFileObject.removeExtension(relativeName).replace(File.separatorChar, '.');
        }
        return null;
    }

    @Override
    public boolean isNameCompatible(String cn, JavaFileObject.Kind kind) {
        cn.getClass();
        if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
            return false;
        }
        String n = cn + kind.extension;
        if (this.name.equals(n)) {
            return true;
        }
        if (this.name.equalsIgnoreCase(n)) {
            try {
                return this.file.getCanonicalFile().getName().equals(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private void ensureParentDirectoriesExist() throws IOException {
        if (!this.hasParents) {
            File parent = this.file.getParentFile();
            if (!(parent == null || parent.exists() || parent.mkdirs() || parent.exists() && parent.isDirectory())) {
                throw new IOException("could not create parent directories");
            }
            this.hasParents = true;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RegularFileObject)) {
            return false;
        }
        RegularFileObject o = (RegularFileObject)other;
        return this.getAbsoluteFile().equals(o.getAbsoluteFile());
    }

    @Override
    public int hashCode() {
        return this.getAbsoluteFile().hashCode();
    }

    private File getAbsoluteFile() {
        File absFile;
        File file = absFile = this.absFileRef == null ? null : this.absFileRef.get();
        if (absFile == null) {
            try {
                absFile = this.file.getCanonicalFile();
            }
            catch (IOException e) {
                absFile = this.file.getAbsoluteFile();
            }
            this.absFileRef = new SoftReference<File>(absFile);
        }
        return absFile;
    }

    public File getUnderlyingFile() {
        return this.file;
    }
}

