/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.file;

import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.tools.javac.file.BaseFileObject;
import com.redhat.ceylon.langtools.tools.javac.file.JavacFileManager;
import com.redhat.ceylon.langtools.tools.javac.file.RelativePath;
import com.redhat.ceylon.langtools.tools.javac.file.ZipFileIndex;
import com.redhat.ceylon.langtools.tools.javac.util.Assert;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.Set;

public class ZipFileIndexArchive
implements JavacFileManager.Archive {
    private final ZipFileIndex zfIndex;
    private JavacFileManager fileManager;

    public ZipFileIndexArchive(JavacFileManager fileManager, ZipFileIndex zdir) throws IOException {
        this.fileManager = fileManager;
        this.zfIndex = zdir;
    }

    @Override
    public boolean contains(RelativePath name) {
        return this.zfIndex.contains(name);
    }

    @Override
    public List<String> getFiles(RelativePath.RelativeDirectory subdirectory) {
        return this.zfIndex.getFiles(subdirectory);
    }

    @Override
    public JavaFileObject getFileObject(RelativePath.RelativeDirectory subdirectory, String file) {
        RelativePath.RelativeFile fullZipFileName = new RelativePath.RelativeFile(subdirectory, file);
        ZipFileIndex.Entry entry = this.zfIndex.getZipIndexEntry(fullZipFileName);
        ZipFileIndexFileObject ret = new ZipFileIndexFileObject(this.fileManager, this.zfIndex, entry, this.zfIndex.getZipFile());
        return ret;
    }

    @Override
    public Set<RelativePath.RelativeDirectory> getSubdirectories() {
        return this.zfIndex.getAllDirectories();
    }

    @Override
    public void close() throws IOException {
        this.zfIndex.close();
    }

    public String toString() {
        return "ZipFileIndexArchive[" + this.zfIndex + "]";
    }

    public static class ZipFileIndexFileObject
    extends BaseFileObject {
        private String name;
        ZipFileIndex zfIndex;
        ZipFileIndex.Entry entry;
        InputStream inputStream = null;
        File zipName;

        ZipFileIndexFileObject(JavacFileManager fileManager, ZipFileIndex zfIndex, ZipFileIndex.Entry entry, File zipFileName) {
            super(fileManager);
            this.name = entry.getFileName();
            this.zfIndex = zfIndex;
            this.entry = entry;
            this.zipName = zipFileName;
        }

        @Override
        public URI toUri() {
            return ZipFileIndexFileObject.createJarUri(this.zipName, this.getPrefixedEntryName());
        }

        @Override
        public String getName() {
            return this.zipName + "(" + this.getPrefixedEntryName() + ")";
        }

        @Override
        public String getShortName() {
            return this.zipName.getName() + "(" + this.entry.getName() + ")";
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this.getKind(this.entry.getName());
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.inputStream == null) {
                Assert.checkNonNull(this.entry);
                this.inputStream = new ByteArrayInputStream(this.zfIndex.read(this.entry));
            }
            return this.inputStream;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
            CharBuffer cb = this.fileManager.getCachedContent(this);
            if (cb == null) {
                try (ByteArrayInputStream in = new ByteArrayInputStream(this.zfIndex.read(this.entry));){
                    ByteBuffer bb = this.fileManager.makeByteBuffer(in);
                    JavaFileObject prev = this.fileManager.log.useSource(this);
                    try {
                        cb = this.fileManager.decode(bb, ignoreEncodingErrors);
                    }
                    finally {
                        this.fileManager.log.useSource(prev);
                    }
                    this.fileManager.recycleByteBuffer(bb);
                    if (!ignoreEncodingErrors) {
                        this.fileManager.cache(this, cb);
                    }
                }
            }
            return cb;
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            return this.entry.getLastModified();
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected CharsetDecoder getDecoder(boolean ignoreEncodingErrors) {
            return this.fileManager.getDecoder(this.fileManager.getEncodingName(), ignoreEncodingErrors);
        }

        @Override
        protected String inferBinaryName(Iterable<? extends File> path) {
            String prefix;
            String entryName = this.entry.getName();
            if (this.zfIndex.symbolFilePrefix != null && entryName.startsWith(prefix = this.zfIndex.symbolFilePrefix.path)) {
                entryName = entryName.substring(prefix.length());
            }
            return ZipFileIndexFileObject.removeExtension(entryName).replace('/', '.');
        }

        @Override
        public boolean isNameCompatible(String cn, JavaFileObject.Kind k) {
            cn.getClass();
            if (k == JavaFileObject.Kind.OTHER && this.getKind() != k) {
                return false;
            }
            return this.name.equals(cn + k.extension);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ZipFileIndexFileObject)) {
                return false;
            }
            ZipFileIndexFileObject o = (ZipFileIndexFileObject)other;
            return this.zfIndex.getAbsoluteFile().equals(o.zfIndex.getAbsoluteFile()) && this.name.equals(o.name);
        }

        @Override
        public int hashCode() {
            return this.zfIndex.getAbsoluteFile().hashCode() + this.name.hashCode();
        }

        private String getPrefixedEntryName() {
            if (this.zfIndex.symbolFilePrefix != null) {
                return this.zfIndex.symbolFilePrefix.path + this.entry.getName();
            }
            return this.entry.getName();
        }
    }
}

