/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.jvm;

import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.util.Assert;
import com.redhat.ceylon.langtools.tools.javac.util.Filter;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Pool {
    public static final int MAX_ENTRIES = 65535;
    public static final int MAX_STRING_LENGTH = 65535;
    int pp;
    Object[] pool;
    Map<Object, Integer> indices;

    public Pool(int pp, Object[] pool) {
        this.pp = pp;
        this.pool = pool;
        this.indices = new HashMap<Object, Integer>(pool.length);
        for (int i = 1; i < pp; ++i) {
            if (pool[i] == null) continue;
            this.indices.put(pool[i], i);
        }
    }

    public Pool() {
        this(1, new Object[64]);
    }

    public int numEntries() {
        return this.pp;
    }

    public void reset() {
        this.pp = 1;
        this.indices.clear();
    }

    private void doublePool() {
        Object[] newpool = new Object[this.pool.length * 2];
        System.arraycopy(this.pool, 0, newpool, 0, this.pool.length);
        this.pool = newpool;
    }

    public int put(Object value) {
        Integer index = this.indices.get(value = this.makePoolValue(value));
        if (index == null) {
            index = this.pp;
            this.indices.put(value, index);
            if (this.pp == this.pool.length) {
                this.doublePool();
            }
            this.pool[this.pp++] = value;
            if (value instanceof Long || value instanceof Double) {
                if (this.pp == this.pool.length) {
                    this.doublePool();
                }
                this.pool[this.pp++] = null;
            }
        }
        return index;
    }

    Object makePoolValue(Object o) {
        if (o instanceof Symbol.DynamicMethodSymbol) {
            return new DynamicMethod((Symbol.DynamicMethodSymbol)o);
        }
        if (o instanceof Symbol.MethodSymbol) {
            return new Method((Symbol.MethodSymbol)o);
        }
        if (o instanceof Symbol.VarSymbol) {
            return new Variable((Symbol.VarSymbol)o);
        }
        return o;
    }

    public int get(Object o) {
        Integer n = this.indices.get(o);
        return n == null ? -1 : n;
    }

    public static class MethodHandle {
        int refKind;
        Symbol refSym;
        Type uniqueType;
        Filter<Name> nonInitFilter = new Filter<Name>(){

            @Override
            public boolean accepts(Name n) {
                return n != n.table.names.init && n != n.table.names.clinit;
            }
        };
        Filter<Name> initFilter = new Filter<Name>(){

            @Override
            public boolean accepts(Name n) {
                return n == n.table.names.init;
            }
        };

        public MethodHandle(int refKind, Symbol refSym) {
            this.refKind = refKind;
            this.refSym = refSym;
            this.uniqueType = this.refSym.type;
            this.checkConsistent();
        }

        public boolean equals(Object other) {
            if (!(other instanceof MethodHandle)) {
                return false;
            }
            MethodHandle mr = (MethodHandle)other;
            if (mr.refKind != this.refKind) {
                return false;
            }
            Symbol o = mr.refSym;
            return o.name == this.refSym.name && o.owner == this.refSym.owner && ((MethodHandle)other).uniqueType.equals(this.uniqueType);
        }

        public int hashCode() {
            return this.refKind * 65 + this.refSym.name.hashCode() * 33 + this.refSym.owner.hashCode() * 9 + this.uniqueType.hashCode();
        }

        private void checkConsistent() {
            boolean staticOk = false;
            int expectedKind = -1;
            Filter<Name> nameFilter = this.nonInitFilter;
            boolean interfaceOwner = false;
            switch (this.refKind) {
                case 2: 
                case 4: {
                    staticOk = true;
                }
                case 1: 
                case 3: {
                    expectedKind = 4;
                    break;
                }
                case 8: {
                    nameFilter = this.initFilter;
                    expectedKind = 16;
                    break;
                }
                case 9: {
                    interfaceOwner = true;
                    expectedKind = 16;
                    break;
                }
                case 6: {
                    interfaceOwner = true;
                    staticOk = true;
                }
                case 5: 
                case 7: {
                    expectedKind = 16;
                }
            }
            Assert.check(!this.refSym.isStatic() || staticOk);
            Assert.check(this.refSym.kind == expectedKind);
            Assert.check(nameFilter.accepts(this.refSym.name));
            Assert.check(!this.refSym.owner.isInterface() || interfaceOwner);
        }
    }

    static class Variable
    extends Symbol.DelegatedSymbol {
        Symbol.VarSymbol v;

        Variable(Symbol.VarSymbol v) {
            super(v);
            this.v = v;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Variable)) {
                return false;
            }
            Symbol.VarSymbol o = ((Variable)other).v;
            return o.name == this.v.name && o.owner == this.v.owner && o.type.equals(this.v.type);
        }

        @Override
        public int hashCode() {
            return this.v.name.hashCode() * 33 + this.v.owner.hashCode() * 9 + this.v.type.hashCode();
        }
    }

    static class DynamicMethod
    extends Method {
        public Object[] uniqueStaticArgs;

        DynamicMethod(Symbol.DynamicMethodSymbol m) {
            super(m);
            this.uniqueStaticArgs = m.staticArgs;
        }

        @Override
        public boolean equals(Object any) {
            if (!super.equals(any)) {
                return false;
            }
            if (!(any instanceof DynamicMethod)) {
                return false;
            }
            Symbol.DynamicMethodSymbol dm1 = (Symbol.DynamicMethodSymbol)this.other;
            Symbol.DynamicMethodSymbol dm2 = (Symbol.DynamicMethodSymbol)((DynamicMethod)any).other;
            return dm1.bsm == dm2.bsm && dm1.bsmKind == dm2.bsmKind && Arrays.equals(this.uniqueStaticArgs, ((DynamicMethod)any).uniqueStaticArgs);
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            Symbol.DynamicMethodSymbol dm = (Symbol.DynamicMethodSymbol)this.other;
            hash += dm.bsmKind * 7 + dm.bsm.hashCode() * 11;
            for (int i = 0; i < dm.staticArgs.length; ++i) {
                hash += this.uniqueStaticArgs[i].hashCode() * 23;
            }
            return hash;
        }
    }

    static class Method
    extends Symbol.DelegatedSymbol {
        Symbol.MethodSymbol m;

        Method(Symbol.MethodSymbol m) {
            super(m);
            this.m = m;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Method)) {
                return false;
            }
            Symbol.MethodSymbol o = ((Method)other).m;
            return o.name == this.m.name && o.owner == this.m.owner && o.type.equals(this.m.type);
        }

        @Override
        public int hashCode() {
            return this.m.name.hashCode() * 33 + this.m.owner.hashCode() * 9 + this.m.type.hashCode();
        }
    }
}

