/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.jvm;

import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.main.OptionName;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;

public enum Target {
    JDK1_1("1.1", 45, 3),
    JDK1_2("1.2", 46, 0),
    JDK1_3("1.3", 47, 0),
    JDK1_4("1.4", 48, 0),
    JSR14("jsr14", 48, 0),
    JDK1_4_1("1.4.1", 48, 0),
    JDK1_4_2("1.4.2", 48, 0),
    JDK1_5("1.5", 49, 0),
    JDK1_6("1.6", 50, 0),
    JDK1_7("1.7", 51, 0),
    JDK1_8("1.8", 52, 0);

    private static final Context.Key<Target> targetKey;
    private static Target MIN;
    private static Target MAX;
    private static Map<String, Target> tab;
    public final String name;
    public final int majorVersion;
    public final int minorVersion;
    public static final Target DEFAULT;

    public static Target instance(Context context) {
        Target instance = context.get(targetKey);
        if (instance == null) {
            Options options = Options.instance(context);
            String targetString = options.get(OptionName.TARGET);
            if (targetString != null) {
                instance = Target.lookup(targetString);
            }
            if (instance == null) {
                instance = DEFAULT;
            }
            context.put(targetKey, instance);
        }
        return instance;
    }

    public static Target MIN() {
        return MIN;
    }

    public static Target MAX() {
        return MAX;
    }

    private Target(String name, int majorVersion, int minorVersion) {
        this.name = name;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public static Target lookup(String name) {
        return tab.get(name);
    }

    public boolean requiresIproxy() {
        return this.compareTo(JDK1_1) <= 0;
    }

    public boolean initializeFieldsBeforeSuper() {
        return this.compareTo(JDK1_4) >= 0;
    }

    public boolean obeyBinaryCompatibility() {
        return this.compareTo(JDK1_2) >= 0;
    }

    public boolean arrayBinaryCompatibility() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean interfaceFieldsBinaryCompatibility() {
        return this.compareTo(JDK1_2) > 0;
    }

    public boolean interfaceObjectOverridesBinaryCompatibility() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean usePrivateSyntheticFields() {
        return this.compareTo(JDK1_4_2) < 0;
    }

    public boolean useInnerCacheClass() {
        return this.compareTo(JDK1_4_2) >= 0;
    }

    public boolean generateCLDCStackmap() {
        return false;
    }

    public boolean generateStackMapTable() {
        return this.compareTo(JDK1_6) >= 0;
    }

    public boolean isPackageInfoSynthetic() {
        return this.compareTo(JDK1_6) >= 0;
    }

    public boolean generateEmptyAfterBig() {
        return false;
    }

    public boolean useStringBuilder() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useSyntheticFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useEnumFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useAnnotationFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useVarargsFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useBridgeFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public char syntheticNameChar() {
        return '$';
    }

    public boolean hasClassLiterals() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean hasInvokedynamic() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean hasMethodHandles() {
        return this.hasInvokedynamic();
    }

    public boolean classLiteralsNoInit() {
        return this.compareTo(JDK1_4_2) >= 0;
    }

    public boolean hasInitCause() {
        return this.compareTo(JDK1_4) >= 0;
    }

    public boolean boxWithConstructors() {
        return this.compareTo(JDK1_5) < 0;
    }

    public boolean hasIterable() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean compilerBootstrap(Symbol c) {
        return this == JSR14 && (c.flags() & 0x4000L) != 0L && c.flatName().toString().startsWith("com.redhat.ceylon.langtools.tools.");
    }

    public boolean hasEnclosingMethodAttribute() {
        return this.compareTo(JDK1_5) >= 0 || this == JSR14;
    }

    public boolean allowStaticInterfaceCalls() {
        return this.compareTo(JDK1_8) >= 0;
    }

    static {
        targetKey = new Context.Key();
        tab = new HashMap<String, Target>();
        for (Target t : Target.values()) {
            if (MIN == null) {
                MIN = t;
            }
            MAX = t;
            tab.put(t.name, t);
        }
        tab.put("5", JDK1_5);
        tab.put("6", JDK1_6);
        tab.put("7", JDK1_7);
        tab.put("8", JDK1_8);
        DEFAULT = JDK1_7;
    }
}

