/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.main;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.javax.lang.model.SourceVersion;
import com.redhat.ceylon.langtools.tools.javac.code.Lint;
import com.redhat.ceylon.langtools.tools.javac.code.Source;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.jvm.Target;
import com.redhat.ceylon.langtools.tools.javac.main.JavacOption;
import com.redhat.ceylon.langtools.tools.javac.main.Main;
import com.redhat.ceylon.langtools.tools.javac.main.OptionName;
import com.redhat.ceylon.langtools.tools.javac.processing.JavacProcessingEnvironment;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class RecognizedOptions {
    static Set<OptionName> javacOptions = EnumSet.of(OptionName.G, new OptionName[]{OptionName.G_NONE, OptionName.G_CUSTOM, OptionName.XLINT, OptionName.XLINT_CUSTOM, OptionName.NOWARN, OptionName.VERBOSE, OptionName.VERBOSE_CUSTOM, OptionName.DEPRECATION, OptionName.CLASSPATH, OptionName.CP, OptionName.CEYLONCWD, OptionName.CEYLONREPO, OptionName.CEYLONSYSTEMREPO, OptionName.CEYLONCACHEREPO, OptionName.CEYLONNODEFREPOS, OptionName.CEYLONUSER, OptionName.CEYLONPASS, OptionName.CEYLONNOOSGI, OptionName.CEYLONOSGIPROVIDEDBUNDLES, OptionName.CEYLONJIGSAW, OptionName.CEYLONNOPOM, OptionName.CEYLONPACK200, OptionName.SOURCEPATH, OptionName.CEYLONSOURCEPATH, OptionName.CEYLONRESOURCEPATH, OptionName.CEYLONRESOURCEROOT, OptionName.BOOTCLASSPATH, OptionName.XBOOTCLASSPATH_PREPEND, OptionName.XBOOTCLASSPATH_APPEND, OptionName.XBOOTCLASSPATH, OptionName.EXTDIRS, OptionName.DJAVA_EXT_DIRS, OptionName.ENDORSEDDIRS, OptionName.DJAVA_ENDORSED_DIRS, OptionName.PROC, OptionName.PROCESSOR, OptionName.PROCESSORPATH, OptionName.D, OptionName.CEYLONOUT, OptionName.CEYLONOFFLINE, OptionName.CEYLONTIMEOUT, OptionName.CEYLONCONTINUE, OptionName.CEYLONPROGRESS, OptionName.CEYLONFLATCLASSPATH, OptionName.CEYLONAUTOEXPORTMAVENDEPENDENCIES, OptionName.CEYLONMAVENOVERRIDES, OptionName.CEYLONOVERRIDES, OptionName.CEYLONDOWNGRADEDIST, OptionName.S, OptionName.IMPLICIT, OptionName.ENCODING, OptionName.SOURCE, OptionName.TARGET, OptionName.VERSION, OptionName.FULLVERSION, OptionName.DIAGS, OptionName.HELP, OptionName.A, OptionName.X, OptionName.J, OptionName.MOREINFO, OptionName.WERROR, OptionName.PROMPT, OptionName.DOE, OptionName.PRINTSOURCE, OptionName.WARNUNCHECKED, OptionName.XMAXERRS, OptionName.XMAXWARNS, OptionName.XSTDOUT, OptionName.XPKGINFO, OptionName.XPRINT, OptionName.XPRINTROUNDS, OptionName.XPRINTPROCESSORINFO, OptionName.XPREFER, OptionName.O, OptionName.XJCOV, OptionName.XD, OptionName.AT, OptionName.SOURCEFILE, OptionName.SRC, OptionName.BOOTSTRAPCEYLON, OptionName.CEYLONDISABLEOPT, OptionName.CEYLONDISABLEOPT_CUSTOM, OptionName.CEYLONSUPPRESSWARNINGS});
    static Set<OptionName> javacFileManagerOptions = EnumSet.of(OptionName.CLASSPATH, new OptionName[]{OptionName.CP, OptionName.CEYLONCWD, OptionName.CEYLONREPO, OptionName.CEYLONSYSTEMREPO, OptionName.CEYLONCACHEREPO, OptionName.CEYLONNODEFREPOS, OptionName.CEYLONUSER, OptionName.CEYLONPASS, OptionName.CEYLONNOOSGI, OptionName.CEYLONOSGIPROVIDEDBUNDLES, OptionName.CEYLONJIGSAW, OptionName.CEYLONNOPOM, OptionName.CEYLONPACK200, OptionName.SOURCEPATH, OptionName.CEYLONSOURCEPATH, OptionName.CEYLONRESOURCEPATH, OptionName.CEYLONRESOURCEROOT, OptionName.BOOTCLASSPATH, OptionName.XBOOTCLASSPATH_PREPEND, OptionName.XBOOTCLASSPATH_APPEND, OptionName.XBOOTCLASSPATH, OptionName.EXTDIRS, OptionName.DJAVA_EXT_DIRS, OptionName.ENDORSEDDIRS, OptionName.DJAVA_ENDORSED_DIRS, OptionName.PROCESSORPATH, OptionName.D, OptionName.CEYLONOUT, OptionName.CEYLONOFFLINE, OptionName.CEYLONTIMEOUT, OptionName.CEYLONCONTINUE, OptionName.CEYLONPROGRESS, OptionName.CEYLONFLATCLASSPATH, OptionName.CEYLONAUTOEXPORTMAVENDEPENDENCIES, OptionName.CEYLONMAVENOVERRIDES, OptionName.CEYLONOVERRIDES, OptionName.CEYLONDOWNGRADEDIST, OptionName.S, OptionName.ENCODING, OptionName.SOURCE, OptionName.SRC});
    static Set<OptionName> javacToolOptions = EnumSet.of(OptionName.G, new OptionName[]{OptionName.G_NONE, OptionName.G_CUSTOM, OptionName.XLINT, OptionName.XLINT_CUSTOM, OptionName.NOWARN, OptionName.VERBOSE, OptionName.VERBOSE_CUSTOM, OptionName.DEPRECATION, OptionName.PROC, OptionName.PROCESSOR, OptionName.IMPLICIT, OptionName.SOURCE, OptionName.TARGET, OptionName.A, OptionName.MOREINFO, OptionName.WERROR, OptionName.PROMPT, OptionName.DOE, OptionName.PRINTSOURCE, OptionName.WARNUNCHECKED, OptionName.XMAXERRS, OptionName.XMAXWARNS, OptionName.XPKGINFO, OptionName.XPRINT, OptionName.XPRINTROUNDS, OptionName.XPRINTPROCESSORINFO, OptionName.XPREFER, OptionName.O, OptionName.XJCOV, OptionName.XD, OptionName.BOOTSTRAPCEYLON, OptionName.CEYLONDISABLEOPT, OptionName.CEYLONDISABLEOPT_CUSTOM, OptionName.CEYLONSUPPRESSWARNINGS});

    private RecognizedOptions() {
    }

    public static JavacOption.Option[] getJavaCompilerOptions(OptionHelper helper) {
        return RecognizedOptions.getOptions(helper, javacOptions);
    }

    public static JavacOption.Option[] getJavacFileManagerOptions(OptionHelper helper) {
        return RecognizedOptions.getOptions(helper, javacFileManagerOptions);
    }

    public static JavacOption.Option[] getJavacToolOptions(OptionHelper helper) {
        return RecognizedOptions.getOptions(helper, javacToolOptions);
    }

    static JavacOption.Option[] getOptions(OptionHelper helper, Set<OptionName> desired) {
        ListBuffer<JavacOption.Option> options = new ListBuffer<JavacOption.Option>();
        for (JavacOption.Option option : RecognizedOptions.getAll(helper)) {
            if (!desired.contains((Object)option.getName())) continue;
            options.append(option);
        }
        return options.toArray(new JavacOption.Option[options.length()]);
    }

    public static JavacOption.Option[] getAll(final OptionHelper helper) {
        return new JavacOption.Option[]{new JavacOption.Option(OptionName.G, "opt.g"), new JavacOption.Option(OptionName.G_NONE, "opt.g.none"){

            @Override
            public boolean process(Options options, String option) {
                options.put("-g:", "none");
                return false;
            }
        }, new JavacOption.Option(OptionName.G_CUSTOM, "opt.g.lines.vars.source", JavacOption.ChoiceKind.ANYOF, "lines", "vars", "source"), new JavacOption.XOption(OptionName.XLINT, "opt.Xlint"), new JavacOption.XOption(OptionName.XLINT_CUSTOM, "opt.Xlint.suboptlist", JavacOption.ChoiceKind.ANYOF, RecognizedOptions.getXLintChoices()), new JavacOption.Option(OptionName.NOWARN, "opt.nowarn"){

            @Override
            public boolean process(Options options, String option) {
                options.put("-Xlint:none", option);
                return false;
            }
        }, new JavacOption.Option(OptionName.VERBOSE, "opt.verbose"), new JavacOption.Option(OptionName.VERBOSE_CUSTOM, "opt.verbose.suboptlist"){

            @Override
            public boolean matches(String s) {
                return s.startsWith("-verbose:");
            }

            @Override
            public boolean process(Options options, String option) {
                String suboptions = option.substring(9);
                options.put("-verbose:", suboptions);
                StringTokenizer t = new StringTokenizer(suboptions, ",");
                while (t.hasMoreTokens()) {
                    String tok = t.nextToken();
                    if (tok.equals("all")) {
                        options.put(OptionName.VERBOSE, "true");
                    }
                    String opt = "-verbose:" + tok;
                    options.put(opt, opt);
                }
                return false;
            }
        }, new JavacOption.Option(OptionName.DEPRECATION, "opt.deprecation"){

            @Override
            public boolean process(Options options, String option) {
                options.put("-Xlint:deprecation", option);
                return false;
            }
        }, new JavacOption.Option(OptionName.CLASSPATH, "opt.arg.path", "opt.classpath"), new JavacOption.Option(OptionName.CP, "opt.arg.path", "opt.classpath"){

            @Override
            public boolean process(Options options, String option, String arg) {
                return super.process(options, "-classpath", arg);
            }
        }, new JavacOption.COption(OptionName.CEYLONCWD, "opt.arg.path", "opt.ceyloncwd"), new JavacOption.COption(OptionName.CEYLONREPO, "opt.arg.url", "opt.ceylonrepo"){

            @Override
            public boolean process(Options options, String option, String arg) {
                if (options != null) {
                    options.addMulti(OptionName.CEYLONREPO, arg);
                }
                return false;
            }
        }, new JavacOption.COption(OptionName.CEYLONSYSTEMREPO, "opt.arg.url", "opt.ceylonsystemrepo"), new JavacOption.COption(OptionName.CEYLONCACHEREPO, "opt.arg.url", "opt.ceyloncacherepo"), new JavacOption.COption(OptionName.CEYLONNODEFREPOS, "opt.ceylonnodefrepos"), new JavacOption.COption(OptionName.CEYLONUSER, "opt.arg.value", "opt.ceylonuser"), new JavacOption.COption(OptionName.CEYLONPASS, "opt.arg.value", "opt.ceylonpass"), new JavacOption.COption(OptionName.CEYLONNOOSGI, "opt.ceylonnoosgi"), new JavacOption.COption(OptionName.CEYLONOSGIPROVIDEDBUNDLES, "opt.arg.value", "opt.ceylonosgiprovidedbundles"), new JavacOption.COption(OptionName.CEYLONJIGSAW, "opt.ceylonjigsaw"), new JavacOption.COption(OptionName.CEYLONNOPOM, "opt.ceylonnopom"), new JavacOption.COption(OptionName.CEYLONPACK200, "opt.ceylonpack200"), new JavacOption.COption(OptionName.CEYLONRESOURCEROOT, "opt.arg.path", "opt.ceylonresourceroot"), new JavacOption.COption(OptionName.CEYLONDISABLEOPT, "opt.ceylondisableopt"), new JavacOption.COption(OptionName.CEYLONDISABLEOPT_CUSTOM, "opt.ceylondisableopt.suboptlist"), new JavacOption.COption(OptionName.CEYLONSUPPRESSWARNINGS, "opt.arg.value", "opt.ceylonsuppresswarnings"), new JavacOption.Option(OptionName.SOURCEPATH, "opt.arg.path", "opt.sourcepath"){

            @Override
            public boolean process(Options options, String option, String arg) {
                if (options != null) {
                    options.addMulti(OptionName.SOURCEPATH, arg);
                }
                return false;
            }
        }, new JavacOption.COption(OptionName.CEYLONSOURCEPATH, "opt.arg.directory", "opt.ceylonsourcepath"){

            @Override
            public boolean process(Options options, String option, String arg) {
                if (options != null) {
                    options.addMulti(OptionName.SOURCEPATH, arg);
                }
                return false;
            }
        }, new JavacOption.COption(OptionName.CEYLONRESOURCEPATH, "opt.arg.url", "opt.ceylonresourcepath"){

            @Override
            public boolean process(Options options, String option, String arg) {
                if (options != null) {
                    options.addMulti(OptionName.CEYLONRESOURCEPATH, arg);
                }
                return false;
            }
        }, new JavacOption.Option(OptionName.BOOTCLASSPATH, "opt.arg.path", "opt.bootclasspath"){

            @Override
            public boolean process(Options options, String option, String arg) {
                options.remove("-Xbootclasspath/p:");
                options.remove("-Xbootclasspath/a:");
                return super.process(options, option, arg);
            }
        }, new JavacOption.XOption(OptionName.XBOOTCLASSPATH_PREPEND, "opt.arg.path", "opt.Xbootclasspath.p"), new JavacOption.XOption(OptionName.XBOOTCLASSPATH_APPEND, "opt.arg.path", "opt.Xbootclasspath.a"), new JavacOption.XOption(OptionName.XBOOTCLASSPATH, "opt.arg.path", "opt.bootclasspath"){

            @Override
            public boolean process(Options options, String option, String arg) {
                options.remove("-Xbootclasspath/p:");
                options.remove("-Xbootclasspath/a:");
                return super.process(options, "-bootclasspath", arg);
            }
        }, new JavacOption.Option(OptionName.EXTDIRS, "opt.arg.dirs", "opt.extdirs"), new JavacOption.XOption(OptionName.DJAVA_EXT_DIRS, "opt.arg.dirs", "opt.extdirs"){

            @Override
            public boolean process(Options options, String option, String arg) {
                return super.process(options, "-extdirs", arg);
            }
        }, new JavacOption.Option(OptionName.ENDORSEDDIRS, "opt.arg.dirs", "opt.endorseddirs"), new JavacOption.XOption(OptionName.DJAVA_ENDORSED_DIRS, "opt.arg.dirs", "opt.endorseddirs"){

            @Override
            public boolean process(Options options, String option, String arg) {
                return super.process(options, "-endorseddirs", arg);
            }
        }, new JavacOption.Option(OptionName.PROC, "opt.proc.none.only", JavacOption.ChoiceKind.ONEOF, "none", "only"), new JavacOption.Option(OptionName.PROCESSOR, "opt.arg.class.list", "opt.processor"), new JavacOption.Option(OptionName.PROCESSORPATH, "opt.arg.path", "opt.processorpath"), new JavacOption.Option(OptionName.D, "opt.arg.directory", "opt.d"), new JavacOption.COption(OptionName.CEYLONOUT, "opt.arg.url", "opt.ceylonout"){

            @Override
            public boolean process(Options options, String option, String arg) {
                return super.process(options, "-d", arg);
            }
        }, new JavacOption.COption(OptionName.CEYLONOFFLINE, "opt.ceylonoffline"), new JavacOption.COption(OptionName.CEYLONTIMEOUT, "opt.arg.number", "opt.ceylontimeout"), new JavacOption.COption(OptionName.CEYLONCONTINUE, "opt.ceyloncontinue"), new JavacOption.COption(OptionName.CEYLONPROGRESS, "opt.ceylonprogress"), new JavacOption.COption(OptionName.CEYLONAUTOEXPORTMAVENDEPENDENCIES, "opt.ceylonautoexportmavendependencies"), new JavacOption.COption(OptionName.CEYLONFLATCLASSPATH, "opt.ceylonflatclasspath"), new JavacOption.COption(OptionName.CEYLONOVERRIDES, "opt.arg.url", "opt.ceylonoverrides"), new JavacOption.COption(OptionName.CEYLONMAVENOVERRIDES, "opt.arg.url", "opt.ceylonoverrides"){

            @Override
            public boolean process(Options options, String option, String arg) {
                return super.process(options, "-overrides", arg);
            }
        }, new JavacOption.COption(OptionName.CEYLONDOWNGRADEDIST, "opt.ceylondistpolicy", "opt.ceylondistpolicy"){

            @Override
            public boolean process(Options options, String option, String arg) {
                return super.process(options, "-dist-version-policy", arg);
            }
        }, new JavacOption.Option(OptionName.S, "opt.arg.directory", "opt.sourceDest"), new JavacOption.Option(OptionName.IMPLICIT, "opt.implicit", JavacOption.ChoiceKind.ONEOF, "none", "class"), new JavacOption.Option(OptionName.ENCODING, "opt.arg.encoding", "opt.encoding"){

            @Override
            public boolean process(Options options, String option, String operand) {
                try {
                    Charset.forName(operand);
                    options.put(option, operand);
                    return false;
                }
                catch (UnsupportedCharsetException e) {
                    helper.error("err.unsupported.encoding", operand);
                    return true;
                }
                catch (IllegalCharsetNameException e) {
                    helper.error("err.unsupported.encoding", operand);
                    return true;
                }
            }
        }, new JavacOption.Option(OptionName.SOURCE, "opt.arg.release", "opt.source"){

            @Override
            public boolean process(Options options, String option, String operand) {
                Source source = Source.lookup(operand);
                if (source == null) {
                    helper.error("err.invalid.source", operand);
                    return true;
                }
                return super.process(options, option, operand);
            }
        }, new JavacOption.Option(OptionName.TARGET, "opt.arg.release", "opt.target"){

            @Override
            public boolean process(Options options, String option, String operand) {
                Target target = Target.lookup(operand);
                if (target == null) {
                    helper.error("err.invalid.target", operand);
                    return true;
                }
                return super.process(options, option, operand);
            }
        }, new JavacOption.COption(OptionName.VERSION, "opt.version"){

            @Override
            public boolean process(Options options, String option) {
                helper.printVersion();
                return super.process(options, option);
            }
        }, new JavacOption.HiddenOption(OptionName.FULLVERSION){

            @Override
            public boolean process(Options options, String option) {
                helper.printFullVersion();
                return super.process(options, option);
            }
        }, new JavacOption.HiddenOption(OptionName.DIAGS){

            @Override
            public boolean process(Options options, String option) {
                JavacOption.Option xd = RecognizedOptions.getOptions(helper, EnumSet.of(OptionName.XD))[0];
                String diagsOption = (option = option.substring(option.indexOf(61) + 1)).contains("%") ? "-XDdiagsFormat=" : "-XDdiags=";
                if (xd.matches(diagsOption = diagsOption + option)) {
                    return xd.process(options, diagsOption);
                }
                return false;
            }
        }, new JavacOption.COption(OptionName.HELP, "opt.help"){

            @Override
            public boolean process(Options options, String option) {
                helper.printHelp();
                return super.process(options, option);
            }
        }, new JavacOption.Option(OptionName.A, "opt.arg.key.equals.value", "opt.A"){

            @Override
            String helpSynopsis() {
                this.hasSuffix = true;
                return super.helpSynopsis();
            }

            @Override
            public boolean matches(String arg) {
                return arg.startsWith("-A");
            }

            @Override
            public boolean hasArg() {
                return false;
            }

            @Override
            public boolean process(Options options, String option) {
                int argLength = option.length();
                if (argLength == 2) {
                    helper.error("err.empty.A.argument", new Object[0]);
                    return true;
                }
                int sepIndex = option.indexOf(61);
                String key = option.substring(2, sepIndex != -1 ? sepIndex : argLength);
                if (!JavacProcessingEnvironment.isValidOptionName(key)) {
                    helper.error("err.invalid.A.key", option);
                    return true;
                }
                return this.process(options, option, option);
            }
        }, new JavacOption.Option(OptionName.X, "opt.X"){

            @Override
            public boolean process(Options options, String option) {
                helper.printXhelp();
                return super.process(options, option);
            }
        }, new JavacOption.Option(OptionName.J, "opt.arg.flag", "opt.J"){

            @Override
            String helpSynopsis() {
                this.hasSuffix = true;
                return super.helpSynopsis();
            }

            @Override
            public boolean process(Options options, String option) {
                throw new AssertionError((Object)"the -J flag should be caught by the launcher.");
            }
        }, new JavacOption.HiddenOption(OptionName.MOREINFO){

            @Override
            public boolean process(Options options, String option) {
                Type.moreInfo = true;
                return super.process(options, option);
            }
        }, new JavacOption.Option(OptionName.WERROR, "opt.Werror"), new JavacOption.Option(OptionName.SRC, "opt.arg.src", "opt.src"){

            @Override
            public boolean process(Options options, String option, String arg) {
                return super.process(options, "-src", arg);
            }
        }, new JavacOption.HiddenOption(OptionName.COMPLEXINFERENCE), new JavacOption.HiddenOption(OptionName.PROMPT), new JavacOption.HiddenOption(OptionName.DOE), new JavacOption.HiddenOption(OptionName.PRINTSOURCE), new JavacOption.HiddenOption(OptionName.BOOTSTRAPCEYLON), new JavacOption.HiddenOption(OptionName.WARNUNCHECKED){

            @Override
            public boolean process(Options options, String option) {
                options.put("-Xlint:unchecked", option);
                return false;
            }
        }, new JavacOption.XOption(OptionName.XMAXERRS, "opt.arg.number", "opt.maxerrs"), new JavacOption.XOption(OptionName.XMAXWARNS, "opt.arg.number", "opt.maxwarns"), new JavacOption.XOption(OptionName.XSTDOUT, "opt.arg.file", "opt.Xstdout"){

            @Override
            public boolean process(Options options, String option, String arg) {
                try {
                    helper.setOut(new PrintWriter((Writer)new FileWriter(arg), true));
                }
                catch (IOException e) {
                    helper.error("err.error.writing.file", arg, e);
                    return true;
                }
                return super.process(options, option, arg);
            }
        }, new JavacOption.XOption(OptionName.XPRINT, "opt.print"), new JavacOption.XOption(OptionName.XPRINTROUNDS, "opt.printRounds"), new JavacOption.XOption(OptionName.XPRINTPROCESSORINFO, "opt.printProcessorInfo"), new JavacOption.XOption(OptionName.XPREFER, "opt.prefer", JavacOption.ChoiceKind.ONEOF, "source", "newer"), new JavacOption.XOption(OptionName.XPKGINFO, "opt.pkginfo", JavacOption.ChoiceKind.ONEOF, "always", "legacy", "nonempty"), new JavacOption.HiddenOption(OptionName.O), new JavacOption.HiddenOption(OptionName.XJCOV), new JavacOption.HiddenOption(OptionName.XD){
            String s;

            @Override
            public boolean matches(String s) {
                this.s = s;
                return s.startsWith(this.name.optionName);
            }

            @Override
            public boolean process(Options options, String option) {
                this.s = this.s.substring(this.name.optionName.length());
                int eq = this.s.indexOf(61);
                String key = eq < 0 ? this.s : this.s.substring(0, eq);
                String value = eq < 0 ? this.s : this.s.substring(eq + 1);
                options.put(key, value);
                return false;
            }
        }, new JavacOption.Option(OptionName.AT, "opt.arg.file", "opt.AT"){

            @Override
            String helpSynopsis() {
                this.hasSuffix = true;
                return super.helpSynopsis();
            }

            @Override
            public boolean process(Options options, String option) {
                throw new AssertionError((Object)"the @ flag should be caught by CommandLine.");
            }
        }, new JavacOption.HiddenOption(OptionName.SOURCEFILE){
            String s;

            @Override
            public boolean matches(String s) {
                this.s = s;
                return s.endsWith(".java") || s.endsWith(".ceylon") || "default".equals(s) || RecognizedOptions.isCeylonName(s) || new File(s).isFile();
            }

            @Override
            public boolean process(Options options, String option) {
                List<String> sourcePaths;
                File f = new File(this.s);
                if (this.s.endsWith(".java") || this.s.endsWith(".ceylon")) {
                    if (!f.isFile()) {
                        sourcePaths = options.getMulti("-sourcepath");
                        if (sourcePaths.isEmpty()) {
                            sourcePaths = FileUtil.filesToPathList(DefaultToolOptions.getCompilerSourceDirs());
                        }
                        if (this.checkIfModule(sourcePaths, this.s)) {
                            helper.addClassName(this.s);
                            return false;
                        }
                        if (f.exists()) {
                            helper.error("err.file.not.file", f);
                            return true;
                        }
                    }
                    if (!f.exists()) {
                        helper.error("err.file.not.found", f);
                        return true;
                    }
                    helper.addFile(f);
                }
                if (!f.isFile()) {
                    if (this.s.equals("default")) {
                        helper.addClassName(this.s);
                        return false;
                    }
                    sourcePaths = options.getMulti("-sourcepath");
                    if (sourcePaths.isEmpty()) {
                        sourcePaths = FileUtil.filesToPathList(DefaultToolOptions.getCompilerSourceDirs());
                    }
                    if (this.checkIfModule(sourcePaths, this.s)) {
                        helper.addClassName(this.s);
                        return false;
                    }
                    String paths = sourcePaths.toString();
                    helper.error("err.module.not.found", this.s, paths.substring(1, paths.length() - 1));
                    return true;
                }
                helper.addFile(f);
                return false;
            }

            private boolean checkIfModule(List<String> paths, String moduleName) {
                String moduleDirName = moduleName.replace(".", File.separator);
                for (String path : paths) {
                    for (String part : path.split("\\" + File.pathSeparator)) {
                        File moduleFolder = new File(part, moduleDirName);
                        if (!moduleFolder.isDirectory()) continue;
                        return true;
                    }
                }
                return false;
            }
        }};
    }

    public static boolean isCeylonName(CharSequence name) {
        String id = name.toString();
        for (String s : id.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    private static Map<String, Boolean> getXLintChoices() {
        LinkedHashMap<String, Boolean> choices = new LinkedHashMap<String, Boolean>();
        choices.put("all", false);
        for (Lint.LintCategory c : Lint.LintCategory.values()) {
            choices.put(c.option, c.hidden);
        }
        for (Lint.LintCategory c : Lint.LintCategory.values()) {
            choices.put("-" + c.option, c.hidden);
        }
        choices.put("none", false);
        return choices;
    }

    public static enum PkgInfo {
        ALWAYS,
        LEGACY,
        NONEMPTY;


        public static PkgInfo get(Options options) {
            String v = options.get(OptionName.XPKGINFO);
            return v == null ? LEGACY : PkgInfo.valueOf(v.toUpperCase());
        }
    }

    public static class GrumpyHelper
    implements OptionHelper {
        @Override
        public void setOut(PrintWriter out) {
            throw new IllegalArgumentException();
        }

        @Override
        public void error(String key, Object ... args) {
            throw new IllegalArgumentException(Main.getLocalizedString(key, args));
        }

        @Override
        public void printVersion() {
            throw new IllegalArgumentException();
        }

        @Override
        public void printFullVersion() {
            throw new IllegalArgumentException();
        }

        @Override
        public void printHelp() {
            throw new IllegalArgumentException();
        }

        @Override
        public void printXhelp() {
            throw new IllegalArgumentException();
        }

        @Override
        public void addFile(File f) {
            throw new IllegalArgumentException(f.getPath());
        }

        @Override
        public void addClassName(String s) {
            throw new IllegalArgumentException(s);
        }
    }

    public static interface OptionHelper {
        public void setOut(PrintWriter var1);

        public void error(String var1, Object ... var2);

        public void printVersion();

        public void printFullVersion();

        public void printHelp();

        public void printXhelp();

        public void addFile(File var1);

        public void addClassName(String var1);
    }
}

