/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.model;

import com.redhat.ceylon.javax.lang.model.type.MirroredTypeException;
import com.redhat.ceylon.javax.lang.model.type.MirroredTypesException;
import com.redhat.ceylon.javax.lang.model.type.TypeMirror;
import com.redhat.ceylon.langtools.tools.javac.code.Attribute;
import com.redhat.ceylon.langtools.tools.javac.code.Scope;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.langtools.tools.javac.util.Pair;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.EnumConstantNotPresentExceptionProxy;
import sun.reflect.annotation.ExceptionProxy;

public class AnnotationProxyMaker {
    private final Attribute.Compound anno;
    private final Class<? extends Annotation> annoType;

    private AnnotationProxyMaker(Attribute.Compound anno, Class<? extends Annotation> annoType) {
        this.anno = anno;
        this.annoType = annoType;
    }

    public static <A extends Annotation> A generateAnnotation(Attribute.Compound anno, Class<A> annoType) {
        AnnotationProxyMaker apm = new AnnotationProxyMaker(anno, annoType);
        return (A)((Annotation)annoType.cast(apm.generateAnnotation()));
    }

    private Annotation generateAnnotation() {
        return AnnotationParser.annotationForMap(this.annoType, this.getAllReflectedValues());
    }

    private Map<String, Object> getAllReflectedValues() {
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        for (Map.Entry<Symbol.MethodSymbol, Attribute> entry : this.getAllValues().entrySet()) {
            Symbol.MethodSymbol meth = entry.getKey();
            Object value = this.generateValue(meth, entry.getValue());
            if (value == null) continue;
            res.put(meth.name.toString(), value);
        }
        return res;
    }

    private Map<Symbol.MethodSymbol, Attribute> getAllValues() {
        LinkedHashMap<Symbol.MethodSymbol, Attribute> res = new LinkedHashMap<Symbol.MethodSymbol, Attribute>();
        Symbol.ClassSymbol sym = (Symbol.ClassSymbol)this.anno.type.tsym;
        Scope.Entry e = sym.members().elems;
        while (e != null) {
            Symbol.MethodSymbol m;
            Attribute def;
            if (e.sym.kind == 16 && (def = (m = (Symbol.MethodSymbol)e.sym).getDefaultValue()) != null) {
                res.put(m, def);
            }
            e = e.sibling;
        }
        for (Pair<Symbol.MethodSymbol, Attribute> p : this.anno.values) {
            res.put((Symbol.MethodSymbol)p.fst, (Attribute)p.snd);
        }
        return res;
    }

    private Object generateValue(Symbol.MethodSymbol meth, Attribute attr) {
        ValueVisitor vv = new ValueVisitor(meth);
        return vv.getValue(attr);
    }

    private static final class MirroredTypesExceptionProxy
    extends ExceptionProxy {
        static final long serialVersionUID = 269L;
        private transient List<TypeMirror> types;
        private final String typeStrings;

        MirroredTypesExceptionProxy(List<TypeMirror> ts) {
            this.types = ts;
            this.typeStrings = ts.toString();
        }

        public String toString() {
            return this.typeStrings;
        }

        public int hashCode() {
            return (this.types != null ? this.types : this.typeStrings).hashCode();
        }

        public boolean equals(Object obj) {
            return this.types != null && obj instanceof MirroredTypesExceptionProxy && this.types.equals(((MirroredTypesExceptionProxy)obj).types);
        }

        @Override
        protected RuntimeException generateException() {
            return new MirroredTypesException(this.types);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.types = null;
        }
    }

    private static final class MirroredTypeExceptionProxy
    extends ExceptionProxy {
        static final long serialVersionUID = 269L;
        private transient TypeMirror type;
        private final String typeString;

        MirroredTypeExceptionProxy(TypeMirror t) {
            this.type = t;
            this.typeString = t.toString();
        }

        public String toString() {
            return this.typeString;
        }

        public int hashCode() {
            return (this.type != null ? this.type : this.typeString).hashCode();
        }

        public boolean equals(Object obj) {
            return this.type != null && obj instanceof MirroredTypeExceptionProxy && this.type.equals(((MirroredTypeExceptionProxy)obj).type);
        }

        @Override
        protected RuntimeException generateException() {
            return new MirroredTypeException(this.type);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.type = null;
        }
    }

    private class ValueVisitor
    implements Attribute.Visitor {
        private Symbol.MethodSymbol meth;
        private Class<?> returnClass;
        private Object value;

        ValueVisitor(Symbol.MethodSymbol meth) {
            this.meth = meth;
        }

        Object getValue(Attribute attr) {
            Method method;
            try {
                method = AnnotationProxyMaker.this.annoType.getMethod(this.meth.name.toString(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            this.returnClass = method.getReturnType();
            attr.accept(this);
            if (!(this.value instanceof ExceptionProxy) && !AnnotationType.invocationHandlerReturnType(this.returnClass).isInstance(this.value)) {
                this.typeMismatch(method, attr);
            }
            return this.value;
        }

        @Override
        public void visitConstant(Attribute.Constant c) {
            this.value = c.getValue();
        }

        @Override
        public void visitClass(Attribute.Class c) {
            this.value = new MirroredTypeExceptionProxy(c.type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitArray(Attribute.Array a) {
            Name elemName = ((Type.ArrayType)a.type).elemtype.tsym.getQualifiedName();
            if (elemName.equals(elemName.table.names.java_lang_Class)) {
                ListBuffer<Type> elems = new ListBuffer<Type>();
                for (Attribute value : a.values) {
                    Type elem = ((Attribute.Class)value).type;
                    elems.append(elem);
                }
                this.value = new MirroredTypesExceptionProxy(elems.toList());
            } else {
                int len = a.values.length;
                Class<?> returnClassSaved = this.returnClass;
                this.returnClass = this.returnClass.getComponentType();
                try {
                    Object res = Array.newInstance(this.returnClass, len);
                    for (int i = 0; i < len; ++i) {
                        a.values[i].accept(this);
                        if (this.value == null || this.value instanceof ExceptionProxy) {
                            return;
                        }
                        try {
                            Array.set(res, i, this.value);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            this.value = null;
                            this.returnClass = returnClassSaved;
                            return;
                        }
                    }
                    this.value = res;
                }
                finally {
                    this.returnClass = returnClassSaved;
                }
            }
        }

        @Override
        public void visitEnum(Attribute.Enum e) {
            if (this.returnClass.isEnum()) {
                String constName = e.value.toString();
                try {
                    this.value = Enum.valueOf(this.returnClass, constName);
                }
                catch (IllegalArgumentException ex) {
                    this.value = new EnumConstantNotPresentExceptionProxy(this.returnClass, constName);
                }
            } else {
                this.value = null;
            }
        }

        @Override
        public void visitCompound(Attribute.Compound c) {
            try {
                Class<Annotation> nested = this.returnClass.asSubclass(Annotation.class);
                this.value = AnnotationProxyMaker.generateAnnotation(c, nested);
            }
            catch (ClassCastException ex) {
                this.value = null;
            }
        }

        @Override
        public void visitError(Attribute.Error e) {
            this.value = null;
        }

        private void typeMismatch(Method method, final Attribute attr) {
            class AnnotationTypeMismatchExceptionProxy
            extends ExceptionProxy {
                static final long serialVersionUID = 269L;
                final transient Method method;

                AnnotationTypeMismatchExceptionProxy(Method method) {
                    this.method = method;
                }

                public String toString() {
                    return "<error>";
                }

                @Override
                protected RuntimeException generateException() {
                    return new AnnotationTypeMismatchException(this.method, attr.type.toString());
                }
            }
            this.value = new AnnotationTypeMismatchExceptionProxy(method);
        }
    }
}

