/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.parser;

import com.redhat.ceylon.langtools.tools.javac.code.Source;
import com.redhat.ceylon.langtools.tools.javac.parser.EndPosParser;
import com.redhat.ceylon.langtools.tools.javac.parser.JavacParser;
import com.redhat.ceylon.langtools.tools.javac.parser.Keywords;
import com.redhat.ceylon.langtools.tools.javac.parser.Parser;
import com.redhat.ceylon.langtools.tools.javac.parser.Scanner;
import com.redhat.ceylon.langtools.tools.javac.parser.ScannerFactory;
import com.redhat.ceylon.langtools.tools.javac.tree.TreeMaker;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Names;
import com.redhat.ceylon.langtools.tools.javac.util.Options;

public class ParserFactory {
    protected static final Context.Key<ParserFactory> parserFactoryKey = new Context.Key();
    final TreeMaker F;
    final Log log;
    final Keywords keywords;
    final Source source;
    final Names names;
    final Options options;
    final ScannerFactory scannerFactory;

    public static ParserFactory instance(Context context) {
        ParserFactory instance = context.get(parserFactoryKey);
        if (instance == null) {
            instance = new ParserFactory(context);
        }
        return instance;
    }

    protected ParserFactory(Context context) {
        context.put(parserFactoryKey, this);
        this.F = TreeMaker.instance(context);
        this.log = Log.instance(context);
        this.names = Names.instance(context);
        this.keywords = Keywords.instance(context);
        this.source = Source.instance(context);
        this.options = Options.instance(context);
        this.scannerFactory = ScannerFactory.instance(context);
    }

    public Parser newParser(CharSequence input, boolean keepDocComments, boolean keepEndPos, boolean keepLineMap) {
        Scanner lexer = this.scannerFactory.newScanner(input, keepDocComments);
        if (keepEndPos) {
            return new EndPosParser(this, lexer, keepDocComments, keepLineMap);
        }
        return new JavacParser(this, lexer, keepDocComments, keepLineMap);
    }
}

