/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.processing;

import com.redhat.ceylon.javax.annotation.processing.Filer;
import com.redhat.ceylon.javax.annotation.processing.FilerException;
import com.redhat.ceylon.javax.lang.model.SourceVersion;
import com.redhat.ceylon.javax.lang.model.element.Element;
import com.redhat.ceylon.javax.lang.model.element.Modifier;
import com.redhat.ceylon.javax.lang.model.element.NestingKind;
import com.redhat.ceylon.javax.tools.FileObject;
import com.redhat.ceylon.javax.tools.ForwardingFileObject;
import com.redhat.ceylon.javax.tools.JavaFileManager;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.javax.tools.StandardLocation;
import com.redhat.ceylon.langtools.tools.javac.code.Lint;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class JavacFiler
implements Filer,
Closeable {
    private static final String ALREADY_OPENED = "Output stream or writer has already been opened.";
    private static final String NOT_FOR_READING = "FileObject was not opened for reading.";
    private static final String NOT_FOR_WRITING = "FileObject was not opened for writing.";
    JavaFileManager fileManager;
    Log log;
    Context context;
    boolean lastRound;
    private final boolean lint;
    private final Set<FileObject> fileObjectHistory;
    private final Set<String> openTypeNames;
    private Set<String> generatedSourceNames;
    private final Map<String, JavaFileObject> generatedClasses;
    private Set<JavaFileObject> generatedSourceFileObjects;
    private final Set<String> aggregateGeneratedSourceNames;
    private final Set<String> aggregateGeneratedClassNames;

    JavacFiler(Context context) {
        this.context = context;
        this.fileManager = context.get(JavaFileManager.class);
        this.log = Log.instance(context);
        this.fileObjectHistory = Collections.synchronizedSet(new LinkedHashSet());
        this.generatedSourceNames = Collections.synchronizedSet(new LinkedHashSet());
        this.generatedSourceFileObjects = Collections.synchronizedSet(new LinkedHashSet());
        this.generatedClasses = Collections.synchronizedMap(new LinkedHashMap());
        this.openTypeNames = Collections.synchronizedSet(new LinkedHashSet());
        this.aggregateGeneratedSourceNames = new LinkedHashSet<String>();
        this.aggregateGeneratedClassNames = new LinkedHashSet<String>();
        this.lint = Lint.instance(context).isEnabled(Lint.LintCategory.PROCESSING);
    }

    @Override
    public JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
        return this.createSourceOrClassFile(true, name.toString());
    }

    @Override
    public JavaFileObject createClassFile(CharSequence name, Element ... originatingElements) throws IOException {
        return this.createSourceOrClassFile(false, name.toString());
    }

    private JavaFileObject createSourceOrClassFile(boolean isSourceFile, String name) throws IOException {
        int periodIndex;
        if (this.lint && (periodIndex = name.lastIndexOf(".")) != -1) {
            String extn;
            String base = name.substring(periodIndex);
            String string = extn = isSourceFile ? ".java" : ".class";
            if (base.equals(extn)) {
                this.log.warning("proc.suspicious.class.name", name, extn);
            }
        }
        this.checkNameAndExistence(name, isSourceFile);
        StandardLocation loc = isSourceFile ? StandardLocation.SOURCE_OUTPUT : StandardLocation.CLASS_OUTPUT;
        JavaFileObject.Kind kind = isSourceFile ? JavaFileObject.Kind.SOURCE : JavaFileObject.Kind.CLASS;
        JavaFileObject fileObject = this.fileManager.getJavaFileForOutput(loc, name, kind, null);
        this.checkFileReopening(fileObject, true);
        if (this.lastRound) {
            this.log.warning("proc.file.create.last.round", name);
        }
        if (isSourceFile) {
            this.aggregateGeneratedSourceNames.add(name);
        } else {
            this.aggregateGeneratedClassNames.add(name);
        }
        this.openTypeNames.add(name);
        return new FilerOutputJavaFileObject(name, fileObject);
    }

    @Override
    public FileObject createResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element ... originatingElements) throws IOException {
        this.locationCheck(location);
        String strPkg = pkg.toString();
        if (strPkg.length() > 0) {
            this.checkName(strPkg);
        }
        FileObject fileObject = this.fileManager.getFileForOutput(location, strPkg, relativeName.toString(), null);
        this.checkFileReopening(fileObject, true);
        if (fileObject instanceof JavaFileObject) {
            return new FilerOutputJavaFileObject(null, (JavaFileObject)fileObject);
        }
        return new FilerOutputFileObject(null, fileObject);
    }

    private void locationCheck(JavaFileManager.Location location) {
        StandardLocation stdLoc;
        if (location instanceof StandardLocation && !(stdLoc = (StandardLocation)location).isOutputLocation()) {
            throw new IllegalArgumentException("Resource creation not supported in location " + stdLoc);
        }
    }

    @Override
    public FileObject getResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName) throws IOException {
        FileObject fileObject;
        String strPkg = pkg.toString();
        if (strPkg.length() > 0) {
            this.checkName(strPkg);
        }
        if ((fileObject = this.fileManager.getFileForInput(location, pkg.toString(), relativeName.toString())) == null) {
            String name = pkg.length() == 0 ? relativeName.toString() : pkg + "/" + relativeName;
            throw new FileNotFoundException(name);
        }
        this.checkFileReopening(fileObject, false);
        return new FilerInputFileObject(fileObject);
    }

    private void checkName(String name) throws FilerException {
        this.checkName(name, false);
    }

    private void checkName(String name, boolean allowUnnamedPackageInfo) throws FilerException {
        if (!SourceVersion.isName(name) && !this.isPackageInfo(name, allowUnnamedPackageInfo)) {
            if (this.lint) {
                this.log.warning("proc.illegal.file.name", name);
            }
            throw new FilerException("Illegal name " + name);
        }
    }

    private boolean isPackageInfo(String name, boolean allowUnnamedPackageInfo) {
        String PKG_INFO = "package-info";
        int periodIndex = name.lastIndexOf(".");
        if (periodIndex == -1) {
            return allowUnnamedPackageInfo ? name.equals("package-info") : false;
        }
        String prefix = name.substring(0, periodIndex);
        String simple = name.substring(periodIndex + 1);
        return SourceVersion.isName(prefix) && simple.equals("package-info");
    }

    private void checkNameAndExistence(String typename, boolean allowUnnamedPackageInfo) throws FilerException {
        this.checkName(typename, allowUnnamedPackageInfo);
        if (this.aggregateGeneratedSourceNames.contains(typename) || this.aggregateGeneratedClassNames.contains(typename)) {
            if (this.lint) {
                this.log.warning("proc.type.recreate", typename);
            }
            throw new FilerException("Attempt to recreate a file for type " + typename);
        }
    }

    private void checkFileReopening(FileObject fileObject, boolean addToHistory) throws FilerException {
        for (FileObject veteran : this.fileObjectHistory) {
            if (!this.fileManager.isSameFile(veteran, fileObject)) continue;
            if (this.lint) {
                this.log.warning("proc.file.reopening", fileObject.getName());
            }
            throw new FilerException("Attempt to reopen a file for path " + fileObject.getName());
        }
        if (addToHistory) {
            this.fileObjectHistory.add(fileObject);
        }
    }

    public boolean newFiles() {
        return !this.generatedSourceNames.isEmpty() || !this.generatedClasses.isEmpty();
    }

    public Set<String> getGeneratedSourceNames() {
        return this.generatedSourceNames;
    }

    public Set<JavaFileObject> getGeneratedSourceFileObjects() {
        return this.generatedSourceFileObjects;
    }

    public Map<String, JavaFileObject> getGeneratedClasses() {
        return this.generatedClasses;
    }

    public void warnIfUnclosedFiles() {
        if (!this.openTypeNames.isEmpty()) {
            this.log.warning("proc.unclosed.type.files", this.openTypeNames.toString());
        }
    }

    public void newRound(Context context) {
        this.context = context;
        this.log = Log.instance(context);
        this.clearRoundState();
    }

    void setLastRound(boolean lastRound) {
        this.lastRound = lastRound;
    }

    @Override
    public void close() {
        this.clearRoundState();
        this.fileObjectHistory.clear();
        this.openTypeNames.clear();
        this.aggregateGeneratedSourceNames.clear();
        this.aggregateGeneratedClassNames.clear();
    }

    private void clearRoundState() {
        this.generatedSourceNames.clear();
        this.generatedSourceFileObjects.clear();
        this.generatedClasses.clear();
    }

    public void displayState() {
        PrintWriter xout = this.context.get(Log.outKey);
        xout.println("File Object History : " + this.fileObjectHistory);
        xout.println("Open Type Names     : " + this.openTypeNames);
        xout.println("Gen. Src Names      : " + this.generatedSourceNames);
        xout.println("Gen. Cls Names      : " + this.generatedClasses.keySet());
        xout.println("Agg. Gen. Src Names : " + this.aggregateGeneratedSourceNames);
        xout.println("Agg. Gen. Cls Names : " + this.aggregateGeneratedClassNames);
    }

    public String toString() {
        return "javac Filer";
    }

    private void closeFileObject(String typeName, FileObject fileObject) {
        if (typeName != null) {
            if (!(fileObject instanceof JavaFileObject)) {
                throw new AssertionError((Object)("JavaFileOject not found for " + fileObject));
            }
            JavaFileObject javaFileObject = (JavaFileObject)fileObject;
            switch (javaFileObject.getKind()) {
                case SOURCE: {
                    this.generatedSourceNames.add(typeName);
                    this.generatedSourceFileObjects.add(javaFileObject);
                    this.openTypeNames.remove(typeName);
                    break;
                }
                case CLASS: {
                    this.generatedClasses.put(typeName, javaFileObject);
                    this.openTypeNames.remove(typeName);
                    break;
                }
            }
        }
    }

    private class FilerWriter
    extends FilterWriter {
        String typeName;
        FileObject fileObject;
        boolean closed;

        FilerWriter(String typeName, FileObject fileObject) throws IOException {
            super(fileObject.openWriter());
            this.closed = false;
            this.typeName = typeName;
            this.fileObject = fileObject;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                JavacFiler.this.closeFileObject(this.typeName, this.fileObject);
                this.out.close();
            }
        }
    }

    private class FilerOutputStream
    extends FilterOutputStream {
        String typeName;
        FileObject fileObject;
        boolean closed;

        FilerOutputStream(String typeName, FileObject fileObject) throws IOException {
            super(fileObject.openOutputStream());
            this.closed = false;
            this.typeName = typeName;
            this.fileObject = fileObject;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                JavacFiler.this.closeFileObject(this.typeName, this.fileObject);
                this.out.close();
            }
        }
    }

    private class FilerInputJavaFileObject
    extends FilerInputFileObject
    implements JavaFileObject {
        private final JavaFileObject javaFileObject;

        FilerInputJavaFileObject(JavaFileObject javaFileObject) {
            super(javaFileObject);
            this.javaFileObject = javaFileObject;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this.javaFileObject.getKind();
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return this.javaFileObject.isNameCompatible(simpleName, kind);
        }

        @Override
        public NestingKind getNestingKind() {
            return this.javaFileObject.getNestingKind();
        }

        @Override
        public Modifier getAccessLevel() {
            return this.javaFileObject.getAccessLevel();
        }
    }

    private class FilerInputFileObject
    extends ForwardingFileObject<FileObject> {
        FilerInputFileObject(FileObject fileObject) {
            super(fileObject);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_WRITING);
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_WRITING);
        }

        @Override
        public boolean delete() {
            return false;
        }
    }

    private class FilerOutputJavaFileObject
    extends FilerOutputFileObject
    implements JavaFileObject {
        private final JavaFileObject javaFileObject;

        FilerOutputJavaFileObject(String name, JavaFileObject javaFileObject) {
            super(name, javaFileObject);
            this.javaFileObject = javaFileObject;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this.javaFileObject.getKind();
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return this.javaFileObject.isNameCompatible(simpleName, kind);
        }

        @Override
        public NestingKind getNestingKind() {
            return this.javaFileObject.getNestingKind();
        }

        @Override
        public Modifier getAccessLevel() {
            return this.javaFileObject.getAccessLevel();
        }
    }

    private class FilerOutputFileObject
    extends ForwardingFileObject<FileObject> {
        private boolean opened;
        private String name;

        FilerOutputFileObject(String name, FileObject fileObject) {
            super(fileObject);
            this.opened = false;
            this.name = name;
        }

        @Override
        public synchronized OutputStream openOutputStream() throws IOException {
            if (this.opened) {
                throw new IOException(JavacFiler.ALREADY_OPENED);
            }
            this.opened = true;
            return new FilerOutputStream(this.name, this.fileObject);
        }

        @Override
        public synchronized Writer openWriter() throws IOException {
            if (this.opened) {
                throw new IOException(JavacFiler.ALREADY_OPENED);
            }
            this.opened = true;
            return new FilerWriter(this.name, this.fileObject);
        }

        @Override
        public InputStream openInputStream() throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_READING);
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_READING);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_READING);
        }

        @Override
        public boolean delete() {
            return false;
        }
    }
}

