/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.processing;

import com.redhat.ceylon.javax.annotation.processing.ProcessingEnvironment;
import com.redhat.ceylon.javax.annotation.processing.RoundEnvironment;
import com.redhat.ceylon.javax.lang.model.element.AnnotationMirror;
import com.redhat.ceylon.javax.lang.model.element.Element;
import com.redhat.ceylon.javax.lang.model.element.ElementKind;
import com.redhat.ceylon.javax.lang.model.element.TypeElement;
import com.redhat.ceylon.javax.lang.model.type.DeclaredType;
import com.redhat.ceylon.javax.lang.model.type.TypeMirror;
import com.redhat.ceylon.javax.lang.model.util.ElementScanner6;
import com.redhat.ceylon.javax.lang.model.util.ElementScanner7;
import com.redhat.ceylon.javax.lang.model.util.Types;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class JavacRoundEnvironment
implements RoundEnvironment {
    private final boolean processingOver;
    private final boolean errorRaised;
    private final ProcessingEnvironment processingEnv;
    private final Set<? extends Element> rootElements;
    private static final String NOT_AN_ANNOTATION_TYPE = "The argument does not represent an annotation type: ";

    JavacRoundEnvironment(boolean processingOver, boolean errorRaised, Set<? extends Element> rootElements, ProcessingEnvironment processingEnv) {
        this.processingOver = processingOver;
        this.errorRaised = errorRaised;
        this.rootElements = rootElements;
        this.processingEnv = processingEnv;
    }

    public String toString() {
        return String.format("[errorRaised=%b, rootElements=%s, processingOver=%b]", this.errorRaised, this.rootElements, this.processingOver);
    }

    @Override
    public boolean processingOver() {
        return this.processingOver;
    }

    @Override
    public boolean errorRaised() {
        return this.errorRaised;
    }

    @Override
    public Set<? extends Element> getRootElements() {
        return this.rootElements;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(TypeElement a) {
        Set result = Collections.emptySet();
        Types typeUtil = this.processingEnv.getTypeUtils();
        if (a.getKind() != ElementKind.ANNOTATION_TYPE) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + a);
        }
        TypeMirror tm = a.asType();
        if (!(tm instanceof DeclaredType)) {
            throw new AssertionError((Object)("Bad implementation type for " + tm));
        }
        DeclaredType annotationTypeElement = (DeclaredType)a.asType();
        AnnotationSetScanner scanner = new AnnotationSetScanner(result, typeUtil);
        for (Element element : this.rootElements) {
            result = (Set)((ElementScanner6)scanner).scan(element, annotationTypeElement);
        }
        return result;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> a) {
        if (!a.isAnnotation()) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + a);
        }
        String name = a.getCanonicalName();
        if (name == null) {
            return Collections.emptySet();
        }
        TypeElement annotationType = this.processingEnv.getElementUtils().getTypeElement(name);
        if (annotationType == null) {
            return Collections.emptySet();
        }
        return this.getElementsAnnotatedWith(annotationType);
    }

    private class AnnotationSetScanner
    extends ElementScanner7<Set<Element>, DeclaredType> {
        Set<Element> annotatedElements;
        Types typeUtil;

        AnnotationSetScanner(Set<Element> defaultSet, Types typeUtil) {
            super(defaultSet);
            this.annotatedElements = new LinkedHashSet<Element>();
            this.typeUtil = typeUtil;
        }

        @Override
        public Set<Element> scan(Element e, DeclaredType p) {
            List<? extends AnnotationMirror> annotationMirrors = JavacRoundEnvironment.this.processingEnv.getElementUtils().getAllAnnotationMirrors(e);
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                if (!this.typeUtil.isSameType(annotationMirror.getAnnotationType(), p)) continue;
                this.annotatedElements.add(e);
            }
            e.accept(this, p);
            return this.annotatedElements;
        }
    }
}

