/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.util;

import com.redhat.ceylon.langtools.tools.javac.code.Kinds;
import com.redhat.ceylon.langtools.tools.javac.code.Printer;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.Symtab;
import com.redhat.ceylon.langtools.tools.javac.code.Type;
import com.redhat.ceylon.langtools.tools.javac.code.Types;
import com.redhat.ceylon.langtools.tools.javac.util.AbstractDiagnosticFormatter;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.ForwardingDiagnosticFormatter;
import com.redhat.ceylon.langtools.tools.javac.util.JCDiagnostic;
import com.redhat.ceylon.langtools.tools.javac.util.JavacMessages;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class RichDiagnosticFormatter
extends ForwardingDiagnosticFormatter<JCDiagnostic, AbstractDiagnosticFormatter> {
    final Symtab syms;
    final Types types;
    final JCDiagnostic.Factory diags;
    final JavacMessages messages;
    protected ClassNameSimplifier nameSimplifier;
    private RichPrinter printer;
    Map<WhereClauseKind, Map<Type, JCDiagnostic>> whereClauses;
    protected Types.UnaryVisitor<Void> typePreprocessor = new Types.UnaryVisitor<Void>(){

        public Void visit(List<Type> ts) {
            for (Type t : ts) {
                this.visit(t);
            }
            return null;
        }

        @Override
        public Void visitForAll(Type.ForAll t, Void ignored) {
            this.visit(t.tvars);
            this.visit(t.qtype);
            return null;
        }

        @Override
        public Void visitMethodType(Type.MethodType t, Void ignored) {
            this.visit(t.argtypes);
            this.visit(t.restype);
            return null;
        }

        @Override
        public Void visitErrorType(Type.ErrorType t, Void ignored) {
            Type ot = t.getOriginalType();
            if (ot != null) {
                this.visit(ot);
            }
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType t, Void ignored) {
            this.visit(t.elemtype);
            return null;
        }

        @Override
        public Void visitWildcardType(Type.WildcardType t, Void ignored) {
            this.visit(t.type);
            return null;
        }

        @Override
        public Void visitType(Type t, Void ignored) {
            return null;
        }

        @Override
        public Void visitCapturedType(Type.CapturedType t, Void ignored) {
            if (RichDiagnosticFormatter.this.indexOf(t, WhereClauseKind.CAPTURED) == -1) {
                String suffix = t.lower == RichDiagnosticFormatter.this.syms.botType ? ".1" : "";
                JCDiagnostic d = RichDiagnosticFormatter.this.diags.fragment("where.captured" + suffix, t, t.bound, t.lower, t.wildcard);
                RichDiagnosticFormatter.this.whereClauses.get((Object)WhereClauseKind.CAPTURED).put(t, d);
                this.visit(t.wildcard);
                this.visit(t.lower);
                this.visit(t.bound);
            }
            return null;
        }

        @Override
        public Void visitClassType(Type.ClassType t, Void ignored) {
            if (t.isCompound() && RichDiagnosticFormatter.this.indexOf(t, WhereClauseKind.INTERSECTION) == -1) {
                Type supertype = RichDiagnosticFormatter.this.types.supertype(t);
                List<Type> interfaces = RichDiagnosticFormatter.this.types.interfaces(t);
                JCDiagnostic d = RichDiagnosticFormatter.this.diags.fragment("where.intersection", t, interfaces.prepend(supertype));
                RichDiagnosticFormatter.this.whereClauses.get((Object)WhereClauseKind.INTERSECTION).put(t, d);
                this.visit(supertype);
                this.visit(interfaces);
            }
            RichDiagnosticFormatter.this.nameSimplifier.addUsage(t.tsym);
            this.visit((List<Type>)t.getTypeArguments());
            if (t.getEnclosingType() != Type.noType) {
                this.visit(t.getEnclosingType());
            }
            return null;
        }

        @Override
        public Void visitTypeVar(Type.TypeVar t, Void ignored) {
            if (RichDiagnosticFormatter.this.indexOf(t, WhereClauseKind.TYPEVAR) == -1) {
                Type bound = t.bound;
                while (bound instanceof Type.ErrorType) {
                    bound = ((Type.ErrorType)bound).getOriginalType();
                }
                List<Type> bounds = bound != null ? RichDiagnosticFormatter.this.types.getBounds(t) : List.nil();
                RichDiagnosticFormatter.this.nameSimplifier.addUsage(t.tsym);
                boolean boundErroneous = bounds.head == null || ((Type)bounds.head).tag == 18 || ((Type)bounds.head).tag == 19;
                JCDiagnostic d = RichDiagnosticFormatter.this.diags.fragment("where.typevar" + (boundErroneous ? ".1" : ""), t, bounds, Kinds.kindName(t.tsym.location()), t.tsym.location());
                RichDiagnosticFormatter.this.whereClauses.get((Object)WhereClauseKind.TYPEVAR).put(t, d);
                RichDiagnosticFormatter.this.symbolPreprocessor.visit(t.tsym.location(), null);
                this.visit(bounds);
            }
            return null;
        }
    };
    protected Types.DefaultSymbolVisitor<Void, Void> symbolPreprocessor = new Types.DefaultSymbolVisitor<Void, Void>(){

        @Override
        public Void visitClassSymbol(Symbol.ClassSymbol s, Void ignored) {
            RichDiagnosticFormatter.this.nameSimplifier.addUsage(s);
            return null;
        }

        @Override
        public Void visitSymbol(Symbol s, Void ignored) {
            return null;
        }

        @Override
        public Void visitMethodSymbol(Symbol.MethodSymbol s, Void ignored) {
            this.visit(s.owner, null);
            if (s.type != null) {
                RichDiagnosticFormatter.this.typePreprocessor.visit(s.type);
            }
            return null;
        }
    };

    public static RichDiagnosticFormatter instance(Context context) {
        RichDiagnosticFormatter instance = context.get(RichDiagnosticFormatter.class);
        if (instance == null) {
            instance = new RichDiagnosticFormatter(context);
        }
        return instance;
    }

    protected RichDiagnosticFormatter(Context context) {
        super((AbstractDiagnosticFormatter)Log.instance(context).getDiagnosticFormatter());
        this.setRichPrinter(new RichPrinter());
        this.syms = Symtab.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.types = Types.instance(context);
        this.messages = JavacMessages.instance(context);
        this.whereClauses = new LinkedHashMap<WhereClauseKind, Map<Type, JCDiagnostic>>();
        this.configuration = new RichConfiguration(Options.instance(context), (AbstractDiagnosticFormatter)this.formatter);
        for (WhereClauseKind kind : WhereClauseKind.values()) {
            this.whereClauses.put(kind, new LinkedHashMap());
        }
    }

    @Override
    public String format(JCDiagnostic diag, Locale l) {
        StringBuilder sb = new StringBuilder();
        this.nameSimplifier = new ClassNameSimplifier();
        for (WhereClauseKind kind : WhereClauseKind.values()) {
            this.whereClauses.get((Object)kind).clear();
        }
        this.preprocessDiagnostic(diag);
        sb.append(((AbstractDiagnosticFormatter)this.formatter).format(diag, l));
        if (this.getConfiguration().isEnabled(RichConfiguration.RichFormatterFeature.WHERE_CLAUSES)) {
            List<JCDiagnostic> clauses = this.getWhereClauses();
            String indent = ((AbstractDiagnosticFormatter)this.formatter).isRaw() ? "" : ((AbstractDiagnosticFormatter)this.formatter).indentString(2);
            for (JCDiagnostic d : clauses) {
                String whereClause = ((AbstractDiagnosticFormatter)this.formatter).format(d, l);
                if (whereClause.length() <= 0) continue;
                sb.append('\n' + indent + whereClause);
            }
        }
        return sb.toString();
    }

    protected void setRichPrinter(RichPrinter printer) {
        this.printer = printer;
        ((AbstractDiagnosticFormatter)this.formatter).setPrinter(printer);
    }

    protected RichPrinter getRichPrinter() {
        return this.printer;
    }

    protected void preprocessDiagnostic(JCDiagnostic diag) {
        for (Object o : diag.getArgs()) {
            if (o == null) continue;
            this.preprocessArgument(o);
        }
        if (diag.isMultiline()) {
            for (JCDiagnostic d : diag.getSubdiagnostics()) {
                this.preprocessDiagnostic(d);
            }
        }
    }

    protected void preprocessArgument(Object arg) {
        if (arg instanceof Type) {
            this.preprocessType((Type)arg);
        } else if (arg instanceof Symbol) {
            this.preprocessSymbol((Symbol)arg);
        } else if (arg instanceof JCDiagnostic) {
            this.preprocessDiagnostic((JCDiagnostic)arg);
        } else if (arg instanceof Iterable) {
            for (Object o : (Iterable)arg) {
                this.preprocessArgument(o);
            }
        }
    }

    protected List<JCDiagnostic> getWhereClauses() {
        List<JCDiagnostic> clauses = List.nil();
        for (WhereClauseKind kind : WhereClauseKind.values()) {
            List<Object> lines = List.nil();
            for (Map.Entry<Type, JCDiagnostic> entry : this.whereClauses.get((Object)kind).entrySet()) {
                lines = lines.prepend(entry.getValue());
            }
            if (lines.isEmpty()) continue;
            String key = kind.key();
            if (lines.size() > 1) {
                key = key + ".1";
            }
            JCDiagnostic d = this.diags.fragment(key, this.whereClauses.get((Object)kind).keySet());
            d = new JCDiagnostic.MultilineDiagnostic(d, lines.reverse());
            clauses = clauses.prepend(d);
        }
        return clauses.reverse();
    }

    private int indexOf(Type type, WhereClauseKind kind) {
        int index = 1;
        for (Type t : this.whereClauses.get((Object)kind).keySet()) {
            if (t.tsym == type.tsym) {
                return index;
            }
            if (kind == WhereClauseKind.TYPEVAR && !t.toString().equals(type.toString())) continue;
            ++index;
        }
        return -1;
    }

    private boolean unique(Type.TypeVar typevar) {
        int found = 0;
        for (Type t : this.whereClauses.get((Object)WhereClauseKind.TYPEVAR).keySet()) {
            if (!t.toString().equals(typevar.toString())) continue;
            ++found;
        }
        if (found < 1) {
            throw new AssertionError((Object)("Missing type variable in where clause " + typevar));
        }
        return found == 1;
    }

    protected void preprocessType(Type t) {
        this.typePreprocessor.visit(t);
    }

    protected void preprocessSymbol(Symbol s) {
        this.symbolPreprocessor.visit(s, null);
    }

    @Override
    public RichConfiguration getConfiguration() {
        return (RichConfiguration)this.configuration;
    }

    public static class RichConfiguration
    extends ForwardingDiagnosticFormatter.ForwardingConfiguration {
        protected EnumSet<RichFormatterFeature> features;

        public RichConfiguration(Options options, AbstractDiagnosticFormatter formatter) {
            super(formatter.getConfiguration());
            this.features = formatter.isRaw() ? EnumSet.noneOf(RichFormatterFeature.class) : EnumSet.of(RichFormatterFeature.SIMPLE_NAMES, RichFormatterFeature.WHERE_CLAUSES, RichFormatterFeature.UNIQUE_TYPEVAR_NAMES);
            String diagOpts = options.get("diags");
            if (diagOpts != null) {
                for (String args : diagOpts.split(",")) {
                    if (args.equals("-where")) {
                        this.features.remove((Object)RichFormatterFeature.WHERE_CLAUSES);
                    } else if (args.equals("where")) {
                        this.features.add(RichFormatterFeature.WHERE_CLAUSES);
                    }
                    if (args.equals("-simpleNames")) {
                        this.features.remove((Object)RichFormatterFeature.SIMPLE_NAMES);
                    } else if (args.equals("simpleNames")) {
                        this.features.add(RichFormatterFeature.SIMPLE_NAMES);
                    }
                    if (args.equals("-disambiguateTvars")) {
                        this.features.remove((Object)RichFormatterFeature.UNIQUE_TYPEVAR_NAMES);
                        continue;
                    }
                    if (!args.equals("disambiguateTvars")) continue;
                    this.features.add(RichFormatterFeature.UNIQUE_TYPEVAR_NAMES);
                }
            }
        }

        public RichFormatterFeature[] getAvailableFeatures() {
            return RichFormatterFeature.values();
        }

        public void enable(RichFormatterFeature feature) {
            this.features.add(feature);
        }

        public void disable(RichFormatterFeature feature) {
            this.features.remove((Object)feature);
        }

        public boolean isEnabled(RichFormatterFeature feature) {
            return this.features.contains((Object)feature);
        }

        public static enum RichFormatterFeature {
            WHERE_CLAUSES,
            SIMPLE_NAMES,
            UNIQUE_TYPEVAR_NAMES;

        }
    }

    protected class RichPrinter
    extends Printer {
        protected RichPrinter() {
        }

        @Override
        public String localize(Locale locale, String key, Object ... args) {
            return ((AbstractDiagnosticFormatter)RichDiagnosticFormatter.this.formatter).localize(locale, key, args);
        }

        @Override
        public String capturedVarId(Type.CapturedType t, Locale locale) {
            return RichDiagnosticFormatter.this.indexOf(t, WhereClauseKind.CAPTURED) + "";
        }

        @Override
        public String visitType(Type t, Locale locale) {
            String s = super.visitType(t, locale);
            if (t == RichDiagnosticFormatter.this.syms.botType) {
                s = this.localize(locale, "compiler.misc.type.null", new Object[0]);
            }
            return s;
        }

        @Override
        public String visitCapturedType(Type.CapturedType t, Locale locale) {
            if (RichDiagnosticFormatter.this.getConfiguration().isEnabled(RichConfiguration.RichFormatterFeature.WHERE_CLAUSES)) {
                return this.localize(locale, "compiler.misc.captured.type", RichDiagnosticFormatter.this.indexOf(t, WhereClauseKind.CAPTURED));
            }
            return super.visitCapturedType(t, locale);
        }

        @Override
        public String visitClassType(Type.ClassType t, Locale locale) {
            if (t.isCompound() && RichDiagnosticFormatter.this.getConfiguration().isEnabled(RichConfiguration.RichFormatterFeature.WHERE_CLAUSES)) {
                return this.localize(locale, "compiler.misc.intersection.type", RichDiagnosticFormatter.this.indexOf(t, WhereClauseKind.INTERSECTION));
            }
            return super.visitClassType(t, locale);
        }

        @Override
        protected String className(Type.ClassType t, boolean longform, Locale locale) {
            Symbol.TypeSymbol sym = t.tsym;
            if (sym.name.length() == 0 || !RichDiagnosticFormatter.this.getConfiguration().isEnabled(RichConfiguration.RichFormatterFeature.SIMPLE_NAMES)) {
                return super.className(t, longform, locale);
            }
            if (longform) {
                return RichDiagnosticFormatter.this.nameSimplifier.simplify(sym).toString();
            }
            return sym.name.toString();
        }

        @Override
        public String visitTypeVar(Type.TypeVar t, Locale locale) {
            if (RichDiagnosticFormatter.this.unique(t) || !RichDiagnosticFormatter.this.getConfiguration().isEnabled(RichConfiguration.RichFormatterFeature.UNIQUE_TYPEVAR_NAMES)) {
                return t.toString();
            }
            return this.localize(locale, "compiler.misc.type.var", t.toString(), RichDiagnosticFormatter.this.indexOf(t, WhereClauseKind.TYPEVAR));
        }

        @Override
        protected String printMethodArgs(List<Type> args, boolean varArgs, Locale locale) {
            return super.printMethodArgs(args, varArgs, locale);
        }

        @Override
        public String visitClassSymbol(Symbol.ClassSymbol s, Locale locale) {
            String name = RichDiagnosticFormatter.this.nameSimplifier.simplify(s);
            if (name.length() == 0 || !RichDiagnosticFormatter.this.getConfiguration().isEnabled(RichConfiguration.RichFormatterFeature.SIMPLE_NAMES)) {
                return super.visitClassSymbol(s, locale);
            }
            return name;
        }

        @Override
        public String visitMethodSymbol(Symbol.MethodSymbol s, Locale locale) {
            String ms;
            String ownerName = this.visit(s.owner, locale);
            if ((s.flags() & 0x100000L) != 0L) {
                return ownerName;
            }
            String string = ms = s.name == s.name.table.names.init ? ownerName : s.name.toString();
            if (s.type != null) {
                if (s.type.tag == 16) {
                    ms = "<" + this.visitTypes(s.type.getTypeArguments(), locale) + ">" + ms;
                }
                ms = ms + "(" + this.printMethodArgs(s.type.getParameterTypes(), (s.flags() & 0x400000000L) != 0L, locale) + ")";
            }
            return ms;
        }
    }

    protected class ClassNameSimplifier {
        Map<com.redhat.ceylon.javax.lang.model.element.Name, List<Symbol>> nameClashes = new HashMap<com.redhat.ceylon.javax.lang.model.element.Name, List<Symbol>>();

        protected ClassNameSimplifier() {
        }

        protected void addUsage(Symbol sym) {
            Name n = sym.getSimpleName();
            List<Symbol> conflicts = this.nameClashes.get(n);
            if (conflicts == null) {
                conflicts = List.nil();
            }
            if (!conflicts.contains(sym)) {
                this.nameClashes.put(n, conflicts.append(sym));
            }
        }

        public String simplify(Symbol s) {
            List<Symbol> conflicts;
            String name = s.getQualifiedName().toString();
            if (!s.type.isCompound() && ((conflicts = this.nameClashes.get(s.getSimpleName())) == null || conflicts.size() == 1 && conflicts.contains(s))) {
                List<Object> l = List.nil();
                Symbol s2 = s;
                while (s2.type.getEnclosingType().tag == 10 && s2.owner.kind == 2) {
                    l = l.prepend(s2.getSimpleName());
                    s2 = s2.owner;
                }
                l = l.prepend(s2.getSimpleName());
                StringBuilder buf = new StringBuilder();
                String sep = "";
                for (com.redhat.ceylon.javax.lang.model.element.Name name2 : l) {
                    buf.append(sep);
                    buf.append(name2);
                    sep = ".";
                }
                name = buf.toString();
            }
            return name;
        }
    }

    static enum WhereClauseKind {
        TYPEVAR("where.description.typevar"),
        CAPTURED("where.description.captured"),
        INTERSECTION("where.description.intersection");

        private String key;

        private WhereClauseKind(String key) {
            this.key = key;
        }

        String key() {
            return this.key;
        }
    }
}

