/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.util;

import com.redhat.ceylon.langtools.tools.javac.util.Convert;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.langtools.tools.javac.util.Names;
import java.lang.ref.SoftReference;

public class SharedNameTable
extends Name.Table {
    private static List<SoftReference<SharedNameTable>> freelist = List.nil();
    private NameImpl[] hashes;
    public byte[] bytes;
    private int hashMask;
    private int nc = 0;

    public static synchronized SharedNameTable create(Names names) {
        while (freelist.nonEmpty()) {
            SharedNameTable t = (SharedNameTable)((SoftReference)SharedNameTable.freelist.head).get();
            freelist = SharedNameTable.freelist.tail;
            if (t == null) continue;
            return t;
        }
        return new SharedNameTable(names);
    }

    private static synchronized void dispose(SharedNameTable t) {
        freelist = freelist.prepend(new SoftReference<SharedNameTable>(t));
    }

    public SharedNameTable(Names names, int hashSize, int nameSize) {
        super(names);
        this.hashMask = hashSize - 1;
        this.hashes = new NameImpl[hashSize];
        this.bytes = new byte[nameSize];
    }

    public SharedNameTable(Names names) {
        this(names, 32768, 131072);
    }

    @Override
    public Name fromChars(char[] cs, int start, int len) {
        int nc = this.nc;
        byte[] bytes = this.bytes;
        while (nc + len * 3 >= bytes.length) {
            byte[] newnames = new byte[bytes.length * 2];
            System.arraycopy(bytes, 0, newnames, 0, bytes.length);
            this.bytes = newnames;
            bytes = newnames;
        }
        int nbytes = Convert.chars2utf(cs, start, bytes, nc, len) - nc;
        int h = SharedNameTable.hashValue(bytes, nc, nbytes) & this.hashMask;
        NameImpl n = this.hashes[h];
        while (!(n == null || n.getByteLength() == nbytes && SharedNameTable.equals(bytes, n.index, bytes, nc, nbytes))) {
            n = n.next;
        }
        if (n == null) {
            n = new NameImpl(this);
            n.index = nc;
            n.length = nbytes;
            n.next = this.hashes[h];
            this.hashes[h] = n;
            this.nc = nc + nbytes;
            if (nbytes == 0) {
                ++this.nc;
            }
        }
        return n;
    }

    @Override
    public Name fromUtf(byte[] cs, int start, int len) {
        int h = SharedNameTable.hashValue(cs, start, len) & this.hashMask;
        NameImpl n = this.hashes[h];
        byte[] names = this.bytes;
        while (!(n == null || n.getByteLength() == len && SharedNameTable.equals(names, n.index, cs, start, len))) {
            n = n.next;
        }
        if (n == null) {
            int nc = this.nc;
            while (nc + len > names.length) {
                byte[] newnames = new byte[names.length * 2];
                System.arraycopy(names, 0, newnames, 0, names.length);
                this.bytes = newnames;
                names = newnames;
            }
            System.arraycopy(cs, start, names, nc, len);
            n = new NameImpl(this);
            n.index = nc;
            n.length = len;
            n.next = this.hashes[h];
            this.hashes[h] = n;
            this.nc = nc + len;
            if (len == 0) {
                ++this.nc;
            }
        }
        return n;
    }

    @Override
    public void dispose() {
    }

    static class NameImpl
    extends Name {
        NameImpl next;
        int index;
        int length;

        NameImpl(SharedNameTable table) {
            super(table);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getByteLength() {
            return this.length;
        }

        @Override
        public byte getByteAt(int i) {
            return this.getByteArray()[this.index + i];
        }

        @Override
        public byte[] getByteArray() {
            return ((SharedNameTable)this.table).bytes;
        }

        @Override
        public int getByteOffset() {
            return this.index;
        }

        @Override
        public int hashCode() {
            return this.index;
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof Name) {
                return this.table == ((Name)other).table && this.index == ((Name)other).getIndex();
            }
            return false;
        }
    }
}

