/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.launcher;

import com.redhat.ceylon.launcher.CeylonClassLoader;
import com.redhat.ceylon.launcher.LauncherUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Bootstrap {
    public static final String CEYLON_DOWNLOAD_BASE_URL = "https://downloads.ceylon-lang.org/cli/";
    public static final String FILE_BOOTSTRAP_PROPERTIES = "ceylon-bootstrap.properties";
    public static final String FILE_BOOTSTRAP_JAR = "ceylon-bootstrap.jar";
    public static final String KEY_SHA256SUM = "sha256sum";
    public static final String KEY_INSTALLATION = "installation";
    public static final String KEY_DISTRIBUTION = "distribution";
    private static final String FOLDER_DISTS = "dists";
    private static final int DOWNLOAD_TIMEOUT_READ = 30000;
    private static final int DOWNLOAD_TIMEOUT_CONNECT = 15000;
    private static final int DOWNLOAD_BUFFER_SIZE = 4096;
    private static final String ENV_CEYLON_BOOTSTRAP_DISTS = "CEYLON_BOOTSTRAP_DISTS";
    private static final String ENV_CEYLON_BOOTSTRAP_PROPS = "CEYLON_BOOTSTRAP_PROPERTIES";
    private static final String PROP_CEYLON_BOOTSTRAP_DISTS = "ceylon.bootstrap.dists";
    private static final String PROP_CEYLON_BOOTSTRAP_PROPS = "ceylon.bootstrap.properties";

    public static void main(String[] args) throws Throwable {
        int exit = Bootstrap.run(args);
        if (exit != 0) {
            System.exit(exit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(String ... args) throws Throwable {
        CeylonClassLoader cl = null;
        try {
            Integer result = -1;
            Method runMethod = null;
            try {
                String ceylonVersion;
                if (Bootstrap.isDistBootstrap()) {
                    Config cfg = Bootstrap.loadBootstrapConfig();
                    Bootstrap.setupDistHome(cfg);
                    ceylonVersion = Bootstrap.determineDistVersion();
                } else if (Bootstrap.distArgument(args) != null) {
                    String dist = Bootstrap.distArgument(args);
                    args = Bootstrap.stripDistArgument(args);
                    Config cfg = Bootstrap.createDistributionConfig(dist);
                    Bootstrap.setupDistHome(cfg);
                    ceylonVersion = Bootstrap.determineDistVersion();
                } else {
                    ceylonVersion = LauncherUtil.determineSystemVersion();
                }
                File module = CeylonClassLoader.getRepoJar("ceylon.bootstrap", ceylonVersion);
                if (!module.exists()) {
                    File homeLib = new File(System.getProperty("ceylon.home"), "lib");
                    module = new File(homeLib, FILE_BOOTSTRAP_JAR);
                }
                cl = CeylonClassLoader.newInstance(Arrays.asList(module));
                Class<?> launcherClass = cl.loadClass("com.redhat.ceylon.launcher.Launcher");
                runMethod = launcherClass.getMethod("run", String[].class);
            }
            catch (Exception e) {
                System.err.println("Fatal: Ceylon command could not be executed");
                if (e.getCause() != null) {
                    throw e;
                }
                if (!(e instanceof RuntimeException) || e.getMessage() == null) {
                    System.err.println("   --> " + e.toString());
                } else {
                    System.err.println("   --> " + e.getMessage());
                }
                int n = -1;
                if (cl != null) {
                    cl.clearCache();
                    try {
                        cl.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return n;
            }
            try {
                result = (Integer)runMethod.invoke(null, new Object[]{args});
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            int n = result;
            return n;
        }
        finally {
            if (cl != null) {
                cl.clearCache();
                try {
                    cl.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean isDistBootstrap() throws URISyntaxException {
        File propsFile = Bootstrap.getPropertiesFile();
        return propsFile.exists();
    }

    private static String distArgument(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("-")) break;
            if (!arg.startsWith("--distribution=") || arg.length() <= 15) continue;
            return arg.substring(15);
        }
        return null;
    }

    private static String[] stripDistArgument(String[] args) {
        ArrayList<String> lst = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("--distribution=") && arg.length() > 15) continue;
            lst.add(arg);
        }
        String[] buf = new String[lst.size()];
        return lst.toArray(buf);
    }

    private static void setupDistHome(Config cfg) throws Exception {
        if (!cfg.distributionDir.exists()) {
            Bootstrap.install(cfg);
            if (!cfg.distributionDir.exists()) {
                throw new RuntimeException("Unable to install distribution");
            }
        }
        System.setProperty("ceylon.home", cfg.distributionDir.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void install(Config cfg) throws Exception {
        File tmpFolder;
        block9: {
            File tmpFile = null;
            tmpFolder = null;
            try {
                String sum;
                File zipFile;
                if (cfg.distribution.getScheme() != null) {
                    ProgressMonitor monitor = null;
                    if (System.console() != null) {
                        monitor = new ProgressMonitor(){

                            @Override
                            public void update(long read, long size) {
                                String progress = size == -1L ? String.valueOf(read / 1024L) + "K" : String.valueOf(read * 100L / size) + "%";
                                System.out.print("Downloading Ceylon... " + progress + "\r");
                            }
                        };
                    }
                    tmpFile = zipFile = File.createTempFile("ceylon-bootstrap-dist-", ".part");
                    Bootstrap.setupProxyAuthentication();
                    Bootstrap.download(cfg.distribution, zipFile, monitor);
                } else {
                    zipFile = new File(cfg.properties.getParentFile(), cfg.distribution.getPath()).getAbsoluteFile();
                }
                if (cfg.sha256sum != null && !(sum = Bootstrap.calculateSha256Sum(zipFile)).equals(cfg.sha256sum)) {
                    throw new RuntimeException("Error verifying Ceylon distribution archive: SHA sums do not match");
                }
                Bootstrap.mkdirs(cfg.resolvedInstallation);
                tmpFolder = Files.createTempDirectory(cfg.resolvedInstallation.toPath(), "ceylon-bootstrap-dist-", new FileAttribute[0]).toFile();
                Bootstrap.extractArchive(zipFile, tmpFolder);
                Bootstrap.validateDistribution(cfg, tmpFolder);
                tmpFolder.renameTo(cfg.distributionDir);
                System.out.print("                              \r");
                if (tmpFile == null) break block9;
            }
            catch (Throwable throwable) {
                if (tmpFile != null) {
                    Bootstrap.delete(tmpFile);
                }
                if (tmpFolder != null) {
                    Bootstrap.delete(tmpFolder);
                }
                throw throwable;
            }
            Bootstrap.delete(tmpFile);
        }
        if (tmpFolder != null) {
            Bootstrap.delete(tmpFolder);
        }
    }

    private static void validateDistribution(Config cfg, File tmpFolder) {
        boolean valid;
        File binDir = new File(tmpFolder, "bin");
        File libDir = new File(tmpFolder, "lib");
        File repoDir = new File(tmpFolder, "repo");
        boolean bl = valid = binDir.exists() && libDir.exists() && repoDir.exists();
        if (!valid) {
            throw new RuntimeException("Not a valid Ceylon distribution archive: " + cfg.distribution);
        }
        File bootstrapLibJar = new File(libDir, FILE_BOOTSTRAP_JAR);
        if (!bootstrapLibJar.exists()) {
            throw new RuntimeException("Ceylon distribution archive is too old and not supported: " + cfg.distribution);
        }
    }

    private static File getPropertiesFile() throws URISyntaxException {
        String cbp = System.getProperty(PROP_CEYLON_BOOTSTRAP_PROPS);
        if (cbp != null) {
            return new File(cbp);
        }
        cbp = System.getenv(ENV_CEYLON_BOOTSTRAP_PROPS);
        if (cbp != null) {
            return new File(cbp);
        }
        File jar = LauncherUtil.determineRuntimeJar();
        return new File(jar.getParentFile(), FILE_BOOTSTRAP_PROPERTIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadBootstrapProperties() throws Exception {
        File propsFile = Bootstrap.getPropertiesFile();
        FileInputStream fileInput = null;
        try {
            fileInput = new FileInputStream(propsFile);
            Properties properties = new Properties();
            properties.load(fileInput);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (fileInput != null) {
                fileInput.close();
            }
        }
    }

    private static Config loadBootstrapConfig() throws Exception {
        Properties properties = Bootstrap.loadBootstrapProperties();
        Config cfg = new Config();
        cfg.properties = Bootstrap.getPropertiesFile();
        if (!properties.containsKey(KEY_DISTRIBUTION)) {
            throw new RuntimeException("Error in bootstrap properties file: missing 'distribution'");
        }
        cfg.distribution = new URI(properties.getProperty(KEY_DISTRIBUTION));
        if (properties.containsKey(KEY_INSTALLATION)) {
            String installString = properties.getProperty(KEY_INSTALLATION);
            installString = installString.replaceAll("^~", System.getProperty("user.home")).replace("${user.home}", System.getProperty("user.home")).replace("${ceylon.user.dir}", Bootstrap.getUserDir().getAbsolutePath());
            cfg.installation = new File(installString);
            cfg.resolvedInstallation = cfg.properties.getParentFile().toPath().resolve(cfg.installation.toPath()).toFile().getAbsoluteFile();
        } else {
            String distsDirStr = System.getProperty(PROP_CEYLON_BOOTSTRAP_DISTS);
            File distsDir = distsDirStr != null ? new File(distsDirStr) : ((distsDirStr = System.getenv(ENV_CEYLON_BOOTSTRAP_DISTS)) != null ? new File(distsDirStr) : new File(Bootstrap.getUserDir(), FOLDER_DISTS));
            cfg.resolvedInstallation = distsDir;
        }
        cfg.sha256sum = properties.getProperty(KEY_SHA256SUM);
        return Bootstrap.updateConfig(cfg);
    }

    private static Config createDistributionConfig(String dist) throws URISyntaxException {
        Config cfg = new Config();
        cfg.distribution = Bootstrap.getDistributionUri(dist);
        return Bootstrap.updateConfig(cfg);
    }

    private static URI getDistributionUri(String dist) throws URISyntaxException {
        URI uri = new URI(dist);
        if (uri.getScheme() != null) {
            return uri;
        }
        return new URI("https://downloads.ceylon-lang.org/cli/ceylon-" + dist + ".zip");
    }

    private static Config updateConfig(Config cfg) {
        cfg.hash = Bootstrap.hash(cfg.distribution.toString());
        cfg.resolvedInstallation = cfg.installation != null ? cfg.properties.getParentFile().toPath().resolve(cfg.installation.toPath()).toFile().getAbsoluteFile() : new File(Bootstrap.getUserDir(), FOLDER_DISTS);
        cfg.distributionDir = new File(cfg.resolvedInstallation, cfg.hash);
        return cfg;
    }

    private static File mkdirs(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Unable to create destination directory: " + dir);
        }
        return dir;
    }

    private static void delete(File f) {
        if (!Bootstrap.delete_(f)) {
            f.deleteOnExit();
        }
    }

    private static boolean delete_(File f) {
        boolean ok = true;
        if (f.exists()) {
            if (f.isDirectory()) {
                for (File c : f.listFiles()) {
                    ok = ok && Bootstrap.delete_(c);
                }
            }
            try {
                boolean deleted = f.delete();
                ok = ok && deleted;
            }
            catch (Exception ex) {
                ok = false;
            }
        }
        return ok;
    }

    private static File getDefaultUserDir() {
        String userHome = System.getProperty("user.home");
        return new File(userHome, ".ceylon");
    }

    private static File getUserDir() {
        String ceylonUserDir = System.getProperty("ceylon.user.dir");
        if (ceylonUserDir != null) {
            return new File(ceylonUserDir);
        }
        return Bootstrap.getDefaultUserDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void extractArchive(File zip, File dir) throws IOException {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new RuntimeException("Error extracting archive: destination not a directory: " + dir);
            }
        } else {
            Bootstrap.mkdirs(dir);
        }
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = Bootstrap.stripRoot(entry.getName());
                try {
                    if (entryName.isEmpty()) continue;
                    File out = new File(dir, entryName);
                    if (entry.isDirectory()) {
                        Bootstrap.mkdirs(out);
                        continue;
                    }
                    Bootstrap.mkdirs(out.getParentFile());
                    InputStream zipIn = null;
                    try {
                        zipIn = zf.getInputStream(entry);
                        FilterOutputStream fileOut = null;
                        try {
                            fileOut = new BufferedOutputStream(new FileOutputStream(out));
                            Bootstrap.copyStream(zipIn, fileOut, false, false);
                        }
                        finally {
                            fileOut.close();
                        }
                    }
                    finally {
                        zipIn.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error extracting archive", e);
                    return;
                }
            }
        }
        finally {
            zf.close();
        }
    }

    private static String stripRoot(String name) {
        int p = name.indexOf(47);
        if (p > 0) {
            name = name.substring(p + 1);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream in, OutputStream out, boolean closeIn, boolean closeOut) throws IOException {
        try {
            Bootstrap.copyStreamNoClose(in, out);
        }
        finally {
            if (closeIn) {
                Bootstrap.safeClose(in);
            }
            if (closeOut) {
                Bootstrap.safeClose(out);
            }
        }
    }

    private static void copyStreamNoClose(InputStream in, OutputStream out) throws IOException {
        int cnt;
        byte[] bytes = new byte[8192];
        while ((cnt = in.read(bytes)) != -1) {
            out.write(bytes, 0, cnt);
        }
        out.flush();
    }

    private static void safeClose(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String hash(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] bytes = string.getBytes();
            messageDigest.update(bytes);
            return new BigInteger(1, messageDigest.digest()).toString(36);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating hash", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String calculateSha256Sum(File file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        InputStream fis = null;
        try {
            fis = new FileInputStream(file);
            int n = 0;
            byte[] buffer = new byte[4096];
            while (n != -1) {
                n = fis.read(buffer);
                if (n <= 0) continue;
                md.update(buffer, 0, n);
            }
            byte[] byteData = md.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < byteData.length; ++i) {
                String hex = Integer.toHexString(0xFF & byteData[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            String string = hexString.toString();
            return string;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(URI uri, File file, ProgressMonitor progress) throws IOException {
        URLConnection connection = null;
        InputStream input = null;
        OutputStream output = null;
        try {
            int n;
            URL url = uri.toURL();
            connection = url.openConnection();
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(30000);
            input = connection.getInputStream();
            output = new FileOutputStream(file);
            long read = 0L;
            long size = connection.getContentLength();
            byte[] buffer = new byte[4096];
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
                read += (long)n;
                if (progress == null) continue;
                progress.update(read, size);
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }

    private static void setupProxyAuthentication() {
        if (System.getProperty("http.proxyUser") != null) {
            Authenticator.setDefault(new ProxyAuthenticator());
        }
    }

    private static File determineDistLanguage(File distHome) {
        File distRepo = new File(distHome, "repo");
        File bootstrap = new File(new File(distRepo, "ceylon"), "language");
        File[] versions = bootstrap.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (versions == null || versions.length != 1) {
            return null;
        }
        return versions[0];
    }

    private static String determineDistVersion() {
        File distHome = new File(System.getProperty("ceylon.home"));
        File versionDir = Bootstrap.determineDistLanguage(distHome);
        if (versionDir == null) {
            throw new RuntimeException("Error in distribution: missing bootstrap in " + distHome.getAbsolutePath());
        }
        return versionDir.getName();
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private ProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword", "").toCharArray());
        }
    }

    private static interface ProgressMonitor {
        public void update(long var1, long var3);
    }

    private static class Config {
        File properties;
        URI distribution;
        File installation;
        File resolvedInstallation;
        File distributionDir;
        String hash;
        String sha256sum;

        private Config() {
        }
    }
}

