/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.launcher;

import com.redhat.ceylon.launcher.CeylonClassLoader;
import com.redhat.ceylon.launcher.CeylonDebugEvaluationThread;
import com.redhat.ceylon.launcher.CeylonLogFormatter;
import com.redhat.ceylon.launcher.ClassLoaderSetupException;
import com.redhat.ceylon.launcher.Java7Checker;
import com.redhat.ceylon.launcher.LauncherUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Launcher {
    public static void main(String[] args) throws Throwable {
        int exit = Launcher.run(args);
        if (exit != 0) {
            System.exit(exit);
        }
    }

    public static int run(String ... args) throws Throwable {
        return Launcher.run(false, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(boolean cleanupClassLoader, String ... args) throws Throwable {
        Java7Checker.check();
        CeylonClassLoader loader = Launcher.getClassLoader();
        try {
            int n = Launcher.runInJava7Checked(loader, args);
            return n;
        }
        finally {
            if (cleanupClassLoader) {
                loader.clearCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runInJava7Checked(CeylonClassLoader loader, String ... args) throws Throwable {
        String ceylonSystemRepo;
        if (Boolean.getBoolean("ceylon.debug.startEvaluationThread")) {
            CeylonDebugEvaluationThread.startDebugEvaluationThread();
        }
        if ((ceylonSystemRepo = LauncherUtil.getArgument(args, "--sysrep", false)) != null) {
            System.setProperty("ceylon.system.repo", ceylonSystemRepo);
        }
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Integer result;
            Thread.currentThread().setContextClassLoader(loader);
            String cp = CeylonClassLoader.getClassPathAsString();
            System.setProperty("env.class.path", cp);
            String verbose = null;
            Class<?> mainClass = loader.loadClass("com.redhat.ceylon.common.tools.CeylonTool");
            Object mainTool = mainClass.newInstance();
            Method setupMethod = mainClass.getMethod("setup", args.getClass());
            try {
                result = (Integer)setupMethod.invoke(mainTool, new Object[]{args});
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            if (result == 0) {
                try {
                    Method toolGetter = mainClass.getMethod("getTools", new Class[0]);
                    Object[] tools = (Object[])toolGetter.invoke(mainTool, new Object[0]);
                    if (tools != null && tools.length > 0) {
                        Method verboseGetter = tools[0].getClass().getMethod("getVerbose", new Class[0]);
                        verbose = (String)verboseGetter.invoke(tools[0], new Object[0]);
                    }
                }
                catch (Exception toolGetter) {
                    // empty catch block
                }
                Launcher.initGlobalLogger(verbose);
                try {
                    if (Launcher.hasVerboseFlag(verbose, "loader")) {
                        Logger log = Logger.getLogger("com.redhat.ceylon.log.loader");
                        log.info("Current directory is '" + LauncherUtil.absoluteFile(new File(".")).getPath() + "'");
                        log.info("Ceylon home directory is '" + LauncherUtil.determineHome() + "'");
                        for (File f : CeylonClassLoader.getClassPath()) {
                            log.info("path = " + f + " (" + (f.exists() ? "OK" : "Not found!") + ")");
                        }
                    }
                    Method execMethod = mainClass.getMethod("execute", new Class[0]);
                    try {
                        result = (Integer)execMethod.invoke(mainTool, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
                finally {
                    LogManager.getLogManager().reset();
                }
            }
            int n = result;
            return n;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    public static CeylonClassLoader getClassLoader() throws ClassLoaderSetupException {
        try {
            CeylonClassLoader ceylonClassLoader = CeylonClassLoader.newInstance();
            Launcher.initGlobalProperties();
            return ceylonClassLoader;
        }
        catch (URISyntaxException e) {
            throw new ClassLoaderSetupException(e);
        }
        catch (MalformedURLException e) {
            throw new ClassLoaderSetupException(e);
        }
        catch (FileNotFoundException e) {
            throw new ClassLoaderSetupException(e);
        }
    }

    public static void initGlobalProperties() throws URISyntaxException {
        File ceylonHome = LauncherUtil.determineHome();
        Launcher.initGlobalProperties(ceylonHome);
    }

    public static void initGlobalProperties(File ceylonHome) throws URISyntaxException {
        System.setProperty("ceylon.home", ceylonHome.getAbsolutePath());
        System.setProperty("ceylon.system.repo", LauncherUtil.determineRepo(ceylonHome).getAbsolutePath());
        System.setProperty("ceylon.system.version", LauncherUtil.determineSystemVersion());
    }

    public static void initGlobalLogger(String verbose) {
        try {
            String logManager = System.getProperty("java.util.logging.manager");
            if (logManager == null) {
                System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
            }
            if (verbose != null) {
                String[] flags;
                for (String flag : flags = verbose.split(",")) {
                    if ("all".equals(flag = flag.trim()) || flag.isEmpty()) {
                        Launcher.initLogger(Logger.getLogger(""), true);
                        continue;
                    }
                    if (!flag.matches("^[a-z]+$")) continue;
                    Launcher.initLogger(Logger.getLogger("com.redhat.ceylon.log." + flag), true);
                }
            } else {
                Launcher.initLogger(Logger.getLogger(""), false);
            }
        }
        catch (Throwable ex) {
            System.err.println("Warning: log configuration failed: " + ex.getMessage());
        }
    }

    private static void initLogger(Logger logger, boolean verbose) {
        boolean handlersExists = false;
        for (Handler handler : logger.getHandlers()) {
            handlersExists = true;
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setFormatter(CeylonLogFormatter.INSTANCE);
            if (!verbose) continue;
            handler.setLevel(Level.ALL);
        }
        if (verbose) {
            logger.setLevel(Level.ALL);
            if (!handlersExists) {
                ConsoleHandler handler = new ConsoleHandler();
                handler.setFormatter(CeylonLogFormatter.INSTANCE);
                handler.setLevel(Level.ALL);
                logger.addHandler(handler);
            }
        }
    }

    private static boolean hasVerboseFlag(String verbose, String flag) {
        if (verbose == null) {
            return false;
        }
        if (verbose.isEmpty()) {
            return true;
        }
        List<String> lst = Arrays.asList(verbose.split(","));
        if (lst.contains("all")) {
            return true;
        }
        return lst.contains(flag);
    }
}

