/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.cmr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class JDKUtils {
    public static final JDK jdk;
    private static Map<String, Tuple> jdkModules;
    private static Map<String, Tuple> jdkOracleModules;
    private static HashMap<String, String> jdkPackageToModule;
    private static Map<String, String> java8To9ModuleAliases;

    private static synchronized void loadPackageList() {
        if (jdkModules != null) {
            return;
        }
        jdkModules = JDKUtils.loadModularPackageList(JDKUtils.jdk.packageList);
        jdkOracleModules = JDKUtils.loadModularPackageList(JDKUtils.jdk.packageListOracle);
        jdkPackageToModule = new HashMap();
        for (Map.Entry<String, Tuple> entry : jdkModules.entrySet()) {
            for (String pkg : entry.getValue().packages) {
                jdkPackageToModule.put(pkg, entry.getKey());
            }
        }
        for (Map.Entry<String, Tuple> entry : jdkOracleModules.entrySet()) {
            for (String pkg : entry.getValue().packages) {
                jdkPackageToModule.put(pkg, entry.getKey());
            }
        }
    }

    private static Map<String, Tuple> loadModularPackageList(String file) {
        try {
            String pkg;
            HashMap<String, Tuple> jdkPackages = new HashMap<String, Tuple>();
            InputStream inputStream = JDKUtils.class.getResourceAsStream(file);
            if (inputStream == null) {
                throw new RuntimeException("Failed to read JDK package list file from " + file + ": your Ceylon installation is broken.");
            }
            BufferedReader bis = new BufferedReader(new InputStreamReader(inputStream, "ASCII"));
            Tuple tuple = null;
            String moduleName = null;
            while ((pkg = bis.readLine()) != null) {
                int commentStart = pkg.indexOf(35);
                if (commentStart > -1) {
                    pkg = pkg.substring(0, commentStart);
                }
                if ((pkg = pkg.trim()).isEmpty()) continue;
                if (pkg.startsWith("=")) {
                    String name = pkg.substring(1).trim();
                    if (name.isEmpty()) {
                        throw new RuntimeException("Failed to read JDK module list file from " + file + ": module has empty name");
                    }
                    if (tuple != null) {
                        jdkPackages.put(moduleName, tuple.finish());
                    }
                    moduleName = name;
                    tuple = new Tuple();
                    continue;
                }
                if (tuple == null) {
                    throw new RuntimeException("Failed to read JDK module list file from " + file + ": adding package to undefined module");
                }
                tuple.packages.add(pkg);
                tuple.paths.add(pkg.replace('.', '/'));
            }
            bis.close();
            if (tuple != null) {
                jdkPackages.put(moduleName, tuple.finish());
            }
            if (jdkPackages.size() == 0) {
                throw new RuntimeException("Failed to read JDK package list file from " + file + "(empty package set): your Ceylon installation is broken.");
            }
            return Collections.unmodifiableMap(jdkPackages);
        }
        catch (IOException x) {
            throw new RuntimeException("Failed to read JDK package list file from " + file + ": your Ceylon installation is broken.", x);
        }
    }

    public static boolean isJDKModule(String mod) {
        JDKUtils.loadPackageList();
        return jdkModules.containsKey(mod);
    }

    public static boolean isJDKPackage(String mod, String pkg) {
        JDKUtils.loadPackageList();
        Tuple tuple = jdkModules.get(mod);
        return tuple != null && tuple.packages.contains(pkg);
    }

    public static boolean isJDKAnyPackage(String pkg) {
        JDKUtils.loadPackageList();
        for (Tuple tuple : jdkModules.values()) {
            if (!tuple.packages.contains(pkg)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getJDKModuleNames() {
        JDKUtils.loadPackageList();
        return jdkModules.keySet();
    }

    public static Set<String> getJDKPackagesByModule(String module) {
        JDKUtils.loadPackageList();
        Tuple tuple = jdkModules.get(module);
        return tuple != null ? tuple.packages : null;
    }

    public static Set<String> getJDKPathsByModule(String module) {
        JDKUtils.loadPackageList();
        Tuple tuple = jdkModules.get(module);
        return tuple != null ? tuple.paths : null;
    }

    public static boolean isOracleJDKModule(String pkg) {
        JDKUtils.loadPackageList();
        return jdkOracleModules.containsKey(pkg);
    }

    public static boolean isOracleJDKPackage(String mod, String pkg) {
        JDKUtils.loadPackageList();
        Tuple tuple = jdkOracleModules.get(mod);
        return tuple != null && tuple.packages.contains(pkg);
    }

    public static boolean isOracleJDKAnyPackage(String pkg) {
        JDKUtils.loadPackageList();
        for (Tuple tuple : jdkOracleModules.values()) {
            if (!tuple.packages.contains(pkg)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getOracleJDKModuleNames() {
        JDKUtils.loadPackageList();
        return jdkOracleModules.keySet();
    }

    public static Set<String> getOracleJDKPackagesByModule(String module) {
        JDKUtils.loadPackageList();
        Tuple tuple = jdkOracleModules.get(module);
        return tuple != null ? tuple.packages : null;
    }

    public static Set<String> getOracleJDKPathsByModule(String module) {
        JDKUtils.loadPackageList();
        Tuple tuple = jdkOracleModules.get(module);
        return tuple != null ? tuple.paths : null;
    }

    public static String getJDKModuleNameForPackage(String pkgName) {
        JDKUtils.loadPackageList();
        return jdkPackageToModule.get(pkgName);
    }

    public static void main(String[] args) throws IOException {
        JDKUtils.loadPackageList();
        TreeSet<String> modules = new TreeSet<String>();
        HashMap<String, String> renames = new HashMap<String, String>();
        for (String module : jdkModules.keySet()) {
            if (module.startsWith("javax.")) {
                String newName = "java." + module.substring(6);
                renames.put(newName, module);
                modules.add(newName);
                continue;
            }
            modules.add(module);
        }
        modules.addAll(jdkOracleModules.keySet());
        for (String module : modules) {
            System.err.println("=" + module);
            String realModuleName = module;
            if (renames.containsKey(module)) {
                realModuleName = (String)renames.get(module);
                System.err.println("# -> " + realModuleName);
            }
            TreeSet<String> packages = new TreeSet<String>();
            if (JDKUtils.isJDKModule(realModuleName)) {
                packages.addAll(JDKUtils.getJDKPackagesByModule(realModuleName));
            } else {
                packages.addAll(JDKUtils.getOracleJDKPackagesByModule(realModuleName));
            }
            for (String pkg : packages) {
                System.err.println(pkg);
            }
            System.err.println();
        }
    }

    public static String getJava9ModuleNameFromEarlier(String name) {
        return java8To9ModuleAliases.get(name);
    }

    public static String getJava9ModuleName(String name, String version2) {
        String alias;
        if (JDK.JDK9.isLowerVersion(version2) && (alias = JDKUtils.getJava9ModuleNameFromEarlier(name)) != null) {
            return alias;
        }
        return name;
    }

    static {
        String version2 = System.getProperty("java.version");
        jdk = version2 != null ? (version2.startsWith("1.9") ? JDK.JDK9 : (version2.startsWith("1.8") ? JDK.JDK8 : JDK.JDK7)) : JDK.JDK7;
        java8To9ModuleAliases = new HashMap<String, String>();
        java8To9ModuleAliases.put("javax.annotation", "java.annotation.common");
        java8To9ModuleAliases.put("java.auth", "java.security.sasl");
        java8To9ModuleAliases.put("java.auth.kerberos", "java.security.jgss");
        java8To9ModuleAliases.put("java.jdbc", "java.sql");
        java8To9ModuleAliases.put("java.jdbc.rowset", "java.sql.rowset");
        java8To9ModuleAliases.put("javax.script", "java.scripting");
        java8To9ModuleAliases.put("javax.xml", "java.xml");
        java8To9ModuleAliases.put("javax.xmldsig", "java.xml.crypto");
    }

    private static class Tuple {
        private Set<String> packages = new HashSet<String>();
        private Set<String> paths = new HashSet<String>();

        private Tuple() {
        }

        boolean isEmpty() {
            return this.packages.isEmpty();
        }

        Tuple finish() {
            this.packages = Collections.unmodifiableSet(this.packages);
            this.paths = Collections.unmodifiableSet(this.paths);
            return this;
        }
    }

    public static enum JDK {
        JDK7("package-list.jdk7", "package-list.oracle.jdk7", "7"),
        JDK8("package-list.jdk8", "package-list.oracle.jdk8", "8"),
        JDK9("package-list.jdk9", "package-list.oracle.jdk9", "9");

        public final String packageList;
        public final String packageListOracle;
        public final String version;

        private JDK(String packageList, String packageListOracle, String version2) {
            this.packageList = packageList;
            this.packageListOracle = packageListOracle;
            this.version = version2;
        }

        public boolean providesVersion(String version2) {
            if (this.version.equals(version2)) {
                return true;
            }
            EnumSet<JDK> smaller = EnumSet.range(JDK7, this);
            smaller.remove((Object)this);
            for (JDK smallerJDK : smaller) {
                if (!smallerJDK.version.equals(version2)) continue;
                return true;
            }
            return false;
        }

        public boolean isLowerVersion(String version2) {
            EnumSet<JDK> smaller = EnumSet.range(JDK7, this);
            smaller.remove((Object)this);
            for (JDK smallerJDK : smaller) {
                if (!smallerJDK.version.equals(version2)) continue;
                return true;
            }
            return false;
        }
    }
}

