/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import com.redhat.ceylon.common.BooleanUtil;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.loader.mirror.AnnotatedMirror;
import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassAlias;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Specification;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.List;
import java.util.Map;

public class JvmBackendUtil {
    public static boolean isInitialLowerCase(String name) {
        return !name.isEmpty() && JvmBackendUtil.isLowerCase(name.codePointAt(0));
    }

    public static boolean isLowerCase(int codepoint) {
        return Character.isLowerCase(codepoint) || codepoint == 95;
    }

    public static String getName(List<String> parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            sb.append(parts.get(i));
            if (i >= parts.size() - 1) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    public static String getMirrorName(AnnotatedMirror mirror) {
        String name;
        AnnotationMirror annot = mirror.getAnnotation("com.redhat.ceylon.compiler.java.metadata.Name");
        if (annot != null) {
            name = (String)annot.getValue();
        } else {
            name = mirror.getName();
            String string = name = name.isEmpty() ? name : NamingBase.stripLeadingDollar(name);
            if (mirror instanceof ClassMirror && JvmBackendUtil.isInitialLowerCase(name) && name.endsWith("_") && mirror.getAnnotation("com.redhat.ceylon.compiler.java.metadata.Ceylon") != null) {
                name = name.substring(0, name.length() - 1);
            }
        }
        return name;
    }

    public static boolean isSubPackage(String moduleName, String pkgName) {
        return pkgName.equals(moduleName) || pkgName.startsWith(moduleName + ".");
    }

    public static String removeChar(char c, String string) {
        int nextChar = string.indexOf(c);
        if (nextChar == -1) {
            return string;
        }
        int start = 0;
        StringBuilder ret = new StringBuilder(string.length() - 1);
        while (nextChar != -1) {
            ret.append(string, start, nextChar);
            start = nextChar + 1;
            nextChar = string.indexOf(c, start);
        }
        ret.append(string, start, string.length());
        return ret.toString();
    }

    public static String strip(String name, boolean isCeylon, boolean isShared) {
        String stripped = NamingBase.stripLeadingDollar(name);
        String privSuffix = NamingBase.Suffix.$priv$.name();
        if (isCeylon && !isShared && name.endsWith(privSuffix)) {
            return stripped.substring(0, stripped.length() - privSuffix.length());
        }
        return stripped;
    }

    public static boolean isValue(Declaration decl) {
        return decl instanceof Value && !((Value)decl).isParameter() && !((Value)decl).isTransient();
    }

    public static boolean isMethod(Declaration decl) {
        return decl instanceof Function && !((Function)decl).isParameter();
    }

    public static boolean isCeylon(TypeDeclaration declaration) {
        return ModelUtil.isCeylonDeclaration(declaration);
    }

    public static Declaration getTopmostRefinedDeclaration(Declaration decl) {
        return JvmBackendUtil.getTopmostRefinedDeclaration(decl, null);
    }

    public static Declaration getTopmostRefinedDeclaration(Declaration decl, Map<Function, Function> methodOverrides) {
        Declaration refinedDecl;
        if (decl instanceof FunctionOrValue && ((FunctionOrValue)decl).isParameter() && decl.getContainer() instanceof Class) {
            Declaration refinedDecl2;
            Class c = (Class)decl.getContainer();
            boolean isAlias = c.isAlias();
            boolean isActual = c.isActual();
            if (isAlias || isActual) {
                Class ctor = null;
                int index = c.getParameterList().getParameters().indexOf(JvmBackendUtil.findParamForDecl((TypedDeclaration)decl));
                while (isAlias && c.isAlias() || isActual && c.isActual()) {
                    ctor = isAlias && c.isAlias() ? (Functional)((Object)((ClassAlias)c).getConstructor()) : c;
                    Type et = c.getExtendedType();
                    if ((c = et != null && et.isClass() ? (Class)et.getDeclaration() : null) != null) continue;
                    return null;
                }
                if (isActual) {
                    ctor = c;
                }
                if (ctor == null || ctor.getParameterLists() == null || ctor.getParameterLists().isEmpty() || ctor.getFirstParameterList() == null || ctor.getFirstParameterList().getParameters() == null || ctor.getFirstParameterList().getParameters().size() <= index) {
                    return null;
                }
                decl = ctor.getFirstParameterList().getParameters().get(index).getModel();
            }
            if (decl.isShared() && (refinedDecl2 = c.getRefinedMember(decl.getName(), ModelUtil.getSignature(decl), false)) != null && !ModelUtil.equal(refinedDecl2, decl)) {
                return JvmBackendUtil.getTopmostRefinedDeclaration(refinedDecl2, methodOverrides);
            }
            return decl;
        }
        if (decl instanceof FunctionOrValue && ((FunctionOrValue)decl).isParameter() && (decl.getContainer() instanceof Function && !((Function)decl.getContainer()).isParameter() || decl.getContainer() instanceof Specification || decl.getContainer() instanceof Function && ((Function)decl.getContainer()).isParameter() && JvmBackendUtil.createMethod((Function)decl.getContainer()))) {
            Functional func = (Functional)((Object)JvmBackendUtil.getParameterized((FunctionOrValue)decl));
            if (func == null) {
                return decl;
            }
            Declaration kk = JvmBackendUtil.getTopmostRefinedDeclaration((Declaration)((Object)func), methodOverrides);
            if (!(kk instanceof Functional)) {
                return decl;
            }
            Functional refinedFunc = (Functional)((Object)kk);
            if (ModelUtil.equal((Declaration)((Object)refinedFunc), (Declaration)((Object)func))) {
                return decl;
            }
            if (func.getParameterLists().size() != refinedFunc.getParameterLists().size()) {
                return decl;
            }
            for (int ii = 0; ii < func.getParameterLists().size(); ++ii) {
                if (func.getParameterLists().get(ii).getParameters().size() != refinedFunc.getParameterLists().get(ii).getParameters().size()) {
                    return decl;
                }
                int index = 0;
                for (Parameter px : func.getParameterLists().get(ii).getParameters()) {
                    if (px.getModel() == null || px.getModel().equals(decl)) {
                        return refinedFunc.getParameterLists().get(ii).getParameters().get(index).getModel();
                    }
                    ++index;
                }
            }
        } else if (methodOverrides != null && decl instanceof Function && ModelUtil.equal(decl.getRefinedDeclaration(), decl) && decl.getContainer() instanceof Specification && ((Specification)decl.getContainer()).getDeclaration() instanceof Function && ((Function)((Specification)decl.getContainer()).getDeclaration()).isShortcutRefinement() && methodOverrides.containsKey(decl)) {
            decl = methodOverrides.get(decl);
        }
        if ((refinedDecl = decl.getRefinedDeclaration()) != null && !ModelUtil.equal(refinedDecl, decl)) {
            return JvmBackendUtil.getTopmostRefinedDeclaration(refinedDecl);
        }
        return decl;
    }

    public static Parameter findParamForDecl(TypedDeclaration decl) {
        String attrName = decl.getName();
        return JvmBackendUtil.findParamForDecl(attrName, decl);
    }

    public static Parameter findParamForDecl(String attrName, TypedDeclaration decl) {
        Parameter result = null;
        if (decl.getContainer() instanceof Functional) {
            Functional f = (Functional)((Object)decl.getContainer());
            result = f.getParameter(attrName);
        }
        return result;
    }

    public static Declaration getParameterized(FunctionOrValue methodOrValue) {
        if (!methodOrValue.isParameter()) {
            return null;
        }
        Scope scope = methodOrValue.getContainer();
        if (scope instanceof Specification) {
            return ((Specification)scope).getDeclaration();
        }
        if (scope instanceof Declaration) {
            return (Declaration)((Object)scope);
        }
        return null;
    }

    public static boolean createMethod(FunctionOrValue model) {
        return model instanceof Function && model.isParameter() && model.isClassMember() && (model.isShared() || model.isCaptured());
    }

    public static boolean supportsReified(Declaration declaration) {
        if (declaration instanceof ClassOrInterface) {
            return JvmBackendUtil.isCeylon((TypeDeclaration)declaration);
        }
        if (declaration instanceof Function) {
            if (((Function)declaration).isParameter()) {
                return false;
            }
            if (declaration.isToplevel()) {
                return true;
            }
            Function m = (Function)JvmBackendUtil.getTopmostRefinedDeclaration(declaration);
            ClassOrInterface container = ModelUtil.getClassOrInterfaceContainer(m);
            if (container == null) {
                return true;
            }
            return JvmBackendUtil.supportsReified(container);
        }
        if (declaration instanceof Constructor) {
            return JvmBackendUtil.isCeylon((Constructor)declaration);
        }
        return false;
    }

    public static boolean isCompanionClassNeeded(TypeDeclaration decl) {
        return decl instanceof Interface && BooleanUtil.isNotFalse(((Interface)decl).isCompanionClassNeeded());
    }

    public static boolean isBoxedVariable(TypedDeclaration attr) {
        return ModelUtil.isNonTransientValue(attr) && ModelUtil.isLocalNotInitializer(attr) && (attr.isVariable() && attr.isCaptured() || attr.isSelfCaptured());
    }

    private static String getArrayName(TypeDeclaration decl) {
        if (!(decl instanceof Class)) {
            return null;
        }
        return decl.getQualifiedNameString();
    }

    public static boolean isJavaArray(TypeDeclaration decl) {
        String name = JvmBackendUtil.getArrayName(decl);
        return "java.lang::ObjectArray".equals(name) || "java.lang::ByteArray".equals(name) || "java.lang::ShortArray".equals(name) || "java.lang::IntArray".equals(name) || "java.lang::LongArray".equals(name) || "java.lang::FloatArray".equals(name) || "java.lang::DoubleArray".equals(name) || "java.lang::BooleanArray".equals(name) || "java.lang::CharArray".equals(name);
    }

    public static boolean isJavaBooleanArray(TypeDeclaration decl) {
        return "java.lang::BooleanArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaByteArray(TypeDeclaration decl) {
        return "java.lang::ByteArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaShortArray(TypeDeclaration decl) {
        return "java.lang::ShortArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaIntArray(TypeDeclaration decl) {
        return "java.lang::IntArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaLongArray(TypeDeclaration decl) {
        return "java.lang::LongArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaFloatArray(TypeDeclaration decl) {
        return "java.lang::FloatArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaDoubleArray(TypeDeclaration decl) {
        return "java.lang::DoubleArray".equals(JvmBackendUtil.getArrayName(decl));
    }

    public static boolean isJavaCharArray(TypeDeclaration decl) {
        return "java.lang::CharArray".equals(JvmBackendUtil.getArrayName(decl));
    }
}

