/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum LanguageAnnotation {
    ANNOTATION("annotation", 1L, "ceylon.language.AnnotationAnnotation$annotation$"),
    SHARED("shared", 2L, "ceylon.language.SharedAnnotation$annotation$"),
    VARIABLE("variable", 4L, "ceylon.language.VariableAnnotation$annotation$"),
    ABSTRACT("abstract", 8L, "ceylon.language.AbstractAnnotation$annotation$"),
    SEALED("sealed", 16L, "ceylon.language.SealedAnnotation$annotation$"),
    FINAL("final", 32L, "ceylon.language.FinalAnnotation$annotation$"),
    ACTUAL("actual", 64L, "ceylon.language.ActualAnnotation$annotation$"),
    FORMAL("formal", 128L, "ceylon.language.FormalAnnotation$annotation$"),
    DEFAULT("default", 256L, "ceylon.language.DefaultAnnotation$annotation$"),
    LATE("late", 512L, "ceylon.language.LateAnnotation$annotation$"),
    OPTIONAL("optional", 2048L, "ceylon.language.OptionalAnnotation$annotation$"),
    SERIALIZABLE("serializable", 4096L, "ceylon.language.SerializableAnnotation$annotation$"),
    DOC("doc", 0L, "ceylon.language.DocAnnotation$annotation$"){

        @Override
        public List<Annotation> makeFromCeylonAnnotation(AnnotationMirror mirror) {
            Annotation anno = new Annotation(this.name);
            anno.addPositionalArgment((String)mirror.getValue("description"));
            return Collections.singletonList(anno);
        }
    }
    ,
    THROWS("throws", 0L, "ceylon.language.ThrownExceptionAnnotation$annotations$"){

        @Override
        public List<Annotation> makeFromCeylonAnnotation(AnnotationMirror mirror) {
            List thrownExceptions = (List)mirror.getValue("value");
            ArrayList<Annotation> result = new ArrayList<Annotation>(thrownExceptions.size());
            for (AnnotationMirror thrown : thrownExceptions) {
                Annotation anno = new Annotation(this.name);
                anno.addPositionalArgment(this.parseMetamodelReference((String)thrown.getValue("type")));
                anno.addPositionalArgment((String)thrown.getValue("when"));
                result.add(anno);
            }
            return result;
        }
    }
    ,
    BY("by", 0L, "ceylon.language.AuthorsAnnotation$annotation$"){

        @Override
        public List<Annotation> makeFromCeylonAnnotation(AnnotationMirror mirror) {
            Annotation anno = new Annotation(this.name);
            List authors = (List)mirror.getValue("authors");
            for (String author : authors) {
                anno.addPositionalArgment(author);
            }
            return Collections.singletonList(anno);
        }
    }
    ,
    NATIVE("native", 0L, "ceylon.language.NativeAnnotation$annotation$"){

        @Override
        public List<Annotation> makeFromCeylonAnnotation(AnnotationMirror mirror) {
            Annotation anno = new Annotation(this.name);
            List backends = (List)mirror.getValue("backends");
            if (backends != null) {
                for (String backend : backends) {
                    anno.addPositionalArgment(backend);
                }
            }
            return Collections.singletonList(anno);
        }
    }
    ,
    SEE("see", 0L, "ceylon.language.SeeAnnotation$annotations$"){

        @Override
        public List<Annotation> makeFromCeylonAnnotation(AnnotationMirror mirror) {
            List sees = (List)mirror.getValue("value");
            ArrayList<Annotation> result = new ArrayList<Annotation>(sees.size());
            for (AnnotationMirror see : sees) {
                Annotation anno = new Annotation(this.name);
                List elements = (List)see.getValue("programElements");
                for (String s : elements) {
                    anno.addPositionalArgment(this.parseMetamodelReference(s));
                }
                result.add(anno);
            }
            return result;
        }
    }
    ,
    LICENSE("license", 0L, "ceylon.language.LicenseAnnotation$annotation$"){

        @Override
        public List<Annotation> makeFromCeylonAnnotation(AnnotationMirror mirror) {
            Annotation anno = new Annotation(this.name);
            anno.addPositionalArgment((String)mirror.getValue("description"));
            return Collections.singletonList(anno);
        }
    }
    ,
    DEPRECATED("deprecated", 0L, "ceylon.language.DeprecationAnnotation$annotation$"){

        @Override
        public List<Annotation> makeFromCeylonAnnotation(AnnotationMirror mirror) {
            Annotation anno = new Annotation(this.name);
            anno.addPositionalArgment((String)mirror.getValue("description"));
            return Collections.singletonList(anno);
        }
    }
    ,
    TAGGED("tagged", 0L, "ceylon.language.TagsAnnotation$annotation$"){

        @Override
        public List<Annotation> makeFromCeylonAnnotation(AnnotationMirror mirror) {
            Annotation anno = new Annotation(this.name);
            List tags = (List)mirror.getValue("tags");
            for (String tag : tags) {
                anno.addPositionalArgment(tag);
            }
            return Collections.singletonList(anno);
        }
    }
    ,
    SUPPRESS_WARNINGS("suppressWarnings", 0L, "ceylon.language.SuppressWarningsAnnotation$annotation$"){

        @Override
        public List<Annotation> makeFromCeylonAnnotation(AnnotationMirror mirror) {
            Annotation anno = new Annotation(this.name);
            List warnings = (List)mirror.getValue("warnings");
            for (String tag : warnings) {
                anno.addPositionalArgment(tag);
            }
            return Collections.singletonList(anno);
        }
    }
    ,
    ALIASES("aliased", 0L, "ceylon.language.AliasesAnnotation$annotation$"){

        @Override
        public List<Annotation> makeFromCeylonAnnotation(AnnotationMirror mirror) {
            Annotation anno = new Annotation(this.name);
            List aliases = (List)mirror.getValue("aliases");
            for (String alias : aliases) {
                anno.addPositionalArgment(alias);
            }
            return Collections.singletonList(anno);
        }
    };

    public final String name;
    public final long mask;
    public final String annotationType;

    private LanguageAnnotation(String name, long mask, String annotationType) {
        this.name = name;
        this.mask = mask;
        this.annotationType = annotationType;
    }

    public boolean isModifier() {
        return this.mask != 0L;
    }

    public List<Annotation> makeFromCeylonAnnotation(AnnotationMirror mirror) {
        return Collections.singletonList(new Annotation(this.name));
    }

    protected String parseMetamodelReference(String s) {
        return s.replaceAll("^.*::[CIAVFP]", "").replaceAll("^.*\\.[CIAVFP]", "");
    }
}

