/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class OsgiUtil {

    public static class OsgiManifest
    extends CeylonManifest {
        public static final Attributes.Name Bundle_SymbolicName = new Attributes.Name("Bundle-SymbolicName");
        public static final Attributes.Name Bundle_Version = new Attributes.Name("Bundle-Version");
        public static final Attributes.Name Bundle_ManifestVersion = new Attributes.Name("Bundle-ManifestVersion");
        public static final Attributes.Name Export_Package = new Attributes.Name("Export-Package");
        public static final Attributes.Name Require_Bundle = new Attributes.Name("Require-Bundle");
        public static final Attributes.Name Bundle_RequiredExecutionEnvironment = new Attributes.Name("Bundle-RequiredExecutionEnvironment");
        public static final Attributes.Name Require_Capability = new Attributes.Name("Require-Capability");
        public static final Attributes.Name Bundle_ActivationPolicy = new Attributes.Name("Bundle-ActivationPolicy");
        public static final Attributes.Name Bundle_Activator = new Attributes.Name("Bundle-Activator");
        private static SimpleDateFormat formatter = new SimpleDateFormat("'v'yyyyMMdd-HHmm");
        private String osgiProvidedBundles;
        private final Manifest originalManifest;
        private final Module module;
        private Logger log;

        public OsgiManifest(Module module, String osgiProvidedBundles) {
            this(module, null, osgiProvidedBundles, null);
        }

        public OsgiManifest(Module module, Manifest originalManifest, String osgiProvidedBundles, Logger log) {
            this.module = module;
            this.originalManifest = originalManifest;
            this.osgiProvidedBundles = osgiProvidedBundles;
            this.log = log;
        }

        private String toOSGIBundleVersion(String ceylonVersion) {
            String[] versionParts = ceylonVersion.split("\\.");
            String major = "";
            String minor = "";
            String micro = "";
            String qualifier = "";
            for (String part : versionParts) {
                if (major.isEmpty()) {
                    major = part;
                    continue;
                }
                if (minor.isEmpty()) {
                    minor = part;
                    continue;
                }
                if (micro.isEmpty()) {
                    micro = part;
                    continue;
                }
                qualifier = part + "_";
            }
            qualifier = qualifier + formatter.format(new Date());
            return major + '.' + minor + '.' + micro + '.' + qualifier;
        }

        @Override
        public Manifest build() {
            String requireBundleValue;
            Manifest manifest = super.build();
            Attributes main = manifest.getMainAttributes();
            main.put(Bundle_ManifestVersion, "2");
            main.put(Bundle_SymbolicName, this.module.getNameAsString());
            main.put(Bundle_Version, this.toOSGIBundleVersion(this.module.getVersion()));
            String exportPackageValue = this.getExportPackage();
            if (exportPackageValue.length() > 0) {
                main.put(Export_Package, exportPackageValue);
            }
            if ((requireBundleValue = this.getRequireBundle()).length() > 0) {
                main.put(Require_Bundle, requireBundleValue);
            }
            this.applyActivationPolicyNonLazy(main);
            this.appendOriginalManifest(manifest, main);
            if (!this.isJavaCapabilityRequired(main)) {
                this.applyRequireJavaCapability(main);
            }
            return manifest;
        }

        private boolean isLanguageModule() {
            return this.module.equals(this.module.getLanguageModule());
        }

        private boolean isJavaCapabilityRequired(Attributes main) {
            return main.containsKey(Bundle_RequiredExecutionEnvironment) || main.containsKey(Require_Capability);
        }

        private void applyRequireJavaCapability(Attributes main) {
            if (this.isLanguageModule()) {
                main.put(Require_Capability, this.getRequireCapabilityJavaSE("7"));
                return;
            }
            for (ModuleImport moduleImport : this.module.getImports()) {
                Module importedModule = moduleImport.getModule();
                if (!JDKUtils.isJDKModule(importedModule.getNameAsString())) continue;
                main.put(Require_Capability, this.getRequireCapabilityJavaSE("7"));
                break;
            }
        }

        private String getRequireCapabilityJavaSE(String version2) {
            return "osgi.ee;" + "filter:=" + '\"' + "(&" + "(osgi.ee=JavaSE)" + "(version>=" + this.getJavaVersion(version2) + ")" + ")" + '\"';
        }

        private void applyActivationPolicyNonLazy(Attributes main) {
            main.put(Bundle_ActivationPolicy, "lazy;exclude:=\"*\"");
        }

        private void appendOriginalManifest(Manifest manifest, Attributes main) {
            if (this.originalManifest != null) {
                Attributes attributes = this.originalManifest.getMainAttributes();
                for (Object key : attributes.keySet()) {
                    Object newValue;
                    Object oldValue;
                    if (!main.containsKey(key)) {
                        main.put(key, attributes.get(key));
                        continue;
                    }
                    if (this.log == null || Objects.equals(oldValue = main.get(key), newValue = attributes.get(key))) continue;
                    this.log.warning("manifest attribute provided by compiler: ignoring value from '" + key + "' for module '" + this.module.getNameAsString() + "'");
                }
                manifest.getEntries().putAll(this.originalManifest.getEntries());
            }
        }

        private String getJavaVersion(String jvmVersion) {
            return "1." + jvmVersion;
        }

        private String getRequireBundle() {
            List<String> providedBundles = null;
            if (this.osgiProvidedBundles != null && !this.osgiProvidedBundles.isEmpty()) {
                providedBundles = Arrays.asList(this.osgiProvidedBundles.split("(,| )+"));
            }
            StringBuilder requires = new StringBuilder();
            boolean distImportAlreadyFound = false;
            for (ModuleImport anImport : this.module.getImports()) {
                if (!ModelUtil.isForBackend(anImport.getNativeBackends(), Backend.Java)) continue;
                Module m = anImport.getModule();
                String moduleName = m.getNameAsString();
                if (providedBundles != null && providedBundles.contains(moduleName)) continue;
                if ("com.redhat.ceylon.dist".equals(moduleName)) {
                    distImportAlreadyFound = true;
                }
                if (JDKUtils.isJDKModule(moduleName) || JDKUtils.isOracleJDKModule(moduleName) || m.equals(this.module)) continue;
                if (requires.length() > 0) {
                    requires.append(",");
                }
                requires.append(m.getNameAsString()).append(";bundle-version=").append(m.getVersion());
                if (anImport.isExport()) {
                    requires.append(";visibility:=reexport");
                }
                if (!anImport.isOptional()) continue;
                requires.append(";resolution:=optional");
            }
            if (!distImportAlreadyFound) {
                if (requires.length() > 0) {
                    requires.append(",");
                }
                requires.append("com.redhat.ceylon.dist").append(";bundle-version=").append(this.module.getLanguageModule().getVersion()).append(";visibility:=reexport");
            }
            return requires.toString();
        }

        private String getExportPackage() {
            boolean alreadyOne = false;
            StringBuilder exportPackage = new StringBuilder();
            for (Package pkg : this.module.getPackages()) {
                if (!pkg.isShared() && !this.isLanguageModule()) continue;
                if (alreadyOne) {
                    exportPackage.append(",");
                }
                exportPackage.append(pkg.getNameAsString());
                exportPackage.append(";version=").append(this.module.getVersion());
                alreadyOne = true;
            }
            if (this.isLanguageModule()) {
                if (alreadyOne) {
                    exportPackage.append(",");
                }
                exportPackage.append("com.redhat.ceylon.dist.osgi");
                exportPackage.append(";version=").append(this.module.getVersion());
            }
            return exportPackage.toString();
        }

        static {
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    public static class DefaultModuleManifest
    extends CeylonManifest {
        public static final Attributes.Name Ceylon_Default_Module = new Attributes.Name("Ceylon-Default-Module");

        public static boolean isDefaultModule(Manifest manifest) {
            return "true".equals(manifest.getMainAttributes().get(Ceylon_Default_Module));
        }

        @Override
        public Manifest build() {
            Manifest manifest = super.build();
            Attributes main = manifest.getMainAttributes();
            main.put(Ceylon_Default_Module, "true");
            return manifest;
        }
    }

    public static abstract class CeylonManifest {
        public static final String MANIFEST_FILE_NAME = "META-INF/MANIFEST.MF";

        public static boolean isManifestFileName(String fileName) {
            return MANIFEST_FILE_NAME.equalsIgnoreCase(fileName);
        }

        public Manifest build() {
            Manifest manifest = new Manifest();
            Attributes main = manifest.getMainAttributes();
            main.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            return manifest;
        }
    }
}

