/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import com.redhat.ceylon.model.loader.ParameterNameParserException;

class ParameterNameLexer {
    public static final int COMMA = 0;
    public static final int LEFT_PAREN = 1;
    public static final int RIGHT_PAREN = 2;
    public static final int IDENT = 3;
    public static final int PLUS = 4;
    public static final int STAR = 5;
    public static final int BANG = 6;
    public static final int EOI = 7;
    String input;
    int index = 0;
    int mark = -1;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.input).append(System.lineSeparator());
        for (int ii = 0; ii < this.index; ++ii) {
            sb.append(' ');
        }
        sb.append('^');
        return sb.toString();
    }

    public void setup(String input) {
        this.input = input;
        this.index = 0;
    }

    private int peek() {
        int token;
        if (this.index >= this.input.length()) {
            return 7;
        }
        int c = this.input.codePointAt(this.index);
        switch (c) {
            case 40: {
                token = 1;
                break;
            }
            case 41: {
                token = 2;
                break;
            }
            case 44: {
                token = 0;
                break;
            }
            case 43: {
                token = 4;
                break;
            }
            case 42: {
                token = 5;
                break;
            }
            case 33: {
                token = 6;
                break;
            }
            default: {
                if (this.isIdentifierPart(c)) {
                    token = 3;
                    break;
                }
                throw new ParameterNameParserException("Unknown codepoint=" + c + "\n" + this);
            }
        }
        return token;
    }

    private boolean isIdentifierPart(int codepoint) {
        return Character.isLowerCase(codepoint) || Character.isUpperCase(codepoint) || Character.isDigit(codepoint) || codepoint == 95;
    }

    public void eat() {
        int token = this.peek();
        switch (token) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                ++this.index;
                return;
            }
            case 3: {
                this.index += Character.charCount(this.input.codePointAt(this.index));
                int c = this.input.codePointAt(this.index);
                while (this.index < this.input.length() && this.isIdentifierPart(c)) {
                    this.index += Character.charCount(this.input.codePointAt(this.index));
                    c = this.input.codePointAt(this.index);
                }
                return;
            }
            case 7: {
                return;
            }
        }
        throw new ParameterNameParserException("Unknown token=" + token + "\n" + this);
    }

    public String eatIdentifier() {
        int index = this.index;
        this.eat(3);
        return this.input.substring(index, this.index);
    }

    public void eat(int token) {
        if (!this.lookingAt(token)) {
            throw new ParameterNameParserException("Missing expected token: " + this.tokenToString(token) + System.lineSeparator() + this);
        }
        this.eat();
    }

    private String tokenToString(int token) {
        switch (token) {
            case 0: {
                return "COMMA";
            }
            case 3: {
                return "IDENT";
            }
            case 1: {
                return "LEFT_PAREN";
            }
            case 2: {
                return "RIGHT_PAREN";
            }
            case 7: {
                return "EOI";
            }
            case 4: {
                return "PLUS";
            }
            case 5: {
                return "STAR";
            }
            case 6: {
                return "BANG";
            }
        }
        throw new ParameterNameParserException("Unknown token " + token);
    }

    public boolean lookingAt(int token) {
        return this.peek() == token;
    }
}

