/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.ParameterNameLexer;
import com.redhat.ceylon.model.loader.ParameterNameParserException;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ParameterNameParser {
    private final ParameterNameLexer lexer = new ParameterNameLexer();
    private final AbstractModelLoader loader;
    private Unit unit;

    ParameterNameParser(AbstractModelLoader loader) {
        this.loader = loader;
    }

    public void parse(String input, Type type, Function method) {
        this.lexer.setup(input);
        this.unit = method.getUnit();
        boolean declaredVoid = false;
        ArrayList<ParameterList> lists = new ArrayList<ParameterList>();
        if (this.lexer.lookingAt(6)) {
            this.lexer.eat();
            declaredVoid = true;
        }
        lists.add(this.parseNameList(type, method));
        while (this.lexer.lookingAt(1)) {
            type = this.loader.getSimpleCallableReturnType(type);
            lists.add(this.parseNameList(type, method));
        }
        for (ParameterList parameterList : lists) {
            method.addParameterList(parameterList);
        }
        method.setDeclaredVoid(declaredVoid);
        method.setType(this.loader.getSimpleCallableReturnType(type));
        if (!this.lexer.lookingAt(7)) {
            throw new ParameterNameParserException("Expected end of input" + System.lineSeparator() + input);
        }
    }

    public void parseMpl(String input, Type type, Function method) {
        this.lexer.setup(input);
        this.unit = method.getUnit();
        ArrayList<ParameterList> lists = new ArrayList<ParameterList>();
        lists.add(this.parseNameList(type, method));
        while (this.lexer.lookingAt(1)) {
            type = this.loader.getSimpleCallableReturnType(type);
            lists.add(this.parseNameList(type, method));
        }
        for (ParameterList parameterList : lists) {
            method.addParameterList(parameterList);
        }
        method.setType(this.loader.getSimpleCallableReturnType(type));
        if (!this.lexer.lookingAt(7)) {
            throw new ParameterNameParserException("Expected end of input" + System.lineSeparator() + input);
        }
    }

    private ParameterList parseNameList(Type type, Function method) {
        ParameterList pl = new ParameterList();
        List<Parameter> parameters = pl.getParameters();
        this.lexer.eat(1);
        if (!this.lexer.lookingAt(2)) {
            Iterator<Type> ct = this.loader.getSimpleCallableArgumentTypes(type).iterator();
            if (!ct.hasNext()) {
                throw new ParameterNameParserException("Too few parameter types");
            }
            parameters.add(this.parseName(ct.next(), method));
            while (this.lexer.lookingAt(0)) {
                this.lexer.eat();
                if (!ct.hasNext()) {
                    throw new ParameterNameParserException("Too few parameter types");
                }
                parameters.add(this.parseName(ct.next(), method));
            }
            if (ct.hasNext()) {
                throw new ParameterNameParserException("Too many parameter types");
            }
        }
        this.lexer.eat(2);
        return pl;
    }

    private Parameter parseName(Type type, Function container) {
        FunctionOrValue result;
        String identifier = this.lexer.eatIdentifier();
        boolean declaredVoid = false;
        boolean sequenced = false;
        boolean atLeastOne = false;
        if (this.lexer.lookingAt(5)) {
            this.lexer.eat();
            sequenced = true;
        } else if (this.lexer.lookingAt(4)) {
            this.lexer.eat();
            sequenced = true;
            atLeastOne = true;
        }
        if (this.lexer.lookingAt(6)) {
            this.lexer.eat();
            declaredVoid = true;
        }
        if (this.lexer.lookingAt(1)) {
            result = this.parseMethod(type, declaredVoid);
        } else {
            if (declaredVoid) {
                throw new ParameterNameParserException("void Value");
            }
            result = this.parseValue(type);
        }
        result.setName(identifier);
        result.setUnit(this.unit);
        result.setContainer(container);
        result.setScope(container);
        Parameter p = new Parameter();
        p.setName(identifier);
        p.setSequenced(sequenced);
        p.setAtLeastOne(atLeastOne);
        p.setDeclaredAnything(declaredVoid);
        p.setModel(result);
        result.setInitializerParameter(p);
        container.addMember(result);
        return p;
    }

    private Value parseValue(Type type) {
        Value value = new Value();
        value.setType(type);
        return value;
    }

    private Function parseMethod(Type type, boolean declaredVoid) {
        Function method = new Function();
        method.setDeclaredVoid(declaredVoid);
        method.setType(this.loader.getSimpleCallableReturnType(type));
        while (this.lexer.lookingAt(1)) {
            method.addParameterList(this.parseNameList(type, method));
            type = this.loader.getSimpleCallableReturnType(type);
        }
        return method;
    }
}

