/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader;

import com.redhat.ceylon.model.loader.TypeParserException;

public class TypeLexer {
    public static final int COMMA = 0;
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int LT = 3;
    public static final int GT = 4;
    public static final int DOT = 5;
    public static final int DBLCOLON = 6;
    public static final int EOT = 7;
    public static final int WORD = 8;
    public static final int OUT = 9;
    public static final int IN = 10;
    public static final int OPEN_SQ = 11;
    public static final int CLOSE_SQ = 12;
    public static final int OPEN_BR = 13;
    public static final int CLOSE_BR = 14;
    public static final int OPEN_PAR = 15;
    public static final int CLOSE_PAR = 16;
    public static final int STAR = 17;
    public static final int PLUS = 18;
    public static final int THIN_ARROW = 19;
    public static final int QN = 20;
    public static final int EQ = 21;
    char[] type;
    int index = 0;
    int mark = -1;

    public void setup(String type) {
        this.type = type.toCharArray();
        this.index = 0;
    }

    private void dump() {
        do {
            System.err.println(this.eatTokenString());
        } while (this.peek() != 7);
        this.index = 0;
    }

    private void eatWhitespace() {
        while (this.index < this.type.length && ' ' == this.type[this.index]) {
            ++this.index;
        }
    }

    private int peek() {
        this.eatWhitespace();
        if (this.index >= this.type.length) {
            return 7;
        }
        char c = this.type[this.index];
        int token = 8;
        switch (c) {
            case '<': {
                token = 3;
                break;
            }
            case '>': {
                token = 4;
                break;
            }
            case '&': {
                token = 1;
                break;
            }
            case '|': {
                token = 2;
                break;
            }
            case '.': {
                token = 5;
                break;
            }
            case ',': {
                token = 0;
                break;
            }
            case '[': {
                token = 11;
                break;
            }
            case ']': {
                token = 12;
                break;
            }
            case '{': {
                token = 13;
                break;
            }
            case '}': {
                token = 14;
                break;
            }
            case '(': {
                token = 15;
                break;
            }
            case ')': {
                token = 16;
                break;
            }
            case '*': {
                token = 17;
                break;
            }
            case '+': {
                token = 18;
                break;
            }
            case '?': {
                token = 20;
                break;
            }
            case '=': {
                token = 21;
                break;
            }
            case '-': {
                if (this.index + 1 >= this.type.length || this.type[this.index + 1] != '>') break;
                token = 19;
                break;
            }
            case 'o': {
                if (this.index + 3 >= this.type.length || this.type[this.index + 1] != 'u' || this.type[this.index + 2] != 't' || this.type[this.index + 3] != ' ') break;
                token = 9;
                break;
            }
            case 'i': {
                if (this.index + 2 >= this.type.length || this.type[this.index + 1] != 'n' || this.type[this.index + 2] != ' ') break;
                token = 10;
                break;
            }
            case ':': {
                if (this.index + 1 >= this.type.length || this.type[this.index + 1] != ':') break;
                token = 6;
            }
        }
        return token;
    }

    public String eatWord() {
        this.eatWhitespace();
        if (this.index >= this.type.length) {
            throw new TypeParserException("Expecting word but got EOT");
        }
        int start = this.index;
        block3: while (this.index < this.type.length) {
            char c = this.type[this.index];
            switch (c) {
                case ' ': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    break block3;
                }
                default: {
                    ++this.index;
                    continue block3;
                }
            }
        }
        if (this.index == start) {
            throw new TypeParserException("Expecting word but got " + this.eatTokenString());
        }
        return new String(this.type, start, this.index - start);
    }

    public int eatDigits() {
        String digits = this.eatWord();
        for (int ii = 0; ii < digits.length(); ++ii) {
            if (digits.charAt(ii) >= '0' && digits.charAt(ii) <= '9') continue;
            throw new TypeParserException("Expecting digits but got " + digits);
        }
        return Integer.parseInt(digits);
    }

    public boolean isWord() {
        return this.peek() == 8;
    }

    public String eatTokenString() {
        int token = this.peek();
        if (token == 8) {
            return "WORD[" + this.eatWord() + "]";
        }
        this.eat();
        return this.tokenToString(token);
    }

    private String tokenToString(int token) {
        switch (token) {
            case 0: {
                return "COMMA";
            }
            case 1: {
                return "AND";
            }
            case 2: {
                return "OR";
            }
            case 3: {
                return "LT";
            }
            case 4: {
                return "GT";
            }
            case 5: {
                return "DOT";
            }
            case 6: {
                return "DBLCOLON";
            }
            case 7: {
                return "EOT";
            }
            case 8: {
                return "WORD";
            }
            case 9: {
                return "OUT";
            }
            case 10: {
                return "IN";
            }
            case 11: {
                return "OPEN_SQ";
            }
            case 12: {
                return "CLOSE_SQ";
            }
            case 13: {
                return "OPEN_BR";
            }
            case 14: {
                return "CLOSE_BR";
            }
            case 15: {
                return "OPEN_PAR";
            }
            case 16: {
                return "CLOSE_PAR";
            }
            case 17: {
                return "STAR";
            }
            case 18: {
                return "PLUS";
            }
            case 19: {
                return "THIN_ARROW";
            }
            case 20: {
                return "QN";
            }
            case 21: {
                return "EQ";
            }
        }
        throw new TypeParserException("Unhandled token: " + token);
    }

    public void eat(int token) {
        if (!this.lookingAt(token)) {
            int oldIndex = this.index;
            throw new TypeParserException("Missing expected token: " + this.tokenToString(token) + ", got: " + this.eatTokenString() + " at " + new String(this.type) + "[" + oldIndex + "]");
        }
        this.eat();
    }

    public void eat() {
        if (this.lookingAt(6)) {
            this.index += 2;
        } else if (this.lookingAt(10)) {
            this.index += 3;
        } else if (this.lookingAt(9)) {
            this.index += 4;
        } else if (this.lookingAt(19)) {
            this.index += 2;
        } else if (this.lookingAt(8)) {
            this.eatWord();
        } else {
            ++this.index;
        }
    }

    public boolean lookingAt(int token) {
        return this.peek() == token;
    }

    public void mark() {
        this.mark = this.index;
    }

    public void reset() {
        this.index = this.mark;
    }
}

