/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.impl.reflect;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.PathFilter;
import com.redhat.ceylon.model.loader.ContentAwareArtifactResult;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CachedTOCJars {
    private Map<Module, CachedTOCJar> jars = new HashMap<Module, CachedTOCJar>();

    public void addJar(ArtifactResult artifact, Module module) {
        this.addJar(artifact, module, false);
    }

    private static boolean definesPackage(String path) {
        return path.toLowerCase().endsWith(".class") && !path.equals("module-info.class");
    }

    public void addJar(ArtifactResult artifact, Module module, boolean skipContents) {
        if (this.jars.containsKey(module)) {
            return;
        }
        this.jars.put(module, new CachedTOCJar(artifact, skipContents));
    }

    public boolean packageExists(Module module, String name) {
        String path = name.replace('.', '/');
        CachedTOCJar jar = this.jars.get(module);
        return jar != null && jar.containsPackage(path);
    }

    public List<String> getPackageList(Module module, String name) {
        String path = name.replace('.', '/');
        CachedTOCJar jar = this.jars.get(module);
        return jar != null && jar.containsPackage(path) ? jar.getFileNames(path) : Collections.emptyList();
    }

    public byte[] getContents(String path) {
        for (CachedTOCJar jar : this.jars.values()) {
            if (jar.skipContents || !jar.containsFile(path)) continue;
            return jar.getContents(path);
        }
        return null;
    }

    public URI getContentUri(String path) {
        for (CachedTOCJar jar : this.jars.values()) {
            if (jar.skipContents || !jar.containsFile(path)) continue;
            return jar.getContentUri(path);
        }
        return null;
    }

    public byte[] getContents(Module module, String path) {
        CachedTOCJar jar = this.jars.get(module);
        if (jar != null && !jar.skipContents && jar.containsFile(path)) {
            return jar.getContents(path);
        }
        return null;
    }

    public URI getContentUri(Module module, String path) {
        CachedTOCJar jar = this.jars.get(module);
        if (jar != null && !jar.skipContents && jar.containsFile(path)) {
            return jar.getContentUri(path);
        }
        return null;
    }

    public Set<String> getPackagePaths(Module module) {
        CachedTOCJar jar = this.jars.get(module);
        if (jar != null) {
            return jar.getPackagePaths();
        }
        return null;
    }

    public String toString() {
        return "CachedTOCJars[jars=" + this.jars + "]";
    }

    static class CachedTOCJar {
        ArtifactResult artifact;
        private boolean loaded = false;
        Set<String> contents = new HashSet<String>();
        Set<String> folders = new HashSet<String>();
        Set<String> packages = new HashSet<String>();
        boolean skipContents;

        CachedTOCJar(ArtifactResult artifact, boolean skipContents) {
            this.artifact = artifact;
            this.skipContents = skipContents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load() {
            if (this.loaded) {
                return;
            }
            if (this.artifact instanceof ContentAwareArtifactResult) {
                this.packages.addAll(((ContentAwareArtifactResult)this.artifact).getPackages());
                this.contents.addAll(((ContentAwareArtifactResult)this.artifact).getEntries());
            } else if (this.artifact.artifact() != null) {
                try (ZipFile zf = new ZipFile(this.artifact.artifact());){
                    Enumeration<? extends ZipEntry> entries = zf.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (!this.accept(name)) continue;
                        if (entry.isDirectory()) {
                            this.folders.add(name);
                            continue;
                        }
                        if (CachedTOCJars.definesPackage(name)) {
                            this.packages.add(this.getPackageName(name));
                        }
                        this.contents.add(name);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.loaded = true;
        }

        private boolean accept(String path) {
            PathFilter filter = this.artifact.filter();
            return filter == null || filter.accept(path);
        }

        private String getPackageName(String path) {
            int sep = path.lastIndexOf(47);
            path = sep != -1 ? path.substring(0, sep) : "";
            return path;
        }

        boolean containsFile(String path) {
            this.load();
            return this.contents.contains(path);
        }

        boolean containsPackage(String path) {
            this.load();
            return this.packages.contains(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        byte[] getContents(String path) {
            if (this.artifact instanceof ContentAwareArtifactResult) {
                return ((ContentAwareArtifactResult)this.artifact).getContents(path);
            }
            File jar = this.artifact.artifact();
            if (jar == null) throw new RuntimeException("No file associated with artifact : " + this.artifact.toString());
            try (ZipFile zf = new ZipFile(jar);){
                ZipEntry entry = zf.getEntry(path);
                if (entry == null) throw new RuntimeException("Missing entry: " + path + " in jar file: " + jar.getPath());
                byte[] byArray = this.loadFile(zf.getInputStream(entry), (int)entry.getSize());
                return byArray;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        URI getContentUri(String path) {
            if (this.artifact instanceof ContentAwareArtifactResult) {
                return ((ContentAwareArtifactResult)this.artifact).getContentUri(path);
            }
            File jar = this.artifact.artifact();
            if (jar != null) {
                this.load();
                try {
                    if (this.contents.contains(path) || this.folders.contains(path)) {
                        String uripath = FileUtil.absoluteFile(jar).toURI().getSchemeSpecificPart();
                        return new URI("classpath", uripath + "!" + path, null);
                    }
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                throw new RuntimeException("Missing entry: " + path + " in jar file: " + jar.getPath());
            }
            throw new RuntimeException("No file associated with artifact : " + this.artifact.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] loadFile(InputStream inputStream, int size) throws IOException {
            byte[] buf = new byte[size];
            try {
                int read;
                for (int offset = 0; offset != size && (read = inputStream.read(buf, offset, size - offset)) >= 0; offset += read) {
                }
                byte[] byArray = buf;
                return byArray;
            }
            finally {
                inputStream.close();
            }
        }

        private List<String> getFileNames(String path) {
            if (this.artifact instanceof ContentAwareArtifactResult) {
                return ((ContentAwareArtifactResult)this.artifact).getFileNames(path);
            }
            File jar = this.artifact.artifact();
            if (jar != null) {
                this.load();
                boolean emptyPackage = path.isEmpty();
                path = path + "/";
                ArrayList<String> ret = new ArrayList<String>();
                for (String name : this.contents) {
                    String part = null;
                    if (!emptyPackage && name.startsWith(path)) {
                        part = name.substring(path.length());
                    } else if (emptyPackage) {
                        part = name;
                    }
                    if (part == null || part.indexOf(47) != -1) continue;
                    ret.add(name);
                }
                return ret;
            }
            throw new RuntimeException("No file associated with artifact : " + this.artifact.toString());
        }

        public Set<String> getPackagePaths() {
            this.load();
            return this.packages;
        }

        public String toString() {
            return "CachedTOCJar[jar=" + this.artifact + "]";
        }
    }
}

