/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.impl.reflect;

import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.common.Java9ModuleUtil;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.ModelLoader;
import com.redhat.ceylon.model.loader.Timer;
import com.redhat.ceylon.model.loader.TypeParser;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionClass;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionMethod;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.MethodMirror;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Modules;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;

public abstract class ReflectionModelLoader
extends AbstractModelLoader {
    protected Logger log;

    public ReflectionModelLoader(ModuleManager moduleManager, Modules modules, Logger log) {
        this.initModuleManager(moduleManager);
        this.modules = modules;
        this.typeFactory = new Unit();
        this.typeParser = new TypeParser(this);
        this.timer = new Timer(false);
        this.log = log;
    }

    protected abstract List<String> getPackageList(Module var1, String var2);

    protected abstract boolean packageExists(Module var1, String var2);

    protected abstract Class<?> loadClass(Module var1, String var2);

    @Override
    public void loadStandardModules() {
        super.loadStandardModules();
        Module languageModule = this.modules.getLanguageModule();
        this.findOrCreatePackage(languageModule, "ceylon.language");
        this.findOrCreatePackage(languageModule, "ceylon.language.meta.model");
        this.findOrCreatePackage(languageModule, "ceylon.language.meta.declaration");
        this.findOrCreatePackage(languageModule, "ceylon.language.serialization");
    }

    @Override
    public boolean loadPackage(Module module, String packageName, boolean loadDeclarations) {
        packageName = JVMModuleUtil.quoteJavaKeywords(packageName);
        if (loadDeclarations && !this.loadedPackages.add(this.cacheKeyByModule(module, packageName))) {
            return true;
        }
        if (!this.packageExists(module, packageName)) {
            return false;
        }
        if (loadDeclarations) {
            for (String file : this.getPackageList(module, packageName)) {
                String className;
                int lastDot;
                String lastPart;
                int dollar;
                if (!file.toLowerCase().endsWith(".class") || (dollar = (lastPart = (lastDot = (className = file.substring(0, file.length() - 6).replace('/', '.')).lastIndexOf(46)) == -1 ? className : className.substring(lastDot + 1)).indexOf(36)) > 0 || this.isModuleOrPackageDescriptorName(lastPart) || this.isLoadedFromSource(className) || className.endsWith("_") && this.isLoadedFromSource(className.substring(0, className.length() - 1)) || this.isTypeHidden(module, className)) continue;
                this.convertToDeclaration(module, className, ModelLoader.DeclarationType.TYPE);
            }
            if (module.getNameAsString().equals("java.base") && packageName.equals("java.lang")) {
                this.loadJavaBaseArrays();
            }
        }
        return true;
    }

    protected boolean isLoadedFromSource(String className) {
        return false;
    }

    @Override
    public ClassMirror lookupNewClassMirror(Module module, String name) {
        Class<?> klass = null;
        klass = this.loadClass(module, JVMModuleUtil.quoteJavaKeywords(name));
        if (klass == null && this.lastPartHasLowerInitial(name) && !name.endsWith("_")) {
            klass = this.loadClass(module, JVMModuleUtil.quoteJavaKeywords(name + "_"));
        }
        return klass != null ? new ReflectionClass(klass) : null;
    }

    @Override
    protected String assembleJavaClass(String javaClass, String packageName) {
        if (!packageName.isEmpty()) {
            javaClass = javaClass.substring(packageName.length() + 1);
        }
        javaClass = javaClass.replace('.', '$');
        if (packageName.isEmpty()) {
            return javaClass;
        }
        return packageName + "." + javaClass;
    }

    @Override
    protected boolean isOverridingMethod(MethodMirror methodSymbol) {
        Member method = ((ReflectionMethod)methodSymbol).method;
        if (method.getDeclaringClass().getName().contentEquals("ceylon.language.Identifiable") && (method.getName().contentEquals("equals") || method.getName().contentEquals("hashCode"))) {
            return true;
        }
        if (method.getDeclaringClass().getName().contentEquals("ceylon.language.Object") && (method.getName().contentEquals("equals") || method.getName().contentEquals("hashCode") || method.getName().contentEquals("toString"))) {
            return false;
        }
        return ((ReflectionMethod)methodSymbol).isOverridingMethod();
    }

    @Override
    protected boolean isOverloadingMethod(MethodMirror methodSymbol) {
        return ((ReflectionMethod)methodSymbol).isOverloadingMethod();
    }

    @Override
    protected void logError(String message) {
        this.log.error(message);
    }

    @Override
    protected void logWarning(String message) {
        this.log.warning(message);
    }

    @Override
    protected void logVerbose(String message) {
        this.log.debug(message);
    }

    static {
        try {
            Object otherModule;
            Object mod;
            if (JDKUtils.jdk.providesVersion(JDKUtils.JDK.JDK9.version) && Java9ModuleUtil.isNamedModule(mod = Java9ModuleUtil.getModule(ReflectionModelLoader.class)) && (otherModule = Java9ModuleUtil.findModule(mod, "ceylon.language")) != null) {
                Class<?> moduleClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.reflect.Module");
                Method addReads = moduleClass.getMethod("addReads", moduleClass);
                addReads.invoke(mod, otherModule);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to add read from model to language module in Java 9", t);
        }
    }
}

