/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.impl.reflect.mirror;

import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.ModelResolutionException;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionField;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionMethod;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionPackage;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionType;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionUtils;
import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.FieldMirror;
import com.redhat.ceylon.model.loader.mirror.MethodMirror;
import com.redhat.ceylon.model.loader.mirror.PackageMirror;
import com.redhat.ceylon.model.loader.mirror.TypeMirror;
import com.redhat.ceylon.model.loader.mirror.TypeParameterMirror;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ReflectionClass
implements ClassMirror {
    public final Class<?> klass;
    private ArrayList<FieldMirror> fields;
    private ArrayList<MethodMirror> methods;
    private ArrayList<TypeMirror> interfaces;
    private List<TypeParameterMirror> typeParameters;
    private ReflectionPackage pkg;
    private boolean superClassSet;
    private ReflectionType superClass;
    private boolean enclosingClassSet;
    private ClassMirror enclosingClass;
    private boolean enclosingMethodSet;
    private MethodMirror enclosingMethod;
    private LinkedList<ClassMirror> innerClasses;
    private String cacheKey;
    private Map<String, AnnotationMirror> annotations;

    public ReflectionClass(Class<?> klass) {
        this.klass = klass;
    }

    @Override
    public AnnotationMirror getAnnotation(String type) {
        return this.getAnnotations().get(type);
    }

    private boolean isAnnotationPresent(String type) {
        return this.getAnnotations().containsKey(type);
    }

    private Map<String, AnnotationMirror> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = ReflectionUtils.getAnnotations(this.klass);
        }
        return this.annotations;
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.klass.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.klass.getModifiers());
    }

    @Override
    public boolean isDefaultAccess() {
        return !Modifier.isPrivate(this.klass.getModifiers()) && !Modifier.isPublic(this.klass.getModifiers()) && !Modifier.isProtected(this.klass.getModifiers());
    }

    @Override
    public String getQualifiedName() {
        return this.klass.getName();
    }

    @Override
    public String getFlatName() {
        return this.klass.getName();
    }

    @Override
    public String getName() {
        return this.klass.getSimpleName();
    }

    @Override
    public PackageMirror getPackage() {
        if (this.pkg != null) {
            return this.pkg;
        }
        this.pkg = new ReflectionPackage(this.klass);
        return this.pkg;
    }

    @Override
    public boolean isInterface() {
        return this.klass.isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return this.klass.isAnnotation();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.klass.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.klass.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.klass.getModifiers());
    }

    @Override
    public List<MethodMirror> getDirectMethods() {
        Constructor<?>[] directConstructors;
        Method[] directMethods;
        if (this.methods != null) {
            return this.methods;
        }
        try {
            directMethods = this.klass.getDeclaredMethods();
            directConstructors = this.klass.getDeclaredConstructors();
        }
        catch (NoClassDefFoundError x) {
            throw new ModelResolutionException("Failed to load methods in " + this.getQualifiedName(), x);
        }
        this.methods = new ArrayList(directMethods.length + directConstructors.length);
        for (Method method : directMethods) {
            if (method.isSynthetic() || method.isBridge()) continue;
            this.methods.add(new ReflectionMethod(this, method));
        }
        for (Executable executable : directConstructors) {
            if (((Constructor)executable).isSynthetic()) continue;
            this.methods.add(new ReflectionMethod(this, executable));
        }
        return this.methods;
    }

    @Override
    public List<FieldMirror> getDirectFields() {
        if (this.fields != null) {
            return this.fields;
        }
        Field[] directFields = this.klass.getDeclaredFields();
        this.fields = new ArrayList(directFields.length);
        for (Field field : directFields) {
            if (field.isSynthetic()) continue;
            this.fields.add(new ReflectionField(field));
        }
        return this.fields;
    }

    @Override
    public TypeMirror getSuperclass() {
        if (this.superClassSet) {
            return this.superClass;
        }
        Type sup = this.klass.getGenericSuperclass();
        if (sup != null) {
            this.superClass = new ReflectionType(sup);
        }
        this.superClassSet = true;
        return this.superClass;
    }

    @Override
    public List<TypeMirror> getInterfaces() {
        if (this.interfaces != null) {
            return this.interfaces;
        }
        Type[] javaInterfaces = this.klass.getGenericInterfaces();
        this.interfaces = new ArrayList(javaInterfaces.length);
        for (Type javaInterface : javaInterfaces) {
            this.interfaces.add(new ReflectionType(javaInterface));
        }
        return this.interfaces;
    }

    @Override
    public List<TypeParameterMirror> getTypeParameters() {
        if (this.typeParameters != null) {
            return this.typeParameters;
        }
        this.typeParameters = ReflectionUtils.getTypeParameters(this.klass);
        return this.typeParameters;
    }

    @Override
    public boolean isCeylonToplevelAttribute() {
        return !this.isInnerClass() && this.isAnnotationPresent("com.redhat.ceylon.compiler.java.metadata.Attribute");
    }

    @Override
    public boolean isCeylonToplevelObject() {
        return !this.isInnerClass() && this.isAnnotationPresent("com.redhat.ceylon.compiler.java.metadata.Object");
    }

    @Override
    public boolean isCeylonToplevelMethod() {
        return !this.isInnerClass() && this.isAnnotationPresent("com.redhat.ceylon.compiler.java.metadata.Method");
    }

    @Override
    public boolean isLoadedFromSource() {
        return false;
    }

    public String toString() {
        return "[ReflectionClass: " + this.klass.toString() + "]";
    }

    @Override
    public boolean isInnerClass() {
        return this.klass.isMemberClass() || this.isAnnotationPresent("com.redhat.ceylon.compiler.java.metadata.Container");
    }

    @Override
    public boolean isLocalClass() {
        return this.klass.isLocalClass() || this.isAnnotationPresent("com.redhat.ceylon.compiler.java.metadata.LocalDeclaration");
    }

    @Override
    public List<ClassMirror> getDirectInnerClasses() {
        if (this.innerClasses == null) {
            this.innerClasses = new LinkedList();
            for (Class<?> innerClass : this.klass.getDeclaredClasses()) {
                this.innerClasses.add(new ReflectionClass(innerClass));
            }
        }
        return this.innerClasses;
    }

    @Override
    public boolean isAnonymous() {
        return this.klass.isAnonymousClass();
    }

    @Override
    public boolean isJavaSource() {
        return false;
    }

    @Override
    public ClassMirror getEnclosingClass() {
        if (this.enclosingClassSet) {
            return this.enclosingClass;
        }
        Class<?> encl = this.klass.getEnclosingClass();
        if (encl != null) {
            this.enclosingClass = new ReflectionClass(encl);
        }
        this.enclosingClassSet = true;
        return this.enclosingClass;
    }

    @Override
    public MethodMirror getEnclosingMethod() {
        if (this.enclosingMethodSet) {
            return this.enclosingMethod;
        }
        Executable encl = this.klass.getEnclosingMethod();
        if (encl == null) {
            encl = this.klass.getEnclosingConstructor();
        }
        if (encl != null) {
            Class<?> declaringClass = encl.getDeclaringClass();
            ReflectionClass declaringClassMirror = new ReflectionClass(declaringClass);
            this.enclosingMethod = new ReflectionMethod(declaringClassMirror, encl);
        }
        this.enclosingMethodSet = true;
        return this.enclosingMethod;
    }

    @Override
    public boolean isEnum() {
        return this.klass.isEnum();
    }

    @Override
    public String getCacheKey(Module module) {
        if (this.cacheKey == null) {
            String className = this.getQualifiedName();
            this.cacheKey = AbstractModelLoader.getCacheKeyByModule(module, className);
        }
        return this.cacheKey;
    }
}

