/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.impl.reflect.mirror;

import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionType;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionUtils;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionVariable;
import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.MethodMirror;
import com.redhat.ceylon.model.loader.mirror.TypeMirror;
import com.redhat.ceylon.model.loader.mirror.TypeParameterMirror;
import com.redhat.ceylon.model.loader.mirror.VariableMirror;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReflectionMethod
implements MethodMirror {
    public final Member method;
    private ArrayList<VariableMirror> parameters;
    private List<TypeParameterMirror> typeParameters;
    private Boolean overridingMethod;
    private Boolean overloadingMethod;
    private ReflectionType returnType;
    private ClassMirror enclosingClass;
    private Map<String, AnnotationMirror> annotations;

    public ReflectionMethod(ClassMirror enclosingClass, Member method) {
        this.method = method;
        this.enclosingClass = enclosingClass;
    }

    @Override
    public AnnotationMirror getAnnotation(String type) {
        return this.getAnnotations().get(type);
    }

    private Map<String, AnnotationMirror> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = ReflectionUtils.getAnnotations((AnnotatedElement)((Object)this.method));
        }
        return this.annotations;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.method.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.method.getModifiers());
    }

    @Override
    public boolean isDefaultAccess() {
        return !Modifier.isPrivate(this.method.getModifiers()) && !Modifier.isPublic(this.method.getModifiers()) && !Modifier.isProtected(this.method.getModifiers());
    }

    @Override
    public boolean isConstructor() {
        return this.method instanceof Constructor;
    }

    @Override
    public boolean isStaticInit() {
        return false;
    }

    @Override
    public boolean isVariadic() {
        return this.method instanceof Method ? ((Method)this.method).isVarArgs() : ((Constructor)this.method).isVarArgs();
    }

    @Override
    public List<VariableMirror> getParameters() {
        int annotationsOffset;
        int parameterCount;
        Annotation[][] annotations;
        Type[] javaParameters;
        if (this.parameters != null) {
            return this.parameters;
        }
        if (this.method instanceof Method) {
            javaParameters = ((Method)this.method).getGenericParameterTypes();
            annotations = ((Method)this.method).getParameterAnnotations();
            parameterCount = ((Method)this.method).getParameterTypes().length;
        } else {
            javaParameters = ((Constructor)this.method).getGenericParameterTypes();
            annotations = ((Constructor)this.method).getParameterAnnotations();
            parameterCount = ((Constructor)this.method).getParameterTypes().length;
        }
        this.parameters = new ArrayList(parameterCount);
        int start = 0;
        if (this.method instanceof Constructor) {
            Class<?> declaringClass = this.method.getDeclaringClass();
            if (declaringClass.isEnum()) {
                start = 2;
            } else if ((declaringClass.isMemberClass() || declaringClass.isAnonymousClass() || declaringClass.isLocalClass() && !this.isStaticLocalContainer(declaringClass)) && !Modifier.isStatic(declaringClass.getModifiers())) {
                start = 1;
            }
        }
        int parametersOffset = javaParameters.length != parameterCount ? -start : 0;
        int n = annotationsOffset = annotations.length != parameterCount ? -start : 0;
        if (javaParameters.length != parameterCount) {
            parameterCount = javaParameters.length + start;
        } else if (annotations.length != parameterCount) {
            parameterCount = annotations.length + start;
        }
        for (int i = start; i < parameterCount; ++i) {
            this.parameters.add(new ReflectionVariable(javaParameters[i + parametersOffset], annotations[i + annotationsOffset]));
        }
        return this.parameters;
    }

    private boolean isStaticLocalContainer(Class<?> klass) {
        Constructor<?> enclosingConstructor = klass.getEnclosingConstructor();
        if (enclosingConstructor != null) {
            return Modifier.isStatic(enclosingConstructor.getModifiers());
        }
        Method enclosingMethod = klass.getEnclosingMethod();
        return Modifier.isStatic(enclosingMethod.getModifiers());
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.method.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.method.getModifiers());
    }

    @Override
    public TypeMirror getReturnType() {
        if (this.returnType != null) {
            return this.returnType;
        }
        this.returnType = this.method instanceof Method ? new ReflectionType(((Method)this.method).getGenericReturnType()) : new ReflectionType(((Constructor)this.method).getDeclaringClass());
        return this.returnType;
    }

    @Override
    public boolean isDeclaredVoid() {
        return this.method instanceof Method && Void.TYPE == ((Method)this.method).getReturnType();
    }

    @Override
    public List<TypeParameterMirror> getTypeParameters() {
        if (this.typeParameters != null) {
            return this.typeParameters;
        }
        this.typeParameters = ReflectionUtils.getTypeParameters((GenericDeclaration)((Object)this.method));
        return this.typeParameters;
    }

    public boolean isOverridingMethod() {
        if (this.overridingMethod != null) {
            return this.overridingMethod;
        }
        this.overridingMethod = this.method instanceof Method ? Boolean.valueOf(ReflectionUtils.isOverridingMethod((Method)this.method)) : Boolean.valueOf(false);
        return this.overridingMethod;
    }

    public boolean isOverloadingMethod() {
        if (this.overloadingMethod != null) {
            return this.overloadingMethod;
        }
        this.overloadingMethod = this.method instanceof Method ? Boolean.valueOf(ReflectionUtils.isOverloadingMethod((Method)this.method)) : Boolean.valueOf(false);
        return this.overloadingMethod;
    }

    public String toString() {
        return "[ReflectionMethod: " + this.method.toString() + "]";
    }

    @Override
    public boolean isDefault() {
        return ((Method)this.method).getDefaultValue() != null;
    }

    @Override
    public ClassMirror getEnclosingClass() {
        return this.enclosingClass;
    }
}

