/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.impl.reflect.mirror;

import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionClass;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionTypeParameter;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.TypeMirror;
import com.redhat.ceylon.model.loader.mirror.TypeParameterMirror;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.TypeKind;

public class ReflectionType
implements TypeMirror {
    private Type type;
    private List<TypeMirror> typeArguments;
    private ReflectionType componentType;
    private ReflectionType upperBound;
    private ReflectionType lowerBound;
    private boolean lowerBoundSet;
    private boolean upperBoundSet;
    private ReflectionClass declaredClass;
    private boolean declaredClassSet;
    private boolean typeParameterSet;
    private ReflectionTypeParameter typeParameter;
    private ReflectionType qualifyingType;
    private boolean qualifyingTypeSet;
    private static final Map<Class<?>, TypeKind> primitives = new HashMap();

    public ReflectionType(Type type) {
        this.type = type;
    }

    @Override
    public String getQualifiedName() {
        if (this.type instanceof ParameterizedType) {
            return ((Class)((ParameterizedType)this.type).getRawType()).getName();
        }
        if (this.type instanceof TypeVariable) {
            return ((TypeVariable)this.type).getName();
        }
        Class klass = (Class)this.type;
        return klass.getName();
    }

    @Override
    public List<TypeMirror> getTypeArguments() {
        if (this.typeArguments != null) {
            return this.typeArguments;
        }
        if (this.type instanceof ParameterizedType) {
            Type[] javaTypeArguments = ((ParameterizedType)this.type).getActualTypeArguments();
            this.typeArguments = new ArrayList<TypeMirror>(javaTypeArguments.length);
            for (Type typeArgument : javaTypeArguments) {
                this.typeArguments.add(new ReflectionType(typeArgument));
            }
            return this.typeArguments;
        }
        this.typeArguments = Collections.emptyList();
        return this.typeArguments;
    }

    @Override
    public TypeKind getKind() {
        if (this.type instanceof ParameterizedType) {
            return TypeKind.DECLARED;
        }
        if (this.type instanceof GenericArrayType) {
            return TypeKind.ARRAY;
        }
        if (this.type instanceof TypeVariable) {
            return TypeKind.TYPEVAR;
        }
        if (this.type instanceof WildcardType) {
            return TypeKind.WILDCARD;
        }
        if (this.type instanceof Class) {
            TypeKind kind = primitives.get(this.type);
            if (kind != null) {
                return kind;
            }
            return ((Class)this.type).isArray() ? TypeKind.ARRAY : TypeKind.DECLARED;
        }
        throw new RuntimeException("Unknown type: " + this.type);
    }

    @Override
    public TypeMirror getComponentType() {
        if (this.componentType != null) {
            return this.componentType;
        }
        Type ct = this.type instanceof Class ? ((Class)this.type).getComponentType() : ((GenericArrayType)this.type).getGenericComponentType();
        this.componentType = new ReflectionType(ct);
        return this.componentType;
    }

    @Override
    public boolean isPrimitive() {
        return primitives.containsKey(this.type);
    }

    public String toString() {
        return "[ReflectionType: " + this.type.toString() + "]";
    }

    @Override
    public TypeMirror getUpperBound() {
        if (this.upperBoundSet) {
            return this.upperBound;
        }
        if (this.type instanceof WildcardType) {
            if (this.getLowerBound() == null) {
                Type[] ct = ((WildcardType)this.type).getUpperBounds();
                if (ct.length != 1) {
                    throw new RuntimeException("Not one upper bound in wildcard type: " + ct.length);
                }
                this.upperBound = new ReflectionType(ct[0]);
            } else {
                this.upperBound = null;
            }
        }
        this.upperBoundSet = true;
        return this.upperBound;
    }

    @Override
    public TypeMirror getLowerBound() {
        if (this.lowerBoundSet) {
            return this.lowerBound;
        }
        Type[] ct = ((WildcardType)this.type).getLowerBounds();
        if (ct.length == 0) {
            return null;
        }
        if (ct.length > 1) {
            throw new RuntimeException("More than one lower bound in wildcard type: " + ct.length);
        }
        this.lowerBound = new ReflectionType(ct[0]);
        this.lowerBoundSet = true;
        return this.lowerBound;
    }

    @Override
    public boolean isRaw() {
        if (this.type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)this.type;
            Class klass = (Class)ptype.getRawType();
            return klass.getTypeParameters().length != ptype.getActualTypeArguments().length;
        }
        if (this.type instanceof GenericArrayType) {
            return this.getComponentType().isRaw();
        }
        if (this.type instanceof TypeVariable) {
            return false;
        }
        if (this.type instanceof WildcardType) {
            return false;
        }
        if (this.type instanceof Class) {
            return ((Class)this.type).getTypeParameters().length != 0;
        }
        throw new RuntimeException("Unknown type: " + this.type);
    }

    @Override
    public ClassMirror getDeclaredClass() {
        if (!this.declaredClassSet) {
            if (this.type instanceof Class) {
                this.declaredClass = new ReflectionClass((Class)this.type);
            } else if (this.type instanceof ParameterizedType) {
                this.declaredClass = new ReflectionClass((Class)((ParameterizedType)this.type).getRawType());
            }
            this.declaredClassSet = true;
        }
        return this.declaredClass;
    }

    @Override
    public TypeParameterMirror getTypeParameter() {
        if (this.getKind() != TypeKind.TYPEVAR) {
            return null;
        }
        if (!this.typeParameterSet) {
            this.typeParameter = new ReflectionTypeParameter(this.type);
            this.typeParameterSet = true;
        }
        return this.typeParameter;
    }

    @Override
    public TypeMirror getQualifyingType() {
        if (!this.qualifyingTypeSet) {
            Type ownerType = null;
            if (this.type instanceof Class) {
                ownerType = ((Class)this.type).getEnclosingClass();
            } else if (this.type instanceof ParameterizedType) {
                ownerType = ((ParameterizedType)this.type).getOwnerType();
            }
            if (ownerType != null) {
                this.qualifyingType = new ReflectionType(ownerType);
            }
            this.qualifyingTypeSet = true;
        }
        return this.qualifyingType;
    }

    static {
        primitives.put(Boolean.TYPE, TypeKind.BOOLEAN);
        primitives.put(Byte.TYPE, TypeKind.BYTE);
        primitives.put(Character.TYPE, TypeKind.CHAR);
        primitives.put(Short.TYPE, TypeKind.SHORT);
        primitives.put(Integer.TYPE, TypeKind.INT);
        primitives.put(Long.TYPE, TypeKind.LONG);
        primitives.put(Float.TYPE, TypeKind.FLOAT);
        primitives.put(Double.TYPE, TypeKind.DOUBLE);
        primitives.put(Void.TYPE, TypeKind.VOID);
    }
}

