/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.ModelCompleter;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.MethodMirror;
import com.redhat.ceylon.model.loader.model.LazyContainer;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LazyClass
extends Class
implements LazyContainer {
    public final ClassMirror classMirror;
    private ModelCompleter completer;
    private Class superClass;
    private MethodMirror constructor;
    private String realName;
    private boolean isStatic;
    private boolean isCeylon;
    private boolean isValueType;
    private Map<String, Declaration> localDeclarations;
    private boolean isLoaded = false;
    private boolean isLoaded2 = false;
    private boolean isTypeParamsLoaded = false;
    private boolean isTypeParamsLoaded2 = false;
    private boolean local = false;
    private boolean hasJpaConstructor;

    @Override
    protected java.lang.Class<?> getModelClass() {
        return this.getClass().getSuperclass();
    }

    public LazyClass(ClassMirror classMirror, ModelCompleter completer, Class superClass, MethodMirror constructor) {
        this.classMirror = classMirror;
        this.completer = completer;
        this.superClass = superClass;
        this.constructor = constructor;
        this.realName = classMirror.getName();
        this.setName(JvmBackendUtil.getMirrorName(classMirror));
        this.isStatic = classMirror.isStatic();
        this.isCeylon = classMirror.getAnnotation("com.redhat.ceylon.compiler.java.metadata.Ceylon") != null;
        this.isValueType = classMirror.getAnnotation("com.redhat.ceylon.compiler.java.metadata.ValueType") != null;
    }

    @Override
    public boolean isErasedTypeArguments() {
        return !this.isCeylon();
    }

    @Override
    public boolean isCeylon() {
        return this.isCeylon;
    }

    public boolean isValueType() {
        return this.isValueType;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public MethodMirror getConstructor() {
        return this.constructor;
    }

    public String getRealName() {
        return this.realName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (!this.isLoaded2) {
            Object object = this.completer.getLock();
            synchronized (object) {
                this.loadTypeParams();
                if (!this.isLoaded) {
                    this.isLoaded = true;
                    this.completer.complete(this);
                    this.isLoaded2 = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTypeParams() {
        if (!this.isTypeParamsLoaded2) {
            Object object = this.completer.getLock();
            synchronized (object) {
                if (!this.isTypeParamsLoaded) {
                    this.isTypeParamsLoaded = true;
                    this.completer.completeTypeParameters(this);
                    this.isTypeParamsLoaded2 = true;
                }
            }
        }
    }

    @Override
    public String toString() {
        if (!this.isLoaded) {
            return "UNLOADED:" + super.toString();
        }
        return super.toString();
    }

    @Override
    public ParameterList getParameterList() {
        this.load();
        return super.getParameterList();
    }

    @Override
    public boolean isStaticallyImportable() {
        return super.isStaticallyImportable();
    }

    @Override
    public Parameter getParameter(String name) {
        this.load();
        return super.getParameter(name);
    }

    @Override
    public List<Declaration> getMembers() {
        this.load();
        return super.getMembers();
    }

    @Override
    public Type getType() {
        this.loadTypeParams();
        return super.getType();
    }

    @Override
    public Type getExtendedType() {
        if (this.superClass == null) {
            this.load();
            return super.getExtendedType();
        }
        return this.superClass.getType();
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        this.loadTypeParams();
        return super.getTypeParameters();
    }

    @Override
    public List<ParameterList> getParameterLists() {
        this.load();
        return super.getParameterLists();
    }

    @Override
    public boolean isMember() {
        return super.isMember();
    }

    @Override
    public boolean hasConstructors() {
        this.load();
        return super.hasConstructors();
    }

    @Override
    public Type getDeclaringType(Declaration d) {
        this.load();
        return super.getDeclaringType(d);
    }

    @Override
    public boolean isParameterized() {
        this.load();
        return super.isParameterized();
    }

    @Override
    public List<Type> getSatisfiedTypes() {
        this.load();
        return super.getSatisfiedTypes();
    }

    @Override
    public List<Type> getCaseTypes() {
        this.load();
        return super.getCaseTypes();
    }

    @Override
    public Reference appliedReference(Type pt, List<Type> typeArguments) {
        this.loadTypeParams();
        return super.appliedReference(pt, typeArguments);
    }

    @Override
    public Type appliedType(Type outerType, List<Type> typeArguments) {
        this.loadTypeParams();
        return super.appliedType(outerType, typeArguments);
    }

    @Override
    public List<Declaration> getInheritedMembers(String name) {
        this.load();
        return super.getInheritedMembers(name);
    }

    @Override
    public Declaration getRefinedMember(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getRefinedMember(name, signature, ellipsis);
    }

    @Override
    public Declaration getMember(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getMember(name, signature, ellipsis);
    }

    @Override
    public Declaration getMemberOrParameter(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getMemberOrParameter(name, signature, ellipsis);
    }

    @Override
    public boolean isAlias() {
        return super.isAlias();
    }

    @Override
    public Type getSelfType() {
        this.load();
        return super.getSelfType();
    }

    @Override
    public Scope getVisibleScope() {
        return super.getVisibleScope();
    }

    @Override
    public List<Annotation> getAnnotations() {
        this.load();
        return super.getAnnotations();
    }

    @Override
    public String getQualifiedNameString() {
        return super.getQualifiedNameString();
    }

    @Override
    public boolean isActual() {
        this.load();
        return super.isActual();
    }

    @Override
    public boolean isFormal() {
        this.load();
        return super.isFormal();
    }

    @Override
    public boolean isDefault() {
        this.load();
        return super.isDefault();
    }

    @Override
    public Backends getNativeBackends() {
        return super.getNativeBackends();
    }

    @Override
    public void setNativeBackends(Backends backends) {
        super.setNativeBackends(backends);
    }

    @Override
    public boolean isVisible(Scope scope) {
        return super.isVisible(scope);
    }

    @Override
    public boolean isDefinedInScope(Scope scope) {
        this.load();
        return super.isDefinedInScope(scope);
    }

    @Override
    public boolean isCaptured() {
        this.load();
        return super.isCaptured();
    }

    @Override
    public boolean isToplevel() {
        return super.isToplevel();
    }

    @Override
    public boolean isClassMember() {
        return super.isClassMember();
    }

    @Override
    public boolean isInterfaceMember() {
        return super.isInterfaceMember();
    }

    @Override
    public boolean isClassOrInterfaceMember() {
        return super.isClassOrInterfaceMember();
    }

    @Override
    public Unit getUnit() {
        return super.getUnit();
    }

    @Override
    public Scope getContainer() {
        return super.getContainer();
    }

    @Override
    public Declaration getDirectMember(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getDirectMember(name, signature, ellipsis);
    }

    @Override
    public Declaration getMemberOrParameter(Unit unit, String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getMemberOrParameter(unit, name, signature, ellipsis);
    }

    @Override
    public boolean isAnnotation() {
        return super.isAnnotation();
    }

    @Override
    public void addMember(Declaration decl) {
        super.addMember(decl);
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public void setLocal(boolean local) {
        this.local = local;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public Declaration getLocalDeclaration(String name) {
        this.load();
        if (this.localDeclarations == null) {
            return null;
        }
        return this.localDeclarations.get(name);
    }

    @Override
    public void addLocalDeclaration(Declaration declaration) {
        if (this.localDeclarations == null) {
            this.localDeclarations = new HashMap<String, Declaration>();
        }
        this.localDeclarations.put(declaration.getPrefixedName(), declaration);
    }

    @Override
    public boolean isDeprecated() {
        return super.isDeprecated();
    }

    public boolean hasJpaConstructor() {
        this.load();
        return this.hasJpaConstructor;
    }

    public void setHasJpaConstructor(boolean hasJpaConstructor) {
        this.hasJpaConstructor = hasJpaConstructor;
    }
}

