/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.model;

import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.cmr.PathFilter;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.ContentAwareArtifactResult;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class LazyModule
extends Module {
    private boolean isJava = false;
    protected Set<String> jarPackages = new HashSet<String>();
    private PackagePathsProvider packagePathsProvider;
    private List<String> exportedJavaPackages;

    @Override
    public Package getDirectPackage(String name) {
        return this.findPackageInModule(this, name);
    }

    @Override
    public Package getPackage(String name) {
        Module languageModule;
        Package pkg = null;
        boolean defaultModule = this.isDefault();
        if (!defaultModule && (pkg = this.findPackageInModule(this, name)) != null) {
            return pkg;
        }
        HashSet<Module> visited = new HashSet<Module>();
        for (ModuleImport dependency : this.getImports()) {
            pkg = this.findPackageInImport(name, dependency, visited);
            if (pkg == null) continue;
            return pkg;
        }
        if ((JDKUtils.isJDKModule(this.getNameAsString()) || JDKUtils.isOracleJDKModule(this.getNameAsString())) && (languageModule = this.getModelLoader().getLanguageModule()) instanceof LazyModule && (pkg = this.findPackageInModule((LazyModule)languageModule, name)) != null) {
            return pkg;
        }
        if (JDKUtils.isJDKAnyPackage(name) || JDKUtils.isOracleJDKAnyPackage(name)) {
            return null;
        }
        if (defaultModule) {
            pkg = this.getModelLoader().findExistingPackage(this, name);
        }
        return pkg;
    }

    private Package findPackageInImport(String name, ModuleImport dependency, Set<Module> visited) {
        Module module = dependency.getModule();
        if (!visited.add(module)) {
            return null;
        }
        if (module instanceof LazyModule) {
            Package pkg = this.findPackageInModule((LazyModule)dependency.getModule(), name);
            if (pkg != null) {
                return pkg;
            }
            for (ModuleImport dep : module.getImports()) {
                if (!dep.isExport() || (pkg = this.findPackageInImport(name, dep, visited)) == null) continue;
                return pkg;
            }
            return null;
        }
        return module.getPackage(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Package findPackageInModule(LazyModule module, String name) {
        if (module.containsPackage(name)) {
            AbstractModelLoader modelLoader = this.getModelLoader();
            Object object = modelLoader.getLock();
            synchronized (object) {
                for (Package pkg : module.getPackages()) {
                    if (!pkg.getNameAsString().equals(name)) continue;
                    return pkg;
                }
                return this.getModelLoader().findExistingPackage(module, name);
            }
        }
        return null;
    }

    public Package findPackageNoLazyLoading(String name) {
        for (Package pkg : super.getPackages()) {
            if (!pkg.getNameAsString().equals(name)) continue;
            return pkg;
        }
        return null;
    }

    protected abstract AbstractModelLoader getModelLoader();

    @Override
    public boolean isJava() {
        return this.isJava;
    }

    public void setJava(boolean isJava) {
        this.isJava = isJava;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPackageList(ArtifactResult artifact) {
        if (artifact instanceof ContentAwareArtifactResult) {
            for (String entry : ((ContentAwareArtifactResult)artifact).getEntries()) {
                this.addPackageForPath(entry, artifact.filter());
            }
        } else {
            File file = artifact.artifact();
            if (file != null) {
                ZipFile zipFile;
                try {
                    zipFile = new ZipFile(artifact.artifact());
                }
                catch (IOException e) {
                    throw new RuntimeException("Error accessing artifact: " + artifact.artifact(), e);
                }
                try {
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        this.loadPackageList(entries.nextElement(), artifact.filter());
                    }
                }
                finally {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void loadPackageList(ZipEntry entry, PathFilter pathFilter) {
        if (!entry.isDirectory()) {
            String path = entry.getName();
            this.addPackageForPath(path, pathFilter);
        }
    }

    private void addPackageForPath(String path, PathFilter pathFilter) {
        if (path.toLowerCase().endsWith(".class") && !path.equals("module-info.class")) {
            int sep = path.lastIndexOf(47);
            path = sep != -1 ? path.substring(0, sep) : "";
            String pkg = path;
            pkg = pkg.replace("$", "");
            String pathQuery = path.isEmpty() ? pkg : pkg + "/";
            if (pathFilter == null || pathFilter.accept(pathQuery)) {
                pkg = pkg.replace('/', '.');
                this.jarPackages.add(pkg);
            }
        }
    }

    public boolean containsPackage(String pkgName) {
        String moduleName = this.getNameAsString();
        if (!this.isJava) {
            List<Package> superPackages = super.getPackages();
            int l = superPackages.size();
            for (int i = 0; i < l; ++i) {
                if (!superPackages.get(i).getNameAsString().equals(pkgName)) continue;
                return true;
            }
            if (moduleName.equals("ceylon.language")) {
                return JvmBackendUtil.isSubPackage(moduleName, pkgName) || pkgName.startsWith("com.redhat.ceylon.compiler.java.runtime") || pkgName.startsWith("com.redhat.ceylon.compiler.java.language") || pkgName.startsWith("com.redhat.ceylon.compiler.java.metadata");
            }
            return this.getJarPackages().contains(pkgName);
        }
        if (JDKUtils.isJDKPackage(moduleName, pkgName) || JDKUtils.isOracleJDKPackage(moduleName, pkgName)) {
            return true;
        }
        return this.getJarPackages().contains(pkgName);
    }

    @Override
    protected boolean isJdkModule(String moduleName) {
        return JDKUtils.isJDKModule(moduleName) || JDKUtils.isOracleJDKModule(moduleName);
    }

    @Override
    protected boolean isJdkPackage(String moduleName, String packageName) {
        return JDKUtils.isJDKPackage(moduleName, packageName) || JDKUtils.isOracleJDKPackage(moduleName, packageName);
    }

    public void addPackage(Package pkg) {
        super.getPackages().add(pkg);
    }

    public boolean isExportedJavaPackage(String name) {
        return this.exportedJavaPackages != null ? this.exportedJavaPackages.contains(name) : true;
    }

    public void setExportedJavaPackages(List<String> exportedPackages) {
        this.exportedJavaPackages = exportedPackages;
    }

    private void loadPackageListFromPackagePaths(Set<String> packagePaths) {
        for (String pkg : packagePaths) {
            pkg = pkg.replace("$", "");
            pkg = pkg.replace('/', '.');
            this.jarPackages.add(pkg);
        }
    }

    protected Set<String> getJarPackages() {
        if (this.packagePathsProvider != null) {
            this.loadPackageListFromPackagePaths(this.packagePathsProvider.getPackagePaths());
            this.packagePathsProvider = null;
        }
        return this.jarPackages;
    }

    public void setPackagePathsProvider(PackagePathsProvider packagePathsProvider) {
        this.packagePathsProvider = packagePathsProvider;
    }

    public static interface PackagePathsProvider {
        public Set<String> getPackagePaths();
    }
}

