/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.ModelLoader;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.model.AnnotationProxyClass;
import com.redhat.ceylon.model.loader.model.AnnotationTarget;
import com.redhat.ceylon.model.loader.model.LazyClass;
import com.redhat.ceylon.model.loader.model.LazyInterface;
import com.redhat.ceylon.model.loader.model.OutputElement;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LazyPackage
extends Package {
    private AbstractModelLoader modelLoader;
    private List<Declaration> compiledDeclarations = new ArrayList<Declaration>(3);
    private Set<Unit> lazyUnits = new HashSet<Unit>();
    private Map<String, Declaration> cache = new HashMap<String, Declaration>();

    public LazyPackage(AbstractModelLoader modelLoader) {
        this.modelLoader = modelLoader;
    }

    @Override
    public Declaration getMember(String name, List<Type> signature, boolean ellipsis) {
        return this.getDirectMember(name, signature, ellipsis);
    }

    @Override
    public Declaration getDirectMember(String name, List<Type> signature, boolean ellipsis) {
        Declaration cachedDeclaration;
        boolean canCache;
        boolean bl = canCache = signature == null && !ellipsis;
        if (canCache && this.cache.containsKey(name) && !this.modelLoader.searchAgain(cachedDeclaration = this.cache.get(name), this, name)) {
            return cachedDeclaration;
        }
        Declaration ret = this.getDirectMemberMemoised(name, signature, ellipsis, Backends.ANY);
        if (canCache) {
            this.cache.put(name, ret);
        }
        return ret;
    }

    @Override
    public Declaration getDirectMemberForBackend(String name, Backends backends) {
        return this.getDirectMemberMemoised(name, null, false, backends);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Declaration getDirectMemberMemoised(String name, List<Type> signature, boolean ellipsis, Backends backends) {
        Object object = this.modelLoader.getLock();
        synchronized (object) {
            Declaration d;
            String pkgName = this.getQualifiedNameString();
            Module module = this.getModule();
            this.modelLoader.loadPackage(module, pkgName, false);
            Declaration declaration = d = !backends.none() ? ModelUtil.lookupMemberForBackend(this.compiledDeclarations, name, backends) : ModelUtil.lookupMember(this.compiledDeclarations, name, signature, ellipsis);
            if (d != null) {
                return d;
            }
            String className = this.getQualifiedName(pkgName, name);
            ClassMirror classSymbol = this.modelLoader.lookupClassMirror(module, className);
            if (classSymbol != null && (!classSymbol.isLoadedFromSource() || classSymbol.isJavaSource())) {
                Class c;
                d = this.modelLoader.convertToDeclaration(module, className, ModelLoader.DeclarationType.VALUE);
                if (d instanceof Class && (c = (Class)d).isAbstraction() && signature != null) {
                    ArrayList<Declaration> list = new ArrayList<Declaration>(c.getOverloads());
                    list.add(c);
                    return !backends.none() ? ModelUtil.lookupMemberForBackend(list, name, backends) : ModelUtil.lookupMember(list, name, signature, ellipsis);
                }
                if (this.isForBackend(d, backends)) {
                    return d;
                }
            }
            if ((d = this.getDirectMemberFromSource(name, backends)) == null && Character.isLowerCase(name.codePointAt(0)) && Character.isUpperCase(Character.toUpperCase(name.codePointAt(0)))) {
                for (String annotationName : Arrays.asList(NamingBase.capitalize(name), NamingBase.getReverseJavaBeanName(name), NamingBase.capitalize(name).replaceFirst("__(CONSTRUCTOR|TYPE|PACKAGE|FIELD|METHOD|ANNOTATION_TYPE|LOCAL_VARIABLE|PARAMETER|SETTER|GETTER)$", ""))) {
                    Declaration possibleAnnotationType = this.getDirectMember(annotationName, signature, ellipsis);
                    if (possibleAnnotationType == null || !(possibleAnnotationType instanceof LazyInterface) || !((LazyInterface)possibleAnnotationType).isAnnotationType()) continue;
                    d = !backends.none() ? ModelUtil.lookupMemberForBackend(this.compiledDeclarations, name, backends) : ModelUtil.lookupMember(this.compiledDeclarations, name, signature, ellipsis);
                }
            }
            return d;
        }
    }

    private boolean isForBackend(Declaration d, Backends backends) {
        return backends.none() || d.getNativeBackends().none() || backends.supports(d.getNativeBackends());
    }

    private Declaration getDirectMemberFromSource(String name, Backends backends) {
        for (Declaration d : super.getMembers()) {
            if (!ModelUtil.isResolvable(d) || !ModelUtil.isNamed(name, d) || !this.isForBackend(d, backends)) continue;
            return d;
        }
        return null;
    }

    public String getQualifiedName(String pkgName, String name) {
        String className = pkgName.isEmpty() ? name : JVMModuleUtil.quoteJavaKeywords(pkgName) + "." + name;
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Declaration> getMembers() {
        Object object = this.modelLoader.getLock();
        synchronized (object) {
            this.modelLoader.loadPackage(this.getModule(), this.getQualifiedNameString(), true);
            List<Declaration> sourceDeclarations = super.getMembers();
            LinkedList<Declaration> ret = new LinkedList<Declaration>();
            ret.addAll(sourceDeclarations);
            ret.addAll(this.compiledDeclarations);
            return ret;
        }
    }

    @Override
    public void addMember(Declaration declaration) {
        super.addMember(declaration);
        this.flushCache(declaration);
    }

    private void flushCache(Declaration declaration) {
        this.cache.remove(declaration.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompiledMember(Declaration d) {
        Object object = this.modelLoader.getLock();
        synchronized (object) {
            this.flushCache(d);
            this.compiledDeclarations.add(d);
            if (d instanceof LazyInterface && !((LazyInterface)d).isCeylon() && ((LazyInterface)d).isAnnotationType()) {
                this.makeInteropAnnotation((LazyInterface)d);
            }
            if ((d instanceof LazyClass || d instanceof LazyInterface) && d.getUnit().getFilename() != null) {
                this.lazyUnits.add(d.getUnit());
            }
        }
    }

    private void makeInteropAnnotation(LazyInterface iface) {
        AnnotationProxyClass klass = this.modelLoader.makeInteropAnnotationClass(iface, this);
        this.compiledDeclarations.add(this.modelLoader.makeInteropAnnotationConstructor(iface, klass, null, this));
        for (OutputElement target : AnnotationTarget.outputTargets(klass)) {
            this.compiledDeclarations.add(this.modelLoader.makeInteropAnnotationConstructor(iface, klass, target, this));
        }
        this.compiledDeclarations.add(klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Unit> getUnits() {
        Object object = this.modelLoader.getLock();
        synchronized (object) {
            Iterable<Unit> sourceUnits = super.getUnits();
            LinkedList<Unit> ret = new LinkedList<Unit>();
            for (Unit unit : sourceUnits) {
                ret.add(unit);
            }
            ret.addAll(this.lazyUnits);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUnit(Unit unit) {
        Object object = this.modelLoader.getLock();
        synchronized (object) {
            for (Declaration d : unit.getDeclarations()) {
                this.flushCache(d);
                if (!(d instanceof TypeDeclaration)) continue;
                ((TypeDeclaration)d).clearProducedTypeCache();
            }
            if (unit.getFilename().endsWith(".class") || unit.getFilename().endsWith(".java")) {
                this.lazyUnits.remove(unit);
                for (Declaration d : unit.getDeclarations()) {
                    this.compiledDeclarations.remove(d);
                }
                this.modelLoader.removeDeclarations(unit.getDeclarations());
            } else {
                super.removeUnit(unit);
            }
        }
    }
}

