/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.ModelCompleter;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.model.LazyElement;
import com.redhat.ceylon.model.loader.model.LocalDeclarationContainer;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationKind;
import com.redhat.ceylon.model.typechecker.model.DeclarationWithProximity;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LazyValue
extends Value
implements LazyElement,
LocalDeclarationContainer {
    public ClassMirror classMirror;
    private ModelCompleter completer;
    private String realName;
    private Map<String, Declaration> localDeclarations;
    private boolean isLoaded = false;
    private boolean isLoaded2 = false;

    @Override
    protected Class<?> getModelClass() {
        return this.getClass().getSuperclass();
    }

    public LazyValue(ClassMirror classMirror, ModelCompleter completer) {
        this.classMirror = classMirror;
        this.completer = completer;
        this.realName = classMirror.getName();
        this.setName(JvmBackendUtil.getMirrorName(classMirror));
    }

    public String getRealName() {
        return this.realName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (!this.isLoaded2) {
            Object object = this.completer.getLock();
            synchronized (object) {
                if (!this.isLoaded) {
                    this.isLoaded = true;
                    this.completer.complete(this);
                    this.isLoaded2 = true;
                }
            }
        }
    }

    @Override
    public String toString() {
        if (!this.isLoaded) {
            return "UNLOADED:" + super.toString();
        }
        return super.toString();
    }

    @Override
    public boolean isVariable() {
        this.load();
        return super.isVariable();
    }

    @Override
    public Type getType() {
        this.load();
        return super.getType();
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public List<Annotation> getAnnotations() {
        this.load();
        return super.getAnnotations();
    }

    @Override
    public void setVariable(boolean variable) {
        this.load();
        super.setVariable(variable);
    }

    @Override
    public boolean isCaptured() {
        this.load();
        return super.isCaptured();
    }

    @Override
    public void setCaptured(boolean local) {
        this.load();
        super.setCaptured(local);
    }

    @Override
    public DeclarationKind getDeclarationKind() {
        this.load();
        return super.getDeclarationKind();
    }

    @Override
    public TypeDeclaration getTypeDeclaration() {
        this.load();
        return super.getTypeDeclaration();
    }

    @Override
    public void setType(Type type) {
        this.load();
        super.setType(type);
    }

    @Override
    public TypedReference appliedTypedReference(Type qualifyingType, List<Type> typeArguments, boolean assignment) {
        this.load();
        return super.appliedTypedReference(qualifyingType, typeArguments, assignment);
    }

    @Override
    public Reference appliedReference(Type pt, List<Type> typeArguments) {
        this.load();
        return super.appliedReference(pt, typeArguments);
    }

    @Override
    public boolean isMember() {
        this.load();
        return super.isMember();
    }

    @Override
    public Map<String, DeclarationWithProximity> getMatchingDeclarations(Unit unit, String startingWith, int proximity, Cancellable cancellable) {
        this.load();
        return super.getMatchingDeclarations(unit, startingWith, proximity, cancellable);
    }

    @Override
    public TypedDeclaration getOriginalDeclaration() {
        this.load();
        return super.getOriginalDeclaration();
    }

    @Override
    public void setOriginalDeclaration(TypedDeclaration originalDeclaration) {
        this.load();
        super.setOriginalDeclaration(originalDeclaration);
    }

    @Override
    public Boolean getUnboxed() {
        this.load();
        return super.getUnboxed();
    }

    @Override
    public Scope getVisibleScope() {
        this.load();
        return super.getVisibleScope();
    }

    @Override
    public void setVisibleScope(Scope visibleScope) {
        this.load();
        super.setVisibleScope(visibleScope);
    }

    @Override
    public boolean isParameterized() {
        this.load();
        return super.isParameterized();
    }

    @Override
    public String getQualifiedNameString() {
        return super.getQualifiedNameString();
    }

    @Override
    public boolean isActual() {
        this.load();
        return super.isActual();
    }

    @Override
    public void setActual(boolean actual) {
        this.load();
        super.setActual(actual);
    }

    @Override
    public boolean isFormal() {
        this.load();
        return super.isFormal();
    }

    @Override
    public void setFormal(boolean formal) {
        this.load();
        super.setFormal(formal);
    }

    @Override
    public boolean isDefault() {
        this.load();
        return super.isDefault();
    }

    @Override
    public void setDefault(boolean def) {
        this.load();
        super.setDefault(def);
    }

    @Override
    public Backends getNativeBackends() {
        return super.getNativeBackends();
    }

    @Override
    public void setNativeBackends(Backends backends) {
        super.setNativeBackends(backends);
    }

    @Override
    public Declaration getRefinedDeclaration() {
        this.load();
        return super.getRefinedDeclaration();
    }

    @Override
    public void setRefinedDeclaration(Declaration refinedDeclaration) {
        this.load();
        super.setRefinedDeclaration(refinedDeclaration);
    }

    @Override
    public boolean isVisible(Scope scope) {
        this.load();
        return super.isVisible(scope);
    }

    @Override
    public boolean isDefinedInScope(Scope scope) {
        this.load();
        return super.isDefinedInScope(scope);
    }

    @Override
    public boolean isToplevel() {
        return super.isToplevel();
    }

    @Override
    public boolean isClassMember() {
        return super.isClassMember();
    }

    @Override
    public boolean isInterfaceMember() {
        return super.isInterfaceMember();
    }

    @Override
    public boolean isClassOrInterfaceMember() {
        return super.isClassOrInterfaceMember();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean refines(Declaration other) {
        this.load();
        return super.refines(other);
    }

    @Override
    public List<Declaration> getMembers() {
        this.load();
        return super.getMembers();
    }

    @Override
    protected Declaration getMemberOrParameter(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getMemberOrParameter(name, signature, ellipsis);
    }

    @Override
    public Declaration getMember(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getMember(name, signature, ellipsis);
    }

    @Override
    public Declaration getDirectMember(String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getDirectMember(name, signature, ellipsis);
    }

    @Override
    public Type getDeclaringType(Declaration d) {
        this.load();
        return super.getDeclaringType(d);
    }

    @Override
    public Declaration getMemberOrParameter(Unit unit, String name, List<Type> signature, boolean ellipsis) {
        this.load();
        return super.getMemberOrParameter(unit, name, signature, ellipsis);
    }

    @Override
    public boolean isInherited(Declaration d) {
        this.load();
        return super.isInherited(d);
    }

    @Override
    public TypeDeclaration getInheritingDeclaration(Declaration d) {
        this.load();
        return super.getInheritingDeclaration(d);
    }

    @Override
    public void addMember(Declaration declaration) {
        super.addMember(declaration);
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public void setLocal(boolean local) {
    }

    @Override
    public Declaration getLocalDeclaration(String name) {
        this.load();
        if (this.localDeclarations == null) {
            return null;
        }
        return this.localDeclarations.get(name);
    }

    @Override
    public void addLocalDeclaration(Declaration declaration) {
        if (this.localDeclarations == null) {
            this.localDeclarations = new HashMap<String, Declaration>();
        }
        this.localDeclarations.put(declaration.getPrefixedName(), declaration);
    }

    @Override
    public boolean isDeprecated() {
        return super.isDeprecated();
    }

    @Override
    public boolean isCeylon() {
        return true;
    }
}

