/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.context;

import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class TypeCache {
    private static boolean cachingEnabledByDefault = true;
    private static final ThreadLocal<Boolean> cachingEnabled = new ThreadLocal();
    private static final Type NULL_VALUE = new UnknownType(null).getType();
    private final Map<Type, Map<TypeDeclaration, Type>> superTypes = new ConcurrentHashMap<Type, Map<TypeDeclaration, Type>>();

    public static void setEnabledByDefault(boolean enabled) {
        cachingEnabledByDefault = enabled;
    }

    public static Boolean setEnabled(Boolean enabled) {
        Boolean was = cachingEnabled.get();
        cachingEnabled.set(enabled);
        return was;
    }

    private static <T> T doWithExplicitCaching(boolean cacheEnabled, Callable<T> action) {
        Boolean was = TypeCache.setEnabled(cacheEnabled);
        try {
            T t = action.call();
            return t;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            TypeCache.setEnabled(was);
        }
    }

    private static void doWithExplicitCaching(boolean cacheEnabled, Runnable action) {
        Boolean was = TypeCache.setEnabled(cacheEnabled);
        try {
            action.run();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            TypeCache.setEnabled(was);
        }
    }

    public static <T> T doWithCaching(Callable<T> action) {
        return TypeCache.doWithExplicitCaching(true, action);
    }

    public static <T> T doWithoutCaching(Callable<T> action) {
        return TypeCache.doWithExplicitCaching(false, action);
    }

    public static void doWithCaching(Runnable action) {
        TypeCache.doWithExplicitCaching(true, action);
    }

    public static void doWithoutCaching(Runnable action) {
        TypeCache.doWithExplicitCaching(false, action);
    }

    public static boolean isEnabled() {
        Boolean cie = cachingEnabled.get();
        return cie == null ? cachingEnabledByDefault : cie;
    }

    public boolean containsKey(Type producedType, TypeDeclaration dec) {
        Map<TypeDeclaration, Type> cache = this.superTypes.get(producedType);
        if (cache == null) {
            return false;
        }
        return cache.containsKey(dec);
    }

    public Type get(Type producedType, TypeDeclaration dec) {
        Map<TypeDeclaration, Type> cache = this.superTypes.get(producedType);
        if (cache == null) {
            return null;
        }
        Type ret = cache.get(dec);
        return ret == NULL_VALUE ? null : ret;
    }

    public void put(Type producedType, TypeDeclaration dec, Type superType) {
        Map<TypeDeclaration, Type> cache = this.superTypes.get(producedType);
        if (cache == null) {
            cache = new ConcurrentHashMap<TypeDeclaration, Type>();
            this.superTypes.put(producedType, cache);
        }
        if (superType == null) {
            superType = NULL_VALUE;
        }
        cache.put(dec, superType);
    }

    public void clear() {
        this.superTypes.clear();
    }

    public void clearForDeclaration(TypeDeclaration decl) {
        this.clear();
    }

    public void clearNullValues() {
        LinkedList<Type> cachesToremove = new LinkedList<Type>();
        for (Map.Entry<Type, Map<TypeDeclaration, Type>> entry : this.superTypes.entrySet()) {
            Map<TypeDeclaration, Type> cache = entry.getValue();
            if (cache == null) {
                cachesToremove.add(entry.getKey());
                continue;
            }
            LinkedList<TypeDeclaration> valuesToremove = new LinkedList<TypeDeclaration>();
            for (Map.Entry<TypeDeclaration, Type> cacheEntry : cache.entrySet()) {
                if (cacheEntry.getValue() != NULL_VALUE) continue;
                valuesToremove.add(cacheEntry.getKey());
            }
            for (TypeDeclaration toRemove : valuesToremove) {
                cache.remove(toRemove);
            }
        }
        for (Type toRemove : cachesToremove) {
            this.superTypes.remove(toRemove);
        }
    }
}

