/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Class
extends ClassOrInterface
implements Functional {
    private static final int CONSTRUCTORS = 2048;
    private static final int ENUMERATED = 4096;
    private static final int ABSTRACT = 8192;
    private static final int FINAL = 16384;
    private static final int SERIALIZABLE = 32768;
    private static final int ANONYMOUS = 65536;
    private static final int JAVA_ENUM = 131072;
    private static final int VALUE_CONSTRUCTOR = 262144;
    private static final int OVERLOADED = 524288;
    private static final int ABSTRACTION = 0x100000;
    private static final int NO_NAME = 0x1000000;
    private ParameterList parameterList;
    private List<Reference> unimplementedFormals = Collections.emptyList();
    private int sequentialType;
    private int sequenceType;

    public boolean hasConstructors() {
        return (this.flags & 0x800) != 0;
    }

    public void setConstructors(boolean constructors) {
        this.flags = constructors ? (this.flags |= 0x800) : (this.flags &= 0xFFFFF7FF);
    }

    public boolean hasEnumerated() {
        return (this.flags & 0x1000) != 0;
    }

    public void setEnumerated(boolean enumerated) {
        this.flags = enumerated ? (this.flags |= 0x1000) : (this.flags &= 0xFFFFEFFF);
    }

    @Override
    public boolean isValueConstructor() {
        return (this.flags & 0x40000) != 0;
    }

    public void setValueConstructor(boolean valueConstructor) {
        this.flags = valueConstructor ? (this.flags |= 0x40000) : (this.flags &= 0xFFFBFFFF);
    }

    @Override
    public boolean isAnonymous() {
        return (this.flags & 0x10000) != 0;
    }

    public void setAnonymous(boolean anonymous) {
        this.flags = anonymous ? (this.flags |= 0x10000) : (this.flags &= 0xFFFEFFFF);
    }

    @Override
    public boolean isObjectClass() {
        return (this.flags & 0x10000) != 0;
    }

    @Override
    public boolean isNamed() {
        return (this.flags & 0x1000000) == 0;
    }

    public void setNamed(boolean named) {
        this.flags = !named ? (this.flags |= 0x1000000) : (this.flags &= 0xFEFFFFFF);
    }

    @Override
    public boolean isAbstract() {
        return (this.flags & 0x2000) != 0;
    }

    public void setAbstract(boolean abstr) {
        this.flags = abstr ? (this.flags |= 0x2000) : (this.flags &= 0xFFFFDFFF);
    }

    public Constructor getDefaultConstructor() {
        if (this.hasConstructors()) {
            for (Declaration dec : this.getMembers()) {
                if (!(dec instanceof Constructor) || dec.getName() != null) continue;
                return (Constructor)dec;
            }
            return null;
        }
        return null;
    }

    public FunctionOrValue getDefaultConstructorFunctionOrValue() {
        if (this.hasConstructors()) {
            for (Declaration dec : this.getMembers()) {
                if (!(dec instanceof FunctionOrValue) || dec.getName() != null) continue;
                return (FunctionOrValue)dec;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isSealed() {
        if (this.parameterList == null) {
            Constructor defaultConstructor = this.getDefaultConstructor();
            return defaultConstructor != null && defaultConstructor.isSealed();
        }
        return super.isSealed();
    }

    @Override
    public ParameterList getFirstParameterList() {
        return this.getParameterList();
    }

    public ParameterList getParameterList() {
        if (this.hasConstructors()) {
            Constructor defaultConstructor = this.getDefaultConstructor();
            if (defaultConstructor == null) {
                return null;
            }
            if (defaultConstructor.getParameterLists().isEmpty()) {
                return null;
            }
            return defaultConstructor.getFirstParameterList();
        }
        return this.parameterList;
    }

    public void setParameterList(ParameterList parameterList) {
        this.parameterList = parameterList;
    }

    @Override
    public List<ParameterList> getParameterLists() {
        ParameterList parameterList = this.getParameterList();
        if (parameterList == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(parameterList);
    }

    @Override
    public void addParameterList(ParameterList pl) {
        this.parameterList = pl;
    }

    @Override
    public Parameter getParameter(String name) {
        for (Declaration d : this.getMembers()) {
            if (!d.isParameter() || !ModelUtil.isNamed(name, d)) continue;
            FunctionOrValue fov = (FunctionOrValue)d;
            return fov.getInitializerParameter();
        }
        return null;
    }

    @Override
    public boolean isOverloaded() {
        return (this.flags & 0x80000) != 0;
    }

    public void setOverloaded(boolean overloaded) {
        this.flags = overloaded ? (this.flags |= 0x80000) : (this.flags &= 0xFFF7FFFF);
    }

    @Override
    public Type getExtendedType() {
        Type et = super.getExtendedType();
        if (et == null) {
            return null;
        }
        if (et.isUnknown()) {
            return et;
        }
        if (et.isClass()) {
            return et;
        }
        return this.unit.getAnythingType();
    }

    public void setAbstraction(boolean abstraction) {
        this.flags = abstraction ? (this.flags |= 0x100000) : (this.flags &= 0xFFEFFFFF);
    }

    @Override
    public boolean isAbstraction() {
        return (this.flags & 0x100000) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.flags & 0x4000) != 0 || (this.flags & 0x10000) != 0;
    }

    public void setFinal(boolean fin) {
        this.flags = fin ? (this.flags |= 0x4000) : (this.flags &= 0xFFFFBFFF);
    }

    @Override
    public boolean isDeclaredVoid() {
        return false;
    }

    @Override
    public boolean isFunctional() {
        return true;
    }

    @Override
    public boolean isAnything() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Anything");
    }

    @Override
    public boolean isObject() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Object");
    }

    @Override
    public boolean isNull() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Null");
    }

    @Override
    public boolean isNullValue() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::null");
    }

    @Override
    boolean isEmptyValue() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::empty");
    }

    @Override
    public boolean isBasic() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Basic");
    }

    @Override
    public boolean isBoolean() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Boolean");
    }

    @Override
    public boolean isString() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::String");
    }

    @Override
    public boolean isCharacter() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Character");
    }

    @Override
    public boolean isFloat() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Float");
    }

    @Override
    public boolean isInteger() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Integer");
    }

    @Override
    public boolean isByte() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Byte");
    }

    @Override
    public boolean isTuple() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Tuple");
    }

    @Override
    public boolean isEntry() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Entry");
    }

    @Override
    public boolean isRange() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Range");
    }

    @Override
    public boolean inherits(TypeDeclaration dec) {
        if (dec == null) {
            return false;
        }
        if (dec.isAnything()) {
            return true;
        }
        if (dec.isObject()) {
            return !this.isAnything() && !this.isNull() && !this.isNullValue();
        }
        if (dec.isNull()) {
            return this.isNull() || this.isNullValue();
        }
        if (dec instanceof Class && this.equals(dec)) {
            return true;
        }
        if (dec.isFinal() && !dec.isAbstraction()) {
            return false;
        }
        Type et = this.getExtendedType();
        if (et != null && et.getDeclaration().inherits(dec)) {
            return true;
        }
        if (dec instanceof Interface) {
            List<Type> sts = this.getSatisfiedTypes();
            int s = sts.size();
            for (int i = 0; i < s; ++i) {
                Type st = sts.get(i);
                if (!st.getDeclaration().inherits(dec)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Reference> getUnimplementedFormals() {
        return this.unimplementedFormals;
    }

    public void setUnimplementedFormals(List<Reference> unimplementedFormals) {
        this.unimplementedFormals = unimplementedFormals;
    }

    public boolean isSerializable() {
        return (this.flags & 0x8000) != 0;
    }

    public void setSerializable(boolean serializable) {
        this.flags = serializable ? (this.flags |= 0x8000) : (this.flags &= 0xFFFF7FFF);
    }

    @Override
    public boolean isJavaEnum() {
        return (this.flags & 0x20000) != 0;
    }

    public void setJavaEnum(boolean javaEnum) {
        this.flags = javaEnum ? (this.flags |= 0x20000) : (this.flags &= 0xFFFDFFFF);
    }

    @Override
    public boolean isEmptyType() {
        return this.isEmptyValue();
    }

    @Override
    public boolean isTupleType() {
        return this.isTuple();
    }

    @Override
    public boolean isSequentialType() {
        if (this.sequentialType == 0) {
            this.sequentialType = this.isSequentialTypeInternal() ? 1 : -1;
        }
        return this.sequentialType > 0;
    }

    @Override
    public boolean isSequenceType() {
        if (this.sequenceType == 0) {
            this.sequenceType = this.isSequenceTypeInternal() ? 1 : -1;
        }
        return this.sequenceType > 0;
    }

    private boolean isSequentialTypeInternal() {
        Package pack = this.getUnit().getPackage();
        if (!pack.getNameAsString().equals("ceylon.language")) {
            return false;
        }
        if (this.isAnything() || this.isObject() || this.isNull() || this.isBasic()) {
            return false;
        }
        if (this.isEmptyValue() || this.isRange() || this.isTuple()) {
            return true;
        }
        Type et = this.getExtendedType();
        if (et != null && et.isRange()) {
            return true;
        }
        List<Type> sts = this.getSatisfiedTypes();
        for (Type st : sts) {
            if (!st.isSequence()) continue;
            return true;
        }
        return false;
    }

    private boolean isSequenceTypeInternal() {
        Package pack = this.getUnit().getPackage();
        if (!pack.getNameAsString().equals("ceylon.language")) {
            return false;
        }
        if (this.isAnything() || this.isObject() || this.isNull() || this.isBasic()) {
            return false;
        }
        if (this.isRange() || this.isTuple()) {
            return true;
        }
        Type et = this.getExtendedType();
        if (et != null && et.isRange()) {
            return true;
        }
        List<Type> sts = this.getSatisfiedTypes();
        for (Type st : sts) {
            if (!st.isSequence()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder params = new StringBuilder();
        ParameterList list = this.getParameterList();
        if (list != null) {
            params.append("(");
            boolean first = true;
            for (Parameter p : list.getParameters()) {
                if (first) {
                    first = false;
                } else {
                    params.append(", ");
                }
                if (p.getType() != null) {
                    params.append(p.getType().asString());
                    params.append(" ");
                }
                params.append(p.getName());
            }
            params.append(")");
        }
        return "class " + this.toStringName() + params;
    }
}

