/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationKind;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class ClassOrInterface
extends TypeDeclaration {
    private List<Declaration> members = new ArrayList<Declaration>(3);
    private List<Annotation> annotations = new ArrayList<Annotation>(4);
    private List<TypeParameter> typeParameters = Collections.emptyList();
    private List<Declaration> overloads;

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<Declaration> getMembers() {
        return this.members;
    }

    @Override
    public void addMember(Declaration declaration) {
        this.members.add(declaration);
    }

    @Override
    public boolean isMember() {
        return this.getContainer() instanceof ClassOrInterface;
    }

    @Override
    public Type getDeclaringType(Declaration d) {
        if (d.isMember()) {
            TypeDeclaration ctd = (TypeDeclaration)d.getContainer();
            Type st = this.getType().getSupertype(ctd);
            if (st != null) {
                return st;
            }
            return this.getContainer().getDeclaringType(d);
        }
        return null;
    }

    @Override
    public boolean isParameterized() {
        return !this.typeParameters.isEmpty();
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public void setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
    }

    @Override
    public List<Declaration> getOverloads() {
        return this.overloads;
    }

    public void setOverloads(List<Declaration> overloads) {
        this.overloads = overloads;
    }

    public void initOverloads(ClassOrInterface ... initial) {
        this.overloads = new ArrayList<Declaration>(initial.length + 1);
        for (ClassOrInterface d : initial) {
            this.overloads.add(d);
        }
    }

    @Override
    public DeclarationKind getDeclarationKind() {
        return DeclarationKind.TYPE;
    }

    @Override
    public Type getExtendedType() {
        Type et = super.getExtendedType();
        if (et == null) {
            return null;
        }
        TypeDeclaration etd = et.getDeclaration();
        if (etd == this || et.isTypeAlias()) {
            return this.unit.getAnythingType();
        }
        return et;
    }

    @Override
    public List<Type> getSatisfiedTypes() {
        List<Type> satisfiedTypes;
        List<Type> sts = satisfiedTypes = super.getSatisfiedTypes();
        int size = sts.size();
        for (int i = 0; i < size; ++i) {
            TypeDeclaration std;
            Type st = sts.get(i);
            if (st == null || (std = st.getDeclaration()) != this && !st.isTypeAlias()) continue;
            if (sts == satisfiedTypes) {
                sts = new ArrayList<Type>(sts);
            }
            sts.remove(i);
            --size;
            --i;
        }
        return sts;
    }

    @Override
    public List<Type> getCaseTypes() {
        List<Type> caseTypes = super.getCaseTypes();
        List<Type> cts = caseTypes;
        if (cts != null) {
            int size = cts.size();
            for (int i = 0; i < size; ++i) {
                TypeDeclaration ctd;
                Type ct = cts.get(i);
                if (ct == null || (ctd = ct.getDeclaration()) != this && !ct.isTypeAlias()) continue;
                if (cts == caseTypes) {
                    cts = new ArrayList<Type>(cts);
                }
                cts.remove(i);
                --i;
                --size;
            }
        }
        return cts;
    }

    @Override
    void collectSupertypeDeclarations(List<TypeDeclaration> results) {
        if (!results.contains(this)) {
            results.add(this);
            Type et = this.getExtendedType();
            List<Type> stds = this.getSatisfiedTypes();
            if (et != null) {
                et.getDeclaration().collectSupertypeDeclarations(results);
            }
            int l = stds.size();
            for (int i = 0; i < l; ++i) {
                Type st = stds.get(i);
                st.getDeclaration().collectSupertypeDeclarations(results);
            }
        }
    }

    @Override
    protected int hashCodeForCache() {
        int ret = 17;
        ret = ModelUtil.addHashForModule(ret, this);
        if (this.isToplevel()) {
            ret = 37 * ret + this.getQualifiedNameString().hashCode();
        } else {
            ret = 37 * ret + this.getContainer().hashCode();
            ret = 37 * ret + Objects.hashCode(this.getName());
        }
        return ret;
    }

    @Override
    protected boolean equalsForCache(Object o) {
        if (o == null || !(o instanceof ClassOrInterface)) {
            return false;
        }
        ClassOrInterface b = (ClassOrInterface)o;
        if (!ModelUtil.sameModule(this, b)) {
            return false;
        }
        if (this.isToplevel()) {
            if (!b.isToplevel()) {
                return false;
            }
            return this.getQualifiedNameString().equals(b.getQualifiedNameString());
        }
        if (b.isToplevel()) {
            return false;
        }
        return this.getContainer().equals(b.getContainer()) && Objects.equals(this.getName(), b.getName());
    }

    @Override
    public void clearProducedTypeCache() {
        ModelUtil.clearProducedTypeCache(this);
    }
}

