/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.typechecker.model.Annotated;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.DeclarationCompleter;
import com.redhat.ceylon.model.typechecker.model.DeclarationKind;
import com.redhat.ceylon.model.typechecker.model.Element;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Referenceable;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class Declaration
extends Element
implements Referenceable,
Annotated {
    private static final int SHARED = 1;
    private static final int FORMAL = 2;
    private static final int ACTUAL = 4;
    private static final int DEFAULT = 8;
    private static final int ANNOTATION = 16;
    private static final int DEPRECATED = 32;
    private static final int PROTECTED = 256;
    private static final int PACKAGE = 512;
    private static final int STATIC = 1024;
    private String name;
    protected int flags;
    private String qualifier;
    private Scope visibleScope;
    private Declaration refinedDeclaration = this;
    private String qualifiedNameAsStringCache;
    private Backends nativeBackends = Backends.ANY;
    private boolean otherInstanceAccess;
    private DeclarationCompleter actualCompleter;
    private List<String> aliases;

    public Scope getVisibleScope() {
        return this.visibleScope;
    }

    public void setVisibleScope(Scope visibleScope) {
        this.visibleScope = visibleScope;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isShared() {
        return (this.flags & 1) != 0;
    }

    public void setShared(boolean shared) {
        this.flags = shared ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean isDeprecated() {
        return (this.flags & 0x20) != 0;
    }

    public void setDeprecated(boolean deprecated) {
        this.flags = deprecated ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    String toStringName() {
        Generic g;
        List<TypeParameter> typeParams;
        Scope c;
        String name = this.getName();
        if (name == null) {
            name = "";
        }
        if ((c = this.getContainer()) instanceof Declaration) {
            Declaration d = (Declaration)((Object)c);
            name = d.toStringName() + "." + name;
        }
        if (this instanceof Generic && !(typeParams = (g = (Generic)((Object)this)).getTypeParameters()).isEmpty()) {
            StringBuilder params = new StringBuilder();
            params.append("<");
            boolean first = true;
            for (TypeParameter tp : typeParams) {
                if (first) {
                    first = false;
                } else {
                    params.append(",");
                }
                params.append(tp.getName());
            }
            params.append(">");
            name = name + params;
        }
        return name;
    }

    public abstract String toString();

    @Override
    public String getQualifiedNameString() {
        if (this.qualifiedNameAsStringCache == null) {
            String qualifier = this.getContainer().getQualifiedNameString();
            String name = this.getName();
            this.qualifiedNameAsStringCache = qualifier == null || qualifier.isEmpty() ? name : (this.getContainer() instanceof Package ? qualifier + "::" + name : qualifier + "." + name);
        }
        return this.qualifiedNameAsStringCache;
    }

    public boolean isAnnotation() {
        return (this.flags & 0x10) != 0;
    }

    public void setAnnotation(boolean annotation) {
        this.flags = annotation ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public boolean isActual() {
        if (this.actualCompleter != null) {
            this.completeActual();
        }
        return (this.flags & 4) != 0;
    }

    public void setActual(boolean actual) {
        this.flags = actual ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean isFormal() {
        return (this.flags & 2) != 0;
    }

    public void setFormal(boolean formal) {
        this.flags = formal ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isNative() {
        return !this.getNativeBackends().none();
    }

    public boolean isNativeHeader() {
        return this.getNativeBackends().header();
    }

    public boolean isNativeImplementation() {
        return this.isNative() && !this.isNativeHeader();
    }

    public Backends getNativeBackends() {
        return this.nativeBackends;
    }

    public void setNativeBackends(Backends backends) {
        this.nativeBackends = backends;
    }

    public Backends getScopedBackends() {
        Backends backends = this.getNativeBackends();
        if (backends.none()) {
            return this.getScope().getScopedBackends();
        }
        return backends;
    }

    public boolean isDefault() {
        return (this.flags & 8) != 0;
    }

    public void setDefault(boolean def) {
        this.flags = def ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public Declaration getRefinedDeclaration() {
        if (this.actualCompleter != null) {
            this.completeActual();
        }
        return this.refinedDeclaration;
    }

    private void completeActual() {
        DeclarationCompleter completer = this.actualCompleter;
        this.actualCompleter = null;
        completer.completeActual(this);
    }

    public void setRefinedDeclaration(Declaration refinedDeclaration) {
        this.refinedDeclaration = refinedDeclaration;
    }

    public boolean isVisible(Scope scope) {
        Scope vs = this.getVisibleScope();
        if (vs == null) {
            return true;
        }
        return ModelUtil.contains(vs, scope);
    }

    public boolean isDefinedInScope(Scope scope) {
        while (scope != null) {
            if (this.getContainer() == scope) {
                return true;
            }
            scope = scope.getContainer();
        }
        return false;
    }

    public boolean isCaptured() {
        return false;
    }

    public boolean isToplevel() {
        return this.getContainer() instanceof Package;
    }

    public boolean isClassMember() {
        return this.getContainer() instanceof Class;
    }

    public boolean isInterfaceMember() {
        return this.getContainer() instanceof Interface;
    }

    public boolean isClassOrInterfaceMember() {
        return this.getContainer() instanceof ClassOrInterface;
    }

    public boolean isMember() {
        return false;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return Collections.emptyList();
    }

    public boolean isStaticallyImportable() {
        return (this.flags & 0x400) != 0;
    }

    public void setStaticallyImportable(boolean staticallyImportable) {
        this.flags = staticallyImportable ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
    }

    public boolean isProtectedVisibility() {
        return (this.flags & 0x100) != 0;
    }

    public void setProtectedVisibility(boolean protectedVisibility) {
        this.flags = protectedVisibility ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    public boolean isPackageVisibility() {
        return (this.flags & 0x200) != 0;
    }

    public void setPackageVisibility(boolean packageVisibility) {
        this.flags = packageVisibility ? (this.flags |= 0x200) : (this.flags &= 0xFFFFFDFF);
    }

    public abstract Reference appliedReference(Type var1, List<Type> var2);

    public abstract Reference getReference();

    protected java.lang.Class<?> getModelClass() {
        return this.getClass();
    }

    private Scope getAbstraction(Scope container) {
        Class c;
        if (container instanceof Class && ModelUtil.isOverloadedVersion(c = (Class)container)) {
            return c.getExtendedType().getDeclaration();
        }
        return container;
    }

    Type getMemberContainerType() {
        if (this.isMember() && (!this.isStaticallyImportable() || this.isJavaEnum())) {
            ClassOrInterface container = (ClassOrInterface)this.getContainer();
            return container.getType();
        }
        return null;
    }

    public boolean isAbstraction() {
        return false;
    }

    public boolean isOverloaded() {
        return false;
    }

    public List<Declaration> getOverloads() {
        return Collections.emptyList();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Declaration) {
            Declaration that = (Declaration)object;
            String thisName = this.getName();
            String thatName = that.getName();
            if (!Objects.equals(this.getQualifier(), that.getQualifier())) {
                return false;
            }
            if (this.getModelClass() != that.getModelClass()) {
                return false;
            }
            Scope thisContainer = this.getAbstraction(this.getContainer());
            Scope thatContainer = this.getAbstraction(that.getContainer());
            if (thisName != thatName && (thisName == null || thatName == null || !thisName.equals(thatName)) || that.getDeclarationKind() != this.getDeclarationKind() || thisContainer == null || thatContainer == null || !thisContainer.equals(thatContainer)) {
                return false;
            }
            if (this instanceof Functional && that instanceof Functional) {
                boolean thisIsAbstraction = this.isAbstraction();
                boolean thatIsAbstraction = that.isAbstraction();
                boolean thisIsOverloaded = this.isOverloaded();
                boolean thatIsOverloaded = that.isOverloaded();
                if (thisIsAbstraction != thatIsAbstraction || thisIsOverloaded != thatIsOverloaded) {
                    return false;
                }
                if (!thisIsOverloaded && !thatIsOverloaded) {
                    return true;
                }
                if (thisIsAbstraction && thatIsAbstraction) {
                    return true;
                }
                Functional thisFunction = (Functional)((Object)this);
                Functional thatFunction = (Functional)((Object)that);
                List<ParameterList> thisParamLists = thisFunction.getParameterLists();
                List<ParameterList> thatParamLists = thatFunction.getParameterLists();
                if (thisParamLists.size() != thatParamLists.size()) {
                    return false;
                }
                for (int i = 0; i < thisParamLists.size(); ++i) {
                    List<Parameter> thisParams = thisParamLists.get(i).getParameters();
                    List<Parameter> thatParams = thatParamLists.get(i).getParameters();
                    if (thisParams.size() != thatParams.size()) {
                        return false;
                    }
                    for (int j = 0; j < thisParams.size(); ++j) {
                        Parameter thatParam;
                        Parameter thisParam = thisParams.get(j);
                        if (thisParam == (thatParam = thatParams.get(j))) continue;
                        if (thisParam != null && thatParam != null) {
                            Type thisParamType = thisParam.getType();
                            Type thatParamType = thatParam.getType();
                            if (!(thisParamType != null && thatParamType != null ? !ModelUtil.erase(thisParamType, this.unit).equals(ModelUtil.erase(thatParamType, this.unit)) : thisParamType != thatParamType)) continue;
                            return false;
                        }
                        if (thisParam == thatParam) continue;
                        return false;
                    }
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int ret = 17;
        Scope container = this.getContainer();
        ret = 37 * ret + (container == null ? 0 : container.hashCode());
        String qualifier = this.getQualifier();
        ret = 37 * ret + (qualifier == null ? 0 : qualifier.hashCode());
        String name = this.getName();
        ret = 37 * ret + (name == null ? 0 : name.hashCode());
        ret = 37 * ret + (this.isSetter() ? 0 : 1);
        ret = 37 * ret + (this.isAnonymous() ? 0 : 1);
        return ret;
    }

    public boolean refines(Declaration other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.isClassOrInterfaceMember()) {
            ClassOrInterface type = (ClassOrInterface)this.getContainer();
            return other.getName() != null && this.getName() != null && other.getName().equals(this.getName()) && this.isShared() && other.isShared() && type.isMember(other);
        }
        return false;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isNamed() {
        return true;
    }

    public boolean isJavaEnum() {
        return false;
    }

    public abstract DeclarationKind getDeclarationKind();

    @Override
    public String getNameAsString() {
        return this.getName();
    }

    public String getName(Unit unit) {
        return unit == null ? this.getName() : unit.getAliasedName(this);
    }

    public boolean getOtherInstanceAccess() {
        return this.otherInstanceAccess;
    }

    public void setOtherInstanceAccess(boolean access) {
        this.otherInstanceAccess = access;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isSetter() {
        return false;
    }

    public boolean isFunctional() {
        return false;
    }

    protected abstract int hashCodeForCache();

    protected abstract boolean equalsForCache(Object var1);

    public String getQualifier() {
        return this.isParameter() ? null : this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String getPrefixedName() {
        String qualifier = this.getQualifier();
        return qualifier == null || this.isParameter() ? this.name : qualifier + this.name;
    }

    public boolean sameKind(Declaration m) {
        return m != null && m.getModelClass() == this.getModelClass();
    }

    public DeclarationCompleter getActualCompleter() {
        return this.actualCompleter;
    }

    public void setActualCompleter(DeclarationCompleter actualCompleter) {
        this.actualCompleter = actualCompleter;
    }

    Map<TypeParameter, Type> getTypeParametersAsArguments() {
        if (this instanceof Generic) {
            Generic g = (Generic)((Object)this);
            List<TypeParameter> typeParameters = g.getTypeParameters();
            if (typeParameters.isEmpty()) {
                return ModelUtil.EMPTY_TYPE_ARG_MAP;
            }
            HashMap<TypeParameter, Type> typeArgs = new HashMap<TypeParameter, Type>();
            for (TypeParameter p : typeParameters) {
                Type pta = new Type();
                if (p.isTypeConstructor()) {
                    pta.setTypeConstructor(true);
                    pta.setTypeConstructorParameter(p);
                }
                pta.setDeclaration(p);
                typeArgs.put(p, pta);
            }
            return typeArgs;
        }
        return ModelUtil.EMPTY_TYPE_ARG_MAP;
    }

    public List<String> getAliases() {
        return this.aliases != null ? this.aliases : Collections.emptyList();
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }
}

