/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Import;
import com.redhat.ceylon.model.typechecker.model.NamedArgumentList;
import com.redhat.ceylon.model.typechecker.model.Parameter;

public class DeclarationWithProximity {
    private Declaration declaration;
    private int proximity;
    private String name;
    private NamedArgumentList namedArgumentList;
    private boolean unimported;
    private boolean alias;

    public NamedArgumentList getNamedArgumentList() {
        return this.namedArgumentList;
    }

    public DeclarationWithProximity(Parameter parameter, NamedArgumentList nal) {
        this.declaration = parameter.getModel();
        this.proximity = 0;
        this.name = this.declaration.getName();
        this.namedArgumentList = nal;
    }

    public DeclarationWithProximity(Declaration declaration, int proximity) {
        this.declaration = declaration;
        this.proximity = proximity;
        this.name = declaration.getName();
    }

    public DeclarationWithProximity(Declaration declaration, int proximity, boolean unimported) {
        this.declaration = declaration;
        this.proximity = proximity;
        this.name = declaration.getName();
        this.unimported = unimported;
    }

    public DeclarationWithProximity(Declaration declaration, DeclarationWithProximity dwp) {
        this.declaration = declaration;
        this.proximity = dwp.proximity;
        this.name = dwp.name;
        this.unimported = dwp.unimported;
    }

    public DeclarationWithProximity(Import imp, int proximity) {
        this.declaration = imp.getDeclaration();
        this.proximity = proximity;
        this.name = imp.getAlias();
    }

    public DeclarationWithProximity(String alias, Declaration member, int proximity) {
        this.name = alias;
        this.alias = true;
        this.declaration = member;
        this.proximity = proximity;
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public int getProximity() {
        return this.proximity;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnimported() {
        return this.unimported;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public String toString() {
        return this.name + ":" + this.declaration.toString() + "@" + this.proximity + "(alias: " + this.alias + ")";
    }
}

