/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationWithProximity;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class Element {
    private Scope container;
    private Scope scope;
    protected Unit unit;

    Element() {
    }

    public List<Declaration> getMembers() {
        return Collections.emptyList();
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit compilationUnit) {
        this.unit = compilationUnit;
    }

    public Scope getContainer() {
        return this.container;
    }

    public void setContainer(Scope scope) {
        this.container = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public String getQualifiedNameString() {
        return this.getContainer().getQualifiedNameString();
    }

    public Declaration getDirectMember(String name, List<Type> signature, boolean variadic) {
        return this.getDirectMember(name, signature, variadic, false);
    }

    public Declaration getDirectMember(String name, List<Type> signature, boolean variadic, boolean onlyExactMatches) {
        return ModelUtil.lookupMember(this.getMembers(), name, signature, variadic, onlyExactMatches);
    }

    public Declaration getDirectMemberForBackend(String name, Backends backends) {
        return ModelUtil.lookupMemberForBackend(this.getMembers(), name, backends);
    }

    public Declaration getMember(String name, List<Type> signature, boolean variadic, boolean onlyExactMatches) {
        return this.getDirectMember(name, signature, variadic, onlyExactMatches);
    }

    public Declaration getMember(String name, List<Type> signature, boolean variadic) {
        return this.getMember(name, signature, variadic, false);
    }

    public Declaration getMemberOrParameter(Unit unit, String name, List<Type> signature, boolean variadic) {
        return this.getMemberOrParameter(unit, name, signature, variadic, false);
    }

    public Declaration getMemberOrParameter(Unit unit, String name, List<Type> signature, boolean variadic, boolean onlyExactMatches) {
        Declaration d = this.getMemberOrParameter(name, signature, variadic);
        if (d != null) {
            return d;
        }
        if (this.getScope() != null) {
            return this.getScope().getMemberOrParameter(unit, name, signature, variadic);
        }
        return null;
    }

    protected Declaration getMemberOrParameter(String name, List<Type> signature, boolean variadic) {
        return this.getMemberOrParameter(name, signature, variadic, false);
    }

    protected Declaration getMemberOrParameter(String name, List<Type> signature, boolean variadic, boolean onlyExactMatches) {
        return this.getDirectMember(name, signature, variadic, onlyExactMatches);
    }

    public boolean isInherited(Declaration d) {
        if (d.getContainer() == this) {
            return false;
        }
        if (this.getContainer() != null) {
            return this.getContainer().isInherited(d);
        }
        return false;
    }

    public TypeDeclaration getInheritingDeclaration(Declaration d) {
        if (d.getContainer() == this) {
            return null;
        }
        if (this.getContainer() != null) {
            return this.getContainer().getInheritingDeclaration(d);
        }
        return null;
    }

    public Type getDeclaringType(Declaration d) {
        if (d.isMember()) {
            return this.getContainer().getDeclaringType(d);
        }
        return null;
    }

    public Map<String, DeclarationWithProximity> getMatchingDeclarations(Unit unit, String startingWith, int proximity, Cancellable canceller) {
        Map<String, DeclarationWithProximity> result = this.getScope().getMatchingDeclarations(unit, startingWith, proximity + 1, canceller);
        for (Declaration d : this.getMembers()) {
            if (!ModelUtil.isResolvable(d) || ModelUtil.isOverloadedVersion(d)) continue;
            if (ModelUtil.isNameMatching(startingWith, d)) {
                result.put(d.getName(unit), new DeclarationWithProximity(d, proximity));
            }
            for (String alias : d.getAliases()) {
                if (!ModelUtil.isNameMatching(startingWith, alias)) continue;
                result.put(alias, new DeclarationWithProximity(alias, d, proximity));
            }
        }
        return result;
    }
}

