/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Function
extends FunctionOrValue
implements Generic,
Scope,
Functional {
    private static final int VOID = 0x400000;
    private static final int DEFERRED = 0x800000;
    private static final int NO_NAME = 0x1000000;
    private List<TypeParameter> typeParameters = Collections.emptyList();
    private List<ParameterList> parameterLists = new ArrayList<ParameterList>(1);
    private Object annotationConstructor;

    public Object getAnnotationConstructor() {
        return this.annotationConstructor;
    }

    public void setAnnotationConstructor(Object annotationInstantiation) {
        this.annotationConstructor = annotationInstantiation;
    }

    @Override
    public boolean isParameterized() {
        return !this.typeParameters.isEmpty();
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public void setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
    }

    @Override
    public ParameterList getFirstParameterList() {
        return this.getParameterLists().get(0);
    }

    @Override
    public List<ParameterList> getParameterLists() {
        return this.parameterLists;
    }

    @Override
    public void addParameterList(ParameterList pl) {
        this.parameterLists.add(pl);
    }

    @Override
    public boolean isDeclaredVoid() {
        return (this.flags & 0x400000) != 0;
    }

    public void setDeclaredVoid(boolean declaredVoid) {
        this.flags = declaredVoid ? (this.flags |= 0x400000) : (this.flags &= 0xFFBFFFFF);
    }

    public boolean isDeferred() {
        return (this.flags & 0x800000) != 0;
    }

    public void setDeferred(boolean deferred) {
        this.flags = deferred ? (this.flags |= 0x800000) : (this.flags &= 0xFF7FFFFF);
    }

    @Override
    public Parameter getParameter(String name) {
        for (Declaration d : this.getMembers()) {
            if (!d.isParameter() || !ModelUtil.isNamed(name, d)) continue;
            FunctionOrValue mod = (FunctionOrValue)d;
            return mod.getInitializerParameter();
        }
        return null;
    }

    @Override
    public boolean isFunctional() {
        return true;
    }

    public void setAnonymous(boolean anonymous) {
        this.flags = anonymous ? (this.flags |= 0x1000000) : (this.flags &= 0xFEFFFFFF);
    }

    @Override
    public boolean isAnonymous() {
        return (this.flags & 0x1000000) != 0;
    }

    @Override
    public boolean isNamed() {
        return (this.flags & 0x1000000) == 0;
    }

    @Override
    public Backends getScopedBackends() {
        return super.getScopedBackends();
    }

    @Override
    public String toString() {
        Type type = this.getType();
        if (type == null) {
            return "function " + this.toStringName();
        }
        StringBuilder params = new StringBuilder();
        for (ParameterList pl : this.getParameterLists()) {
            params.append("(");
            boolean first = true;
            for (Parameter p : pl.getParameters()) {
                if (first) {
                    first = false;
                } else {
                    params.append(", ");
                }
                if (p.getType() != null) {
                    params.append(p.getType().asString());
                    params.append(" ");
                }
                params.append(p.getName());
            }
            params.append(")");
        }
        return "function " + this.toStringName() + params + " => " + type.asString();
    }
}

