/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationKind;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import java.util.ArrayList;
import java.util.List;

public abstract class FunctionOrValue
extends TypedDeclaration {
    private static final int CAPTURED = 131072;
    private static final int SHORTCUT_REFINEMENT = 262144;
    private static final int OVERLOADED = 524288;
    private static final int ABSTRACTION = 0x100000;
    private static final int IMPLEMENTED = 0x200000;
    private Parameter initializerParameter;
    private List<Declaration> members = new ArrayList<Declaration>(3);
    private List<Annotation> annotations = new ArrayList<Annotation>(4);
    private List<Declaration> overloads;

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<Declaration> getMembers() {
        return this.members;
    }

    public void addMember(Declaration declaration) {
        this.members.add(declaration);
    }

    public boolean isShortcutRefinement() {
        return (this.flags & 0x40000) != 0;
    }

    public void setShortcutRefinement(boolean shortcutRefinement) {
        this.flags = shortcutRefinement ? (this.flags |= 0x40000) : (this.flags &= 0xFFFBFFFF);
    }

    @Override
    public DeclarationKind getDeclarationKind() {
        return DeclarationKind.MEMBER;
    }

    public Parameter getInitializerParameter() {
        return this.initializerParameter;
    }

    public void setInitializerParameter(Parameter d) {
        this.initializerParameter = d;
    }

    @Override
    public boolean isParameter() {
        return this.initializerParameter != null;
    }

    public boolean isTransient() {
        return true;
    }

    @Override
    public boolean isCaptured() {
        return (this.flags & 0x20000) != 0;
    }

    public void setCaptured(boolean captured) {
        this.flags = captured ? (this.flags |= 0x20000) : (this.flags &= 0xFFFDFFFF);
    }

    @Override
    public boolean isOverloaded() {
        return (this.flags & 0x80000) != 0;
    }

    public void setOverloaded(boolean overloaded) {
        this.flags = overloaded ? (this.flags |= 0x80000) : (this.flags &= 0xFFF7FFFF);
    }

    public void setAbstraction(boolean abstraction) {
        this.flags = abstraction ? (this.flags |= 0x100000) : (this.flags &= 0xFFEFFFFF);
    }

    @Override
    public boolean isAbstraction() {
        return (this.flags & 0x100000) != 0;
    }

    @Override
    public List<Declaration> getOverloads() {
        return this.overloads;
    }

    public void setOverloads(List<Declaration> overloads) {
        this.overloads = overloads;
    }

    public void initOverloads(FunctionOrValue ... initial) {
        this.overloads = new ArrayList<Declaration>(initial.length + 1);
        for (FunctionOrValue d : initial) {
            this.overloads.add(d);
        }
    }

    public boolean isImplemented() {
        return (this.flags & 0x200000) != 0;
    }

    public void setImplemented(boolean implemented) {
        this.flags = implemented ? (this.flags |= 0x200000) : (this.flags &= 0xFFDFFFFF);
    }
}

