/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import java.util.List;
import java.util.Objects;

public class Interface
extends ClassOrInterface {
    private String javaCompanionClassName;
    private Boolean companionClassNeeded;

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Empty");
    }

    @Override
    public boolean isSequence() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Sequence");
    }

    @Override
    public boolean isSequential() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Sequential");
    }

    @Override
    public boolean isIterable() {
        return Objects.equals(this.getQualifiedNameString(), "ceylon.language::Iterable");
    }

    @Override
    public boolean inherits(TypeDeclaration dec) {
        if (dec == null) {
            return false;
        }
        if (dec.isAnything() || dec.isObject()) {
            return true;
        }
        if (dec instanceof Class) {
            return false;
        }
        if (dec instanceof Interface && this.equals(dec)) {
            return true;
        }
        if (dec instanceof Interface) {
            List<Type> sts = this.getSatisfiedTypes();
            int s = sts.size();
            for (int i = 0; i < s; ++i) {
                Type st = sts.get(i);
                if (!st.getDeclaration().inherits(dec)) continue;
                return true;
            }
        }
        return false;
    }

    public void setJavaCompanionClassName(String name) {
        this.javaCompanionClassName = name;
    }

    public String getJavaCompanionClassName() {
        return this.javaCompanionClassName;
    }

    public Boolean isCompanionClassNeeded() {
        return this.companionClassNeeded;
    }

    public void setCompanionClassNeeded(Boolean companionClassNeeded) {
        this.companionClassNeeded = companionClassNeeded;
    }

    @Override
    public boolean isEmptyType() {
        return this.isEmpty();
    }

    @Override
    public boolean isSequentialType() {
        return this.isSequential() || this.isSequence() || this.isEmpty();
    }

    @Override
    public boolean isSequenceType() {
        return this.isSequence();
    }

    @Override
    public String toString() {
        return "interface " + this.toStringName();
    }
}

