/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationKind;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.UnionType;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.ArrayList;
import java.util.List;

public class IntersectionType
extends TypeDeclaration {
    public IntersectionType(Unit unit) {
        this.unit = unit;
    }

    @Override
    protected boolean needsSatisfiedTypes() {
        return false;
    }

    @Override
    public void addMember(Declaration declaration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.getType().asString();
    }

    @Override
    public String getName(Unit unit) {
        return this.getType().asString(unit);
    }

    @Override
    public String getQualifiedNameString() {
        return this.getType().asQualifiedString();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isEmptyType() {
        for (Type st : this.getSatisfiedTypes()) {
            if (!st.getDeclaration().isEmptyType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTupleType() {
        for (Type st : this.getSatisfiedTypes()) {
            if (!st.getDeclaration().isTupleType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSequenceType() {
        for (Type st : this.getSatisfiedTypes()) {
            if (!st.getDeclaration().isSequenceType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSequentialType() {
        for (Type st : this.getSatisfiedTypes()) {
            if (!st.getDeclaration().isSequentialType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Type getType() {
        List<Type> sts = this.getSatisfiedTypes();
        for (Type pt : sts) {
            if (pt != null && !pt.isUnknown()) continue;
            ArrayList<Type> list = new ArrayList<Type>(sts.size() - 1);
            for (Type st : sts) {
                if (st == null || st.isUnknown()) continue;
                list.add(st);
            }
            return ModelUtil.intersection(list, this.unit);
        }
        if (sts.isEmpty()) {
            return this.unit.getAnythingType();
        }
        if (sts.size() == 1) {
            return sts.get(0).getType();
        }
        return super.getType();
    }

    public TypeDeclaration canonicalize() {
        Type st;
        List<Type> sts = this.getSatisfiedTypes();
        if (sts.isEmpty()) {
            return this.unit.getAnythingDeclaration();
        }
        if (sts.size() == 1 && (st = sts.get(0)).isExactlyNothing()) {
            return this.unit.getNothingDeclaration();
        }
        for (Type st2 : sts) {
            if (!st2.isUnion()) continue;
            List<Type> caseTypes = st2.getCaseTypes();
            ArrayList<Type> ulist = new ArrayList<Type>(caseTypes.size());
            for (Type ct : caseTypes) {
                ArrayList<Type> ilist = new ArrayList<Type>(sts.size());
                for (Type pt : sts) {
                    if (pt == st2) {
                        ModelUtil.addToIntersection(ilist, ct, this.unit);
                        continue;
                    }
                    ModelUtil.addToIntersection(ilist, pt, this.unit);
                }
                Type it = ModelUtil.canonicalIntersection(ilist, this.unit);
                ModelUtil.addToUnion(ulist, it);
            }
            UnionType result = new UnionType(this.unit);
            result.setCaseTypes(ulist);
            return result;
        }
        return this;
    }

    @Override
    public DeclarationKind getDeclarationKind() {
        return null;
    }

    @Override
    void collectSupertypeDeclarations(List<TypeDeclaration> results) {
        List<Type> stds = this.getSatisfiedTypes();
        int l = stds.size();
        for (int i = 0; i < l; ++i) {
            Type st = stds.get(i);
            st.getDeclaration().collectSupertypeDeclarations(results);
        }
    }

    @Override
    public boolean inherits(TypeDeclaration dec) {
        if (dec == null) {
            return false;
        }
        if (dec.isAnything()) {
            return true;
        }
        List<Type> sts = this.getSatisfiedTypes();
        int s = sts.size();
        for (int i = 0; i < s; ++i) {
            Type st = sts.get(i);
            if (!st.getDeclaration().inherits(dec)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        throw new UnsupportedOperationException("intersection types don't have well-defined equality");
    }

    @Override
    protected int hashCodeForCache() {
        int ret = 17;
        List<Type> satisfiedTypes = this.getSatisfiedTypes();
        int l = satisfiedTypes.size();
        for (int i = 0; i < l; ++i) {
            ret = 37 * ret + satisfiedTypes.get(i).hashCode();
        }
        return ret;
    }

    @Override
    protected boolean equalsForCache(Object o) {
        if (o == null || !(o instanceof IntersectionType)) {
            return false;
        }
        IntersectionType b = (IntersectionType)o;
        List<Type> satisfiedTypesA = this.getSatisfiedTypes();
        List<Type> satisfiedTypesB = b.getSatisfiedTypes();
        if (satisfiedTypesA.size() != satisfiedTypesB.size()) {
            return false;
        }
        int l = satisfiedTypesA.size();
        for (int i = 0; i < l; ++i) {
            if (satisfiedTypesA.get(i).equals(satisfiedTypesB.get(i))) continue;
            return false;
        }
        return true;
    }
}

