/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import java.util.Map;

public abstract class LazyType
extends Type {
    private boolean initialized;
    private Unit unit;

    public LazyType(Unit unit) {
        this.unit = unit;
    }

    @Override
    public TypeDeclaration getDeclaration() {
        if (this.initialized) {
            TypeDeclaration dec = super.getDeclaration();
            if (dec == null) {
                return new UnknownType(this.unit);
            }
            return dec;
        }
        this.initialized = true;
        TypeDeclaration dec = this.initDeclaration();
        if (dec == null) {
            return new UnknownType(this.unit);
        }
        this.setDeclaration(dec);
        this.setTypeArguments(this.initTypeArguments());
        this.setQualifyingType(this.initQualifyingType());
        return dec;
    }

    @Override
    public Map<TypeParameter, Type> getTypeArguments() {
        this.getDeclaration();
        return super.getTypeArguments();
    }

    public abstract Map<TypeParameter, Type> initTypeArguments();

    public abstract TypeDeclaration initDeclaration();

    public Type initQualifyingType() {
        return null;
    }
}

